/*
 * Decompiled with CFR 0.152.
 */
package Config;

import MainMenu.AppUI;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.ScanComm;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class FlagForm
extends JFrame {
    public static String displayPreferencePres;
    public static String displayPreferenceTemp;
    public static String displayPreferenceDual;
    public static String displayPreferenceUnits;
    public static String displayPreferenceNoAvg;
    public static String displayPreferenceAvgFirstFourHours;
    public static String displayPreferenceBlind;
    public static boolean displayOptionsWriteSuccess;
    public boolean reconConnected;
    private static JButton btnApplySpecial;
    private static JButton btnFlagDefaults;
    private JComboBox<String> cboBlindMode;
    private JComboBox<String> cboDispIncFirstFourHours;
    private JComboBox<String> cboDualChamberSelect;
    private JComboBox<String> cboPressureSelect;
    private JComboBox<String> cboRadonUnitSelect;
    private JComboBox<String> cboTemperatureSelect;
    private JComboBox<String> cboToggleNoAveraging;
    private JLabel lblBlindMode;
    private JLabel lblDispIncFirstFourHours;
    private JLabel lblDisplayedReadingInterval;
    private JLabel lblDualChamber;
    private JLabel lblExposureUnits;
    private JLabel lblPressure;
    private JLabel lblPreviewCh1;
    private JLabel lblPreviewCh2;
    private JLabel lblPreviewHum;
    private JLabel lblPreviewPres;
    private JLabel lblPreviewRun;
    private JLabel lblPreviewRuntime;
    private JLabel lblPreviewTemp;
    private JLabel lblTemperature;
    private JPanel pnlMockReconDisplay;

    public FlagForm() {
        this.initComponents();
        try {
            if (ScanComm.run(1) != AppUI.RDevice.RECON) {
                MainMenuUI.appUI.HideReconConnectedComponents();
                JOptionPane.showMessageDialog(this, "You must connect a Recon to use this feature.\r\nPlug in the USB cable, turn the key to the middle\r\nposition, and reopen the Display Options window.");
                this.reconConnected = false;
                this.cboPressureSelect.setEnabled(false);
                this.cboTemperatureSelect.setEnabled(false);
                this.cboDualChamberSelect.setEnabled(false);
                this.cboRadonUnitSelect.setEnabled(false);
                this.cboToggleNoAveraging.setEnabled(false);
                this.cboDispIncFirstFourHours.setEnabled(false);
                btnApplySpecial.setEnabled(false);
                btnFlagDefaults.setEnabled(false);
                this.cboBlindMode.setEnabled(false);
            } else {
                this.reconConnected = true;
                MainMenuUI.appUI.deviceType = ScanComm.run(10);
            }
        }
        catch (Exception ex) {
            Logging.main(ex.toString());
        }
        if (displayPreferencePres == "mBar") {
            this.cboPressureSelect.setSelectedItem("mBar");
        } else {
            this.cboPressureSelect.setSelectedItem("inHG");
        }
        if (displayPreferenceTemp == "F") {
            this.cboTemperatureSelect.setSelectedItem("F");
        } else {
            this.cboTemperatureSelect.setSelectedItem("C");
        }
        if (displayPreferenceDual == "no") {
            this.cboDualChamberSelect.setSelectedItem("No");
        } else {
            this.cboDualChamberSelect.setSelectedItem("Yes");
        }
        if (displayPreferenceUnits == "pCi/L") {
            this.cboRadonUnitSelect.setSelectedItem("pCi/L");
        } else if (displayPreferenceUnits == "Bq/m3") {
            this.cboRadonUnitSelect.setSelectedItem("Bq/m3");
        } else if (displayPreferenceUnits == "CPH") {
            this.cboRadonUnitSelect.setSelectedItem("CPH");
        }
        if (displayPreferenceNoAvg == "Hourly") {
            this.cboToggleNoAveraging.setSelectedItem("Hourly");
        } else {
            this.cboToggleNoAveraging.setSelectedItem("Ten Mins.");
        }
        if (displayPreferenceAvgFirstFourHours == "Yes") {
            this.cboDispIncFirstFourHours.setSelectedItem("Yes");
        } else {
            this.cboDispIncFirstFourHours.setSelectedItem("No");
        }
        if (displayPreferenceBlind == "No") {
            this.cboBlindMode.setSelectedItem("No");
        } else {
            this.cboBlindMode.setSelectedItem("Yes");
        }
    }

    private void initComponents() {
        this.lblPressure = new JLabel();
        this.lblTemperature = new JLabel();
        this.lblDualChamber = new JLabel();
        this.lblExposureUnits = new JLabel();
        this.cboPressureSelect = new JComboBox();
        this.cboTemperatureSelect = new JComboBox();
        this.cboDualChamberSelect = new JComboBox();
        this.cboRadonUnitSelect = new JComboBox();
        btnApplySpecial = new JButton();
        this.cboToggleNoAveraging = new JComboBox();
        this.lblDisplayedReadingInterval = new JLabel();
        btnFlagDefaults = new JButton();
        this.lblDispIncFirstFourHours = new JLabel();
        this.cboDispIncFirstFourHours = new JComboBox();
        this.pnlMockReconDisplay = new JPanel();
        this.lblPreviewRun = new JLabel();
        this.lblPreviewRuntime = new JLabel();
        this.lblPreviewTemp = new JLabel();
        this.lblPreviewHum = new JLabel();
        this.lblPreviewPres = new JLabel();
        this.lblPreviewCh1 = new JLabel();
        this.lblPreviewCh2 = new JLabel();
        this.lblBlindMode = new JLabel();
        this.cboBlindMode = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Recon Run Time Display Settings");
        this.setAlwaysOnTop(true);
        this.lblPressure.setText("Pres. Unit");
        this.lblTemperature.setText("Temp. Unit");
        this.lblDualChamber.setText("Dual Chamber");
        this.lblExposureUnits.setText("Radon Unit");
        this.cboPressureSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"mBar", "inHG"}));
        this.cboPressureSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboPressureSelectActionPerformed(evt);
            }
        });
        this.cboTemperatureSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"F", "C"}));
        this.cboTemperatureSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboTemperatureSelectActionPerformed(evt);
            }
        });
        this.cboDualChamberSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"No", "Yes"}));
        this.cboDualChamberSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboDualChamberSelectActionPerformed(evt);
            }
        });
        this.cboRadonUnitSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"pCi/L", "Bq/m3", "CPH"}));
        this.cboRadonUnitSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboRadonUnitSelectActionPerformed(evt);
            }
        });
        btnApplySpecial.setText("Apply");
        btnApplySpecial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.btnApplySpecialActionPerformed(evt);
            }
        });
        this.cboToggleNoAveraging.setModel(new DefaultComboBoxModel<String>(new String[]{"Hourly", "Ten Mins."}));
        this.cboToggleNoAveraging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboToggleNoAveragingActionPerformed(evt);
            }
        });
        this.lblDisplayedReadingInterval.setText("Rolling Average");
        btnFlagDefaults.setText("Defaults");
        btnFlagDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.btnFlagDefaultsActionPerformed(evt);
            }
        });
        this.lblDispIncFirstFourHours.setText("Inc. First Four");
        this.cboDispIncFirstFourHours.setModel(new DefaultComboBoxModel<String>(new String[]{"No", "Yes"}));
        this.cboDispIncFirstFourHours.setToolTipText("Selecting Yes will incorporate the four hour equilibrium period into the final average when ending the test. Rad Elec recommends against this unless explicitly allowed in your state. ");
        this.cboDispIncFirstFourHours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboDispIncFirstFourHoursActionPerformed(evt);
            }
        });
        this.pnlMockReconDisplay.setBorder(BorderFactory.createBevelBorder(0));
        this.lblPreviewRun.setHorizontalAlignment(0);
        this.lblPreviewRun.setText("Run:");
        this.lblPreviewRuntime.setHorizontalAlignment(0);
        this.lblPreviewRuntime.setText("2:25");
        this.lblPreviewTemp.setHorizontalAlignment(0);
        this.lblPreviewTemp.setText("64F");
        this.lblPreviewHum.setHorizontalAlignment(0);
        this.lblPreviewHum.setText("28%");
        this.lblPreviewPres.setHorizontalAlignment(0);
        this.lblPreviewPres.setText("1015mB");
        this.lblPreviewCh1.setHorizontalAlignment(0);
        this.lblPreviewCh1.setText("14.6 pCi/L");
        this.lblPreviewCh2.setHorizontalAlignment(0);
        this.lblPreviewCh2.setText("14.6 pCi/L");
        GroupLayout pnlMockReconDisplayLayout = new GroupLayout(this.pnlMockReconDisplay);
        this.pnlMockReconDisplay.setLayout(pnlMockReconDisplayLayout);
        pnlMockReconDisplayLayout.setHorizontalGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addGap(41, 41, 41).addGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.lblPreviewCh1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPreviewCh2)).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addComponent(this.lblPreviewTemp).addGap(29, 29, 29).addComponent(this.lblPreviewHum).addGap(18, 18, 18).addComponent(this.lblPreviewPres)))).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.lblPreviewRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPreviewRuntime))).addContainerGap(-1, Short.MAX_VALUE)));
        pnlMockReconDisplayLayout.setVerticalGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMockReconDisplayLayout.createSequentialGroup().addContainerGap().addGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPreviewRun).addComponent(this.lblPreviewRuntime)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPreviewTemp).addComponent(this.lblPreviewHum).addComponent(this.lblPreviewPres)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlMockReconDisplayLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPreviewCh1).addComponent(this.lblPreviewCh2)).addContainerGap(19, Short.MAX_VALUE)));
        this.lblBlindMode.setText("Blind Mode");
        this.cboBlindMode.setModel(new DefaultComboBoxModel<String>(new String[]{"No", "Yes"}));
        this.cboBlindMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlagForm.this.cboBlindModeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(btnFlagDefaults, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(btnApplySpecial, -2, 96, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblPressure).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboPressureSelect, -2, -1, -2).addComponent(this.lblExposureUnits).addComponent(this.cboRadonUnitSelect, -2, -1, -2).addComponent(this.lblDisplayedReadingInterval).addComponent(this.cboToggleNoAveraging, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlMockReconDisplay, -1, -1, Short.MAX_VALUE))).addGap(24, 24, 24)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBlindMode).addComponent(this.cboBlindMode, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboDualChamberSelect, -2, -1, -2).addComponent(this.lblDualChamber).addComponent(this.lblTemperature).addComponent(this.cboTemperatureSelect, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboDispIncFirstFourHours, -2, -1, -2).addComponent(this.lblDispIncFirstFourHours))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPressure).addComponent(this.lblDualChamber)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboDualChamberSelect, -2, -1, -2).addComponent(this.cboPressureSelect, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblTemperature).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboTemperatureSelect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDispIncFirstFourHours)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExposureUnits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboRadonUnitSelect, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDisplayedReadingInterval))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 3, Short.MAX_VALUE).addComponent(this.cboToggleNoAveraging, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.cboDispIncFirstFourHours, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.pnlMockReconDisplay, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnApplySpecial).addComponent(btnFlagDefaults, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblBlindMode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboBlindMode, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        this.UpdateRadonLabelText();
        this.pack();
    }

    private void cboDualChamberSelectActionPerformed(ActionEvent evt) {
        if (this.cboDualChamberSelect.getSelectedItem().equals("Yes")) {
            displayPreferenceDual = "yes";
            this.lblPreviewCh2.setVisible(true);
        } else {
            displayPreferenceDual = "no";
            this.lblPreviewCh2.setVisible(false);
        }
        this.UpdateRadonLabelText();
    }

    private void cboTemperatureSelectActionPerformed(ActionEvent evt) {
        if (this.cboTemperatureSelect.getSelectedItem().equals("F")) {
            displayPreferenceTemp = "F";
            this.lblPreviewTemp.setText("64F");
        } else {
            displayPreferenceTemp = "C";
            this.lblPreviewTemp.setText("18C");
        }
    }

    private void cboRadonUnitSelectActionPerformed(ActionEvent evt) {
        if (this.cboRadonUnitSelect.getSelectedItem().equals("pCi/L")) {
            displayPreferenceUnits = "pCi/L";
        } else if (this.cboRadonUnitSelect.getSelectedItem().equals("Bq/m3")) {
            displayPreferenceUnits = "Bq/m3";
        } else if (this.cboRadonUnitSelect.getSelectedItem().equals("CPH")) {
            displayPreferenceUnits = "CPH";
        }
        this.UpdateRadonLabelText();
    }

    private void cboPressureSelectActionPerformed(ActionEvent evt) {
        if (this.cboPressureSelect.getSelectedItem().equals("inHG")) {
            displayPreferencePres = "inHG";
            this.lblPreviewPres.setText("29.97IN");
        } else {
            displayPreferencePres = "mBar";
            this.lblPreviewPres.setText("1015mB");
        }
    }

    private void btnApplySpecialActionPerformed(ActionEvent evt) {
        System.out.println("Attempting to write flag value.");
        displayOptionsWriteSuccess = false;
        String selectedOptions = null;
        try {
            MainMenuUI.appUI.deviceType = ScanComm.run(8);
            if (displayOptionsWriteSuccess) {
                selectedOptions = "Temp: " + this.cboTemperatureSelect.getSelectedItem() + "\r\nPres: " + this.cboPressureSelect.getSelectedItem() + "\r\nUnit: " + this.cboRadonUnitSelect.getSelectedItem() + "\r\nDual chamber: " + this.cboDualChamberSelect.getSelectedItem() + "\r\nRdg. updated: " + this.cboToggleNoAveraging.getSelectedItem() + "\r\nFirst four hours: " + this.cboDispIncFirstFourHours.getSelectedItem() + "\r\nBlind mode: " + this.cboBlindMode.getSelectedItem() + "\r\n";
                JOptionPane.showMessageDialog(this, "Settings saved successfully:\r\n" + selectedOptions + "\r\n");
            } else {
                JOptionPane.showMessageDialog(this, "ERROR! Please verify Recon is connected\r\nand in I/O mode and try again.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cboToggleNoAveragingActionPerformed(ActionEvent evt) {
        displayPreferenceNoAvg = this.cboToggleNoAveraging.getSelectedItem().equals("Ten Mins.") ? "Ten Mins." : "Hourly";
    }

    private void btnFlagDefaultsActionPerformed(ActionEvent evt) {
        this.SetLabelsToDefault();
    }

    private void cboDispIncFirstFourHoursActionPerformed(ActionEvent evt) {
        displayPreferenceAvgFirstFourHours = this.cboDispIncFirstFourHours.getSelectedItem().equals("No") ? "No" : "Yes";
    }

    private void cboBlindModeActionPerformed(ActionEvent evt) {
        displayPreferenceBlind = this.cboBlindMode.getSelectedItem().equals("No") ? "No" : "Yes";
        this.UpdateRadonLabelText();
    }

    public static void main(String[] args) {
    }

    private void UpdateRadonLabelText() {
        if (this.cboBlindMode.getSelectedItem().equals("Yes")) {
            this.lblPreviewCh1.setText("");
            this.lblPreviewCh2.setText("");
            return;
        }
        if (this.cboRadonUnitSelect.getSelectedItem().equals("pCi/L")) {
            if (displayPreferenceDual == "yes") {
                this.lblPreviewCh1.setText("14.6 ");
                this.lblPreviewCh2.setText("14.6 pCi/L");
            } else {
                this.lblPreviewCh1.setText("14.6 pCi/L");
            }
        } else if (this.cboRadonUnitSelect.getSelectedItem().equals("Bq/m3")) {
            if (displayPreferenceDual == "yes") {
                this.lblPreviewCh1.setText("540 ");
                this.lblPreviewCh2.setText("540 Bq/m3");
            } else {
                this.lblPreviewCh1.setText("540 Bq/m3");
            }
        } else if (this.cboRadonUnitSelect.getSelectedItem().equals("CPH")) {
            if (displayPreferenceDual == "yes") {
                this.lblPreviewCh1.setText("87 ");
                this.lblPreviewCh2.setText("87 CPH");
            } else {
                this.lblPreviewCh1.setText("87 CPH");
            }
        }
    }

    private void SetLabelsToDefault() {
        this.cboPressureSelect.setSelectedItem("inHG");
        this.cboTemperatureSelect.setSelectedItem("F");
        this.cboDualChamberSelect.setSelectedItem("No");
        this.cboRadonUnitSelect.setSelectedItem("pCi/L");
        this.cboToggleNoAveraging.setSelectedItem("Hourly");
        this.cboDispIncFirstFourHours.setSelectedItem("No");
        this.cboBlindMode.setSelectedItem("No");
        displayPreferencePres = "inHG";
        displayPreferenceTemp = "F";
        displayPreferenceDual = "no";
        displayPreferenceUnits = "pCi/L";
        displayPreferenceNoAvg = "Hourly";
        displayPreferenceAvgFirstFourHours = "No";
        displayPreferenceBlind = "No";
    }

    public static void EnableAllButtons(boolean boolEnableButtons) {
        btnApplySpecial.setEnabled(boolEnableButtons);
        btnFlagDefaults.setEnabled(boolEnableButtons);
    }
}

