/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.Config;
import Config.FlagForm;
import MainMenu.CreateJSONData;
import MainMenu.CreatePDF;
import MainMenu.DataExporter;
import MainMenu.InitDirs;
import MainMenu.LegacyUI;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.MyJSONObject;
import MainMenu.ReconProtocol;
import MainMenu.ScanComm;
import MainMenu.TMProtocol;
import java.awt.Desktop;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jxl.read.biff.BiffException;
import jxl.write.WriteException;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class AppUI
extends JFrame {
    String version = "v1.1.30";
    public static boolean isFileLoaded = false;
    public static boolean rewriteDataFile = false;
    public static volatile boolean recoveringDataFile = false;
    public static String newline = System.getProperty("line.separator");
    public static boolean initializedLogging = false;
    public RDevice deviceType = RDevice.NONE;
    public static String lastSentCommand = "";
    public static long LastCount_Ch1 = 0L;
    public static long LastCount_Ch2 = 0L;
    static String stickerCalDate = "Unknown";
    static String stickerNextCalDate = "Unknown";
    public static double numFirmwareRevision = 0.0;
    public static String strLoadedFilePath = "Unknown";
    public static String strLoadedFileName = "Unknown";
    public boolean invalidFilename = true;
    public static LinkedList<String> sessionStrings = new LinkedList();
    public static LinkedList<String> dateFormatStrings = new LinkedList();
    public static double ConsecutiveZeroLimit = 5.0;
    protected static String startDateTime;
    protected static String endDateTime;
    public static String strCompanyName;
    public static String strAddress1;
    public static String strAddress2;
    public static String strAddress3;
    public static String unitType;
    public static boolean displayLogo;
    public static int displaySig;
    public static boolean highlightAverage;
    public static boolean openPDFWind;
    public static int tiltSensitivity;
    public static boolean autoLoadFile;
    public static boolean boolUseTwoChambers;
    public static boolean boolShowCMButton;
    public static boolean boolShowWXButton;
    public static boolean boolShowXLSHighlights;
    public static boolean countLimiter;
    public static boolean photodiodeFailureRecovery;
    public static boolean excludeFirst4Hours;
    public static String strPageSizePDF;
    public static PDRectangle pageSizePDF;
    public static boolean autoGeneratePDF;
    public static boolean configNagDownload;
    public static boolean usingLegacyUI;
    public static boolean archiveImportedFiles;
    public static boolean allowDataRangeSetting;
    public static String strJavaLookAndFeel;
    public static String strFlatLafTheme;
    public static String strProtocol;
    public static String strTampering;
    public static String strWeather;
    public static String strMitigation;
    public static String strComment;
    public static String strDeployedBy;
    public static String strRetrievedBy;
    public static String strAnalyzedBy;
    public static String strReportText;
    public static boolean forceMainMenuUI;
    public static String strUserComPort;
    public static boolean autoResetTM;
    public static int intDateFormatIndex;
    public static String strDateFormat;
    public static boolean use24HourTime;
    public static boolean showDepInfXLSXReport;
    public static String strChartRangeRadon;
    public static String strChartRangeHumidity;
    public static String strChartRangeTemperatureUS;
    public static String strChartRangeTemperatureSI;
    public static String strChartRangePressureUS;
    public static String strChartRangePressureSI;
    public static String strChartRangeTilts;
    public static String strChartTickUnitRadon;
    public static String strChartTickUnitHumidity;
    public static String strChartTickUnitTemperatureUS;
    public static String strChartTickUnitTemperatureSI;
    public static String strChartTickUnitPressureUS;
    public static String strChartTickUnitPressureSI;
    public static String strChartTickUnitTilts;
    public static String strChartFractionDigitsRadonUS;
    public static String strChartFractionDigitsRadonSI;
    public static String strChartFractionDigitsTemperatureUS;
    public static String strChartFractionDigitsTemperatureSI;
    public static String strChartFractionDigitsPressureUS;
    public static String strChartFractionDigitsPressureSI;
    public static String strChartFractionDigitsHumidity;
    public static String strChartFractionDigitsTilts;
    public static float fltChartStrokeRadonAvg;
    public static float fltChartStrokeRadon1;
    public static float fltChartStrokeRadon2;
    public static float fltChartStrokeHumidity;
    public static float fltChartStrokeTemperature;
    public static float fltChartStrokePressure;
    public static float fltChartStrokeTilts;
    public static String strChartColorRadonAvg;
    public static String strChartColorRadon1;
    public static String strChartColorRadon2;
    public static String strChartColorHumidity;
    public static String strChartColorTemperature;
    public static String strChartColorPressure;
    public static String strChartColorTilts;
    public static String strChartColorBackground;
    public static String strChartColorXAxisLabels;
    public static String strChartColorLegendBackground;
    public static String strChartColorLegendLabels;
    public static int intChartImageWidth;
    public static int intChartImageHeight;
    public static int intPDFMarginTop;
    public static int intPDFMarginBottom;
    public static int intPDFMarginSide;
    public static int intPDFBannerFontSize;
    public static int intPDFFooterFontSize;
    public static int intPDFHeadingFontSize;
    public static int intPDFPrimaryFontSize;
    public static String strPDFPrimaryFontColor;
    public static String strPDFBannerFontColor;
    public static String strPDFHourlyDetailedFontColor;
    public static String strPDFHourlyExcludedFontColor;
    public static String strPDFHighlightColor;
    public static String strPDFLineColor;
    public static String strPDFBackgroundColor;
    public static SimpleDateFormat dateFormat;
    public static SimpleDateFormat dateTimeFormat;
    public static SimpleDateFormat dateFormatCalibration;
    public static SimpleDateFormat dateFormatStartEndTime;
    public static SimpleDateFormat niceDateFormat;
    protected JButton btnAllDataDump;
    protected JButton btnClearMemory;
    protected JButton btnClearSession;
    protected JButton btnClearTamperFlag;
    protected static JButton btnCloseFile;
    protected JButton btnCloseProgram;
    public static JButton btnConfig;
    protected JButton btnConnect;
    protected JButton btnDisplaySettings;
    protected JButton btnDownloadSession;
    protected static JButton btnRange;
    protected JButton btnEraseReconData;
    protected JButton btnExport;
    protected JButton btnTestDetails;
    public static JButton btnGeneratePDF;
    public static JButton btnMainImages;
    protected JButton btnOpenPDF;
    protected JButton btnOpenSavedFile;
    protected JButton btnSyncTime;
    public static JComboBox<String> cboSessionSelect;
    public JCheckBox chkUseStreetAddressForFilename;
    protected JScrollPane jScrollPane1;
    protected JScrollPane jScrollPane2;
    protected static JLabel lblCalibrationDate;
    protected static JLabel lblCalibrationDue;
    public static JLabel lblDataSessions;
    protected JLabel lblEndDateTime;
    protected static JLabel lblEndDateTimeDynamic;
    public static JLabel lblFinalAvg;
    public static JLabel lblFirmwareVersion;
    public static JLabel lblLoadedFile;
    public static JLabel lblLoadedFileName;
    protected JLabel lblLocation;
    protected JLabel lblMainAnalyzedBy;
    protected JLabel lblMainComment;
    protected JLabel lblMainDeployedBy;
    protected JLabel lblMainMitigation;
    protected JLabel lblMainProtocol;
    protected JLabel lblMainRetrievedBy;
    protected JLabel lblMainTampering;
    protected JLabel lblMainWeather;
    protected JLabel lblRadonScoutQuickCal = new JLabel();
    public static JLabel lblReconSN;
    protected JLabel lblStartDate;
    protected static JLabel lblStartDateTimeDynamic;
    protected JLabel lblStatusNoRecon;
    public static JLabel lblSystemConsole;
    protected JLabel lblTestSiteInfo;
    protected JLabel lblTestSiteInfo1;
    protected JLabel lblTotalHours;
    protected static JLabel lblTotalHoursDynamic;
    public static JLabel lblVersion;
    protected JLabel limiterLabel;
    protected JPanel pnlAppControl;
    protected JPanel pnlApplicationLog;
    protected JPanel pnlDisplayHelp;
    protected JPanel pnlFileMgmt;
    public static JPanel pnlGraph;
    protected JPanel pnlMainDeployment;
    protected JPanel pnlReconButtons;
    protected JPanel pnlReconStatus;
    protected static JPanel pnlStartEndDate;
    protected JScrollPane scrollPaneLog;
    public static JTextArea txtCustomerInfo;
    public static JTextField txtLocation;
    public static JTextArea txtLogScroll;
    public static JTextField txtMainAnalyzedBy;
    public static JTextField txtMainComment;
    public static JTextField txtMainDeployedBy;
    public static JTextField txtMainMitigation;
    public static JTextField txtMainProtocol;
    public static JTextField txtMainRetrievedBy;
    public static JTextField txtMainTampering;
    public static JTextField txtMainWeather;
    public JTextField txtNewFileName;
    public static JTextArea txtTestSiteInfo;

    public void SetDateFormats() {
        strDateFormat = dateFormatStrings.get(intDateFormatIndex);
        dateFormat = new SimpleDateFormat(strDateFormat);
        dateTimeFormat = use24HourTime ? new SimpleDateFormat(strDateFormat + " HH:mm") : new SimpleDateFormat(strDateFormat + " h:mm a");
    }

    public String DefaultCalDate() {
        LocalDate caldate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M/dd/yyyy");
        DateTimeFormatter sticker_format = DateTimeFormatter.ofPattern("MMM d, yyyy");
        stickerCalDate = caldate.format(sticker_format);
        return caldate.format(formatter);
    }

    public void SetCalDate(String newDate) {
        if (newDate.contains("255")) {
            stickerCalDate = "Not calibrated";
            return;
        }
        DateTimeFormatter originalFormat = DateTimeFormatter.ofPattern("M/d/yyyy");
        DateTimeFormatter calDateFormat = DateTimeFormatter.ofPattern("MMM d, yyyy");
        LocalDate calDate = LocalDate.parse(newDate, originalFormat);
        stickerCalDate = calDate.format(calDateFormat);
    }

    public String NextCalDate() {
        LocalDate nextcaldate = LocalDate.now().plusYears(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M/dd/yyyy");
        DateTimeFormatter sticker_format = DateTimeFormatter.ofPattern("MMM d, yyyy");
        stickerNextCalDate = nextcaldate.format(sticker_format);
        return nextcaldate.format(formatter);
    }

    public static String NextCalDate(String startDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M/dd/yyyy");
        DateTimeFormatter calDateFormat = DateTimeFormatter.ofPattern("MMM d, yyyy");
        LocalDate nextCalDate = LocalDate.parse(startDate, calDateFormat).plusYears(1L);
        return nextCalDate.format(calDateFormat);
    }

    public void displayProgressLabel(String update_progress) {
        lblSystemConsole.setText(update_progress);
    }

    public void displaySerialNumber(String ReconSerial) {
        lblReconSN.setVisible(true);
        lblReconSN.setText("Device S/N: #" + ReconSerial);
    }

    public void displayFirmwareVersion(String FirmwareVersion) {
        lblFirmwareVersion.setVisible(true);
        lblFirmwareVersion.setText("Firmware v" + FirmwareVersion);
    }

    public void displayDataSessions(RDevice devType, String NumSessions) {
        switch (devType) {
            case TM: {
                lblDataSessions.setText("New data: " + NumSessions);
                lblDataSessions.setVisible(true);
                break;
            }
            case MTM: {
                lblDataSessions.setText("New data: " + NumSessions);
                lblDataSessions.setVisible(true);
                break;
            }
            default: {
                lblDataSessions.setText("Data Sessions: " + NumSessions);
                lblDataSessions.setVisible(true);
            }
        }
    }

    public void displayCalibrationDate(String calDate) {
        lblCalibrationDate.setVisible(true);
        lblCalibrationDate.setText("Calibration Date: " + calDate);
    }

    public void displayCalibrationDue(String calDueDate) {
        lblCalibrationDue.setVisible(true);
        lblCalibrationDue.setText("Calibration Due: " + calDueDate);
    }

    public int getDataSessions() {
        String sessionString = null;
        switch (this.deviceType) {
            case RECON: {
                sessionString = lblDataSessions.getText().substring(15).trim();
                return Integer.parseInt(sessionString);
            }
            case TM: {
                return 1;
            }
            case MTM: {
                return 1;
            }
            case MTM2: {
                sessionString = lblDataSessions.getText().substring(15).trim();
                return Integer.parseInt(sessionString);
            }
        }
        return 0;
    }

    public static double convertFirmwareVersionToNumber() {
        try {
            String strFirmwareRevision = lblFirmwareVersion.getText();
            if (strFirmwareRevision.length() > 10) {
                numFirmwareRevision = Double.parseDouble(strFirmwareRevision.substring(11));
                Logging.main("MainMenuUI.convertFirmwareVersionToNumber() = " + numFirmwareRevision);
                return numFirmwareRevision;
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void createChartJSON() {
        LinkedList<String> jsonStrings = new LinkedList<String>();
        String pathChartJSON = InitDirs.configDir + File.separator + "chart.json";
        MyJSONObject jsonObjChart = new MyJSONObject();
        JSONArray jsonChart = new JSONArray();
        if (new File(pathChartJSON).exists()) {
            return;
        }
        jsonChart.add(new MyJSONObject("ChartRangeRadon", strChartRangeRadon));
        jsonChart.add(new MyJSONObject("ChartRangeHumidity", strChartRangeHumidity));
        jsonChart.add(new MyJSONObject("ChartRangeTemperatureUS", strChartRangeTemperatureUS));
        jsonChart.add(new MyJSONObject("ChartRangeTemperatureSI", strChartRangeTemperatureSI));
        jsonChart.add(new MyJSONObject("ChartRangePressureUS", strChartRangePressureUS));
        jsonChart.add(new MyJSONObject("ChartRangePressureSI", strChartRangePressureSI));
        jsonChart.add(new MyJSONObject("ChartRangeTilts", strChartRangeTilts));
        jsonChart.add(new MyJSONObject("ChartTickUnitRadon", strChartTickUnitRadon));
        jsonChart.add(new MyJSONObject("ChartTickUnitHumidity", strChartTickUnitHumidity));
        jsonChart.add(new MyJSONObject("ChartTickUnitTemperatureUS", strChartTickUnitTemperatureUS));
        jsonChart.add(new MyJSONObject("ChartTickUnitTemperatureSI", strChartTickUnitTemperatureSI));
        jsonChart.add(new MyJSONObject("ChartTickUnitPressureUS", strChartTickUnitPressureUS));
        jsonChart.add(new MyJSONObject("ChartTickUnitPressureSI", strChartTickUnitPressureSI));
        jsonChart.add(new MyJSONObject("ChartTickUnitTilts", strChartTickUnitTilts));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsRadonUS", strChartFractionDigitsRadonUS));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsRadonSI", strChartFractionDigitsRadonSI));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsTemperatureUS", strChartFractionDigitsTemperatureUS));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsTemperatureSI", strChartFractionDigitsTemperatureSI));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsPressureUS", strChartFractionDigitsPressureUS));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsPressureSI", strChartFractionDigitsPressureSI));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsHumidity", strChartFractionDigitsHumidity));
        jsonChart.add(new MyJSONObject("ChartFractionDigitsTilts", strChartFractionDigitsTilts));
        jsonChart.add(new MyJSONObject("ChartStrokeRadonAvg", Float.toString(fltChartStrokeRadonAvg)));
        jsonChart.add(new MyJSONObject("ChartStrokeRadon1", Float.toString(fltChartStrokeRadon1)));
        jsonChart.add(new MyJSONObject("ChartStrokeRadon2", Float.toString(fltChartStrokeRadon2)));
        jsonChart.add(new MyJSONObject("ChartStrokeHumidity", Float.toString(fltChartStrokeHumidity)));
        jsonChart.add(new MyJSONObject("ChartStrokeTemperature", Float.toString(fltChartStrokeTemperature)));
        jsonChart.add(new MyJSONObject("ChartStrokePressure", Float.toString(fltChartStrokePressure)));
        jsonChart.add(new MyJSONObject("ChartStrokeTilts", Float.toString(fltChartStrokeTilts)));
        jsonChart.add(new MyJSONObject("ChartColorRadonAvg", strChartColorRadonAvg));
        jsonChart.add(new MyJSONObject("ChartColorRadon1", strChartColorRadon1));
        jsonChart.add(new MyJSONObject("ChartColorRadon2", strChartColorRadon2));
        jsonChart.add(new MyJSONObject("ChartColorHumidity", strChartColorHumidity));
        jsonChart.add(new MyJSONObject("ChartColorTemperature", strChartColorTemperature));
        jsonChart.add(new MyJSONObject("ChartColorPressure", strChartColorPressure));
        jsonChart.add(new MyJSONObject("ChartColorTilts", strChartColorTilts));
        jsonChart.add(new MyJSONObject("ChartColorBackground", strChartColorBackground));
        jsonChart.add(new MyJSONObject("ChartColorXAxisLabels", strChartColorXAxisLabels));
        jsonChart.add(new MyJSONObject("ChartColorLegendBackground", strChartColorLegendBackground));
        jsonChart.add(new MyJSONObject("ChartColorLegendLabels", strChartColorLegendLabels));
        jsonChart.add(new MyJSONObject("ChartImageWidth", Integer.toString(intChartImageWidth)));
        jsonChart.add(new MyJSONObject("ChartImageHeight", Integer.toString(intChartImageHeight)));
        jsonObjChart.put("Chart", jsonChart);
        jsonStrings.add(jsonObjChart.toJSONString());
        try {
            PrintWriter pw = new PrintWriter(pathChartJSON);
            for (int i = 0; i < jsonStrings.size(); ++i) {
                pw.write((String)jsonStrings.get(i));
            }
            pw.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Unable to create chart.json file!");
        }
    }

    public void createConfigJSON() {
        LinkedList<String> jsonStrings = new LinkedList<String>();
        String newFilename = InitDirs.configDir + File.separator + "config.json";
        MyJSONObject jsonObjCompany = new MyJSONObject();
        MyJSONObject jsonObjOptions = new MyJSONObject();
        MyJSONObject jsonObjDeployment = new MyJSONObject();
        MyJSONObject jsonObjReport = new MyJSONObject();
        JSONArray jsonCompany = new JSONArray();
        JSONArray jsonOptions = new JSONArray();
        JSONArray jsonDeployment = new JSONArray();
        JSONArray jsonReport = new JSONArray();
        String strLocalCompany = "";
        String strLocalCompanyAddr1 = "";
        String strLocalCompanyAddr2 = "";
        String strLocalCompanyAddr3 = "";
        String strLocalUnitType = "US";
        String strLocalDisplayLogo = Boolean.toString(false);
        String strLocalDisplaySig = Integer.toString(1);
        String strLocalHighlightAverage = Boolean.toString(true);
        String strLocalOpenPDFWindow = Boolean.toString(true);
        String strLocalTiltSensitivity = Integer.toString(5);
        String strLocalAutoLoadFile = Boolean.toString(true);
        String strLocalDiagMode = Boolean.toString(false);
        String strLocalCountLimiter = Boolean.toString(true);
        String strLocalPhotodiodeFailureRecovery = Boolean.toString(false);
        String strLocalIncludeFirstFourHours = Boolean.toString(false);
        String strLocalPageSize = "LETTER";
        String strLocalAutoGenPDF = Boolean.toString(true);
        String strLocalDownloadNag = Boolean.toString(true);
        String strLocalLegacyUI = Boolean.toString(false);
        String strLocalArchiveImportedFiles = Boolean.toString(true);
        String strLocalAllowDataRangeSetting = Boolean.toString(false);
        String strLocalJavaLookAndFeel = "FlatLaf";
        String strLocalFlatLafTheme = "Light";
        String strLocalProtocol = "Closed Building Conditions Met";
        String strLocalTampering = "No Tampering Detected";
        String strLocalWeather = "No Abnormal Weather Conditions";
        String strLocalMitigation = "No Mitigation System Installed";
        String strLocalComment = "Thanks for the business!";
        String strLocalDeployedBy = "";
        String strLocalRetrievedBy = "";
        String strLocalAnalyzedBy = "";
        String strLocalReportText = "Radon is the second leading cause of lung cancer after smoking. The U.S. Environmental Protection Agency (US EPA) and the Surgeon General strongly recommend that further action be taken when a home\u2019s radon test results are 4.0 pCi/L or greater. The national average indoor radon level is about 1.3 pCi/L. The higher the home\u2019s radon level, the greater the health risk to you and your family. Reducing your radon levels can be done easily, effectively and fairly inexpensively. Even homes with very high radon levels can be reduced below 4.0 pCi/L. Please refer to the EPA website at www.epa.gov/radon for further information to assist you in evaluating your test results or deciding if further action is needed.";
        File fileCompany = new File(InitDirs.configDir + File.separator + "company.txt");
        File fileConfig = new File(InitDirs.configDir + File.separator + "config.txt");
        File fileDeployment = new File(InitDirs.configDir + File.separator + "deployment.txt");
        File fileReport = new File(InitDirs.configDir + File.separator + "report.txt");
        if (new File(newFilename).exists()) {
            return;
        }
        if (fileCompany.exists() && fileConfig.exists() && fileDeployment.exists() && fileReport.exists()) {
            String strLine;
            BufferedReader br;
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileCompany.getAbsolutePath())));
                strLocalCompany = br.readLine();
                strLocalCompanyAddr1 = br.readLine();
                strLocalCompanyAddr2 = br.readLine();
                strLocalCompanyAddr3 = br.readLine();
                br.close();
            }
            catch (Exception anyEx) {
                Logging.main("createConfigJSON(): Pulling values from company.txt failed.");
                anyEx.printStackTrace();
            }
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileConfig.getAbsolutePath())));
                strLine = br.readLine();
                while (strLine != null) {
                    if (strLine.charAt(0) != '#') {
                        if (strLine.equals("DiagMode=0011")) {
                            strLocalDiagMode = "true";
                        } else if (strLine.contains("COUNT_LIMITER=OFF")) {
                            strLocalCountLimiter = "false";
                        } else if (strLine.contains("PhotodiodeFailureRecovery=")) {
                            strLocalPhotodiodeFailureRecovery = Boolean.toString(strLine.endsWith("1"));
                        } else if (strLine.contains("UnitType=")) {
                            strLocalUnitType = strLine.contains("SI") ? "SI" : "US";
                        } else if (strLine.contains("DisplayLogo=")) {
                            strLocalDisplayLogo = Integer.parseInt(strLine.substring(strLine.length() - 1)) != 0 ? Boolean.toString(true) : Boolean.toString(false);
                        } else if (strLine.contains("DisplaySig=")) {
                            strLocalDisplaySig = strLine.substring(strLine.length() - 1);
                        } else if (strLine.contains("HighlightAverage=")) {
                            strLocalHighlightAverage = Boolean.toString(!strLine.contains("0"));
                        } else if (strLine.contains("OpenPDFWindow=")) {
                            strLocalOpenPDFWindow = Integer.parseInt(strLine.substring(strLine.length() - 1)) != 0 ? Boolean.toString(true) : Boolean.toString(false);
                        } else if (strLine.contains("TiltSensitivity=")) {
                            String[] strSplitTiltSensitivity = strLine.split("=");
                            strLocalTiltSensitivity = strLine.length() < 17 ? "5" : strSplitTiltSensitivity[1];
                        } else if (strLine.contains("AutoLoadFile=")) {
                            strLocalAutoLoadFile = Boolean.toString(!strLine.contains("0"));
                        } else if (strLine.contains("IncludeFirstFourHoursInAverage=")) {
                            strLocalIncludeFirstFourHours = Boolean.toString(!strLine.contains("0"));
                        } else if (strLine.contains("PageSize=")) {
                            String[] strPageSize = strLine.split("=");
                            strPageSize[1].trim();
                            strLocalPageSize = strPageSize[1];
                        } else if (strLine.contains("AutoGenPDF=")) {
                            strLocalAutoGenPDF = Boolean.toString(!strLine.contains("0"));
                        } else if (strLine.contains("DownloadNag=")) {
                            strLocalDownloadNag = Boolean.toString(!strLine.contains("0"));
                        } else if (strLine.contains("LegacyUI=")) {
                            strLocalLegacyUI = Boolean.toString(!strLine.contains("0"));
                        }
                    }
                    strLine = br.readLine();
                }
                br.close();
            }
            catch (Exception anyEx) {
                Logging.main("createConfigJSON(): Pulling values from config.txt failed.");
                anyEx.printStackTrace();
            }
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileDeployment.getAbsolutePath())));
                strLine = br.readLine();
                while (strLine != null) {
                    int lineLength = strLine.length();
                    if (lineLength > 8 && strLine.substring(0, 9).contains("Protocol:")) {
                        strLocalProtocol = strLine.substring(9).trim();
                    } else if (lineLength > 9 && strLine.substring(0, 10).contains("Tampering:")) {
                        strLocalTampering = strLine.substring(10).trim();
                    } else if (lineLength > 7 && strLine.substring(0, 8).contains("Weather:")) {
                        strLocalWeather = strLine.substring(8).trim();
                    } else if (lineLength > 10 && strLine.substring(0, 11).contains("Mitigation:")) {
                        strLocalMitigation = strLine.substring(11).trim();
                    } else if (lineLength > 7 && strLine.substring(0, 8).contains("Comment:")) {
                        strLocalComment = strLine.substring(8).trim();
                    }
                    strLine = br.readLine();
                }
                br.close();
            }
            catch (Exception anyEx) {
                Logging.main("createConfigJSON(): Pulling values from deployment.txt failed.");
                anyEx.printStackTrace();
            }
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(fileReport.getAbsolutePath())));
                strLine = br.readLine();
                while (strLine != null) {
                    int lineLength = strLine.length();
                    if (lineLength > 10 && strLine.substring(0, 11).contains("DeployedBy=")) {
                        strLocalDeployedBy = strLine.substring(11).trim();
                    }
                    if (lineLength > 11 && strLine.substring(0, 12).contains("RetrievedBy=")) {
                        strLocalRetrievedBy = strLine.substring(12).trim();
                    }
                    if (lineLength > 10 && strLine.substring(0, 11).contains("AnalyzedBy=")) {
                        strLocalAnalyzedBy = strLine.substring(11).trim();
                        strLocalReportText = br.readLine();
                    }
                    strLine = br.readLine();
                }
                br.close();
            }
            catch (Exception anyEx) {
                Logging.main("createConfigJSON(): Pulling values from report.txt failed.");
                anyEx.printStackTrace();
            }
        } else {
            Logging.main("createConfigJSON(): At least one of the txt config files is missing. Creating file with default values.");
        }
        jsonCompany.add(new MyJSONObject("Line1", strLocalCompany));
        jsonCompany.add(new MyJSONObject("Line2", strLocalCompanyAddr1));
        jsonCompany.add(new MyJSONObject("Line3", strLocalCompanyAddr2));
        jsonCompany.add(new MyJSONObject("Line4", strLocalCompanyAddr3));
        jsonOptions.add(new MyJSONObject("UnitType", strLocalUnitType));
        jsonOptions.add(new MyJSONObject("DisplayLogo", strLocalDisplayLogo));
        jsonOptions.add(new MyJSONObject("DisplaySig", strLocalDisplaySig));
        jsonOptions.add(new MyJSONObject("HighlightAverage", strLocalHighlightAverage));
        jsonOptions.add(new MyJSONObject("OpenPDFWindow", strLocalOpenPDFWindow));
        jsonOptions.add(new MyJSONObject("TiltSensitivity", strLocalTiltSensitivity));
        jsonOptions.add(new MyJSONObject("AutoLoadFile", strLocalAutoLoadFile));
        jsonOptions.add(new MyJSONObject("UseTwoChambers", Boolean.toString(boolUseTwoChambers)));
        jsonOptions.add(new MyJSONObject("ShowCMButton", Boolean.toString(boolShowCMButton)));
        jsonOptions.add(new MyJSONObject("ShowWXButton", Boolean.toString(boolShowWXButton)));
        jsonOptions.add(new MyJSONObject("ShowXLSHighlights", Boolean.toString(boolShowXLSHighlights)));
        jsonOptions.add(new MyJSONObject("CountLimiter", strLocalCountLimiter));
        jsonOptions.add(new MyJSONObject("PhotodiodeFailureRecovery", strLocalPhotodiodeFailureRecovery));
        jsonOptions.add(new MyJSONObject("IncludeFirstFourHours", strLocalIncludeFirstFourHours));
        jsonOptions.add(new MyJSONObject("PageSize", strLocalPageSize));
        jsonOptions.add(new MyJSONObject("AutoGenPDF", strLocalAutoGenPDF));
        jsonOptions.add(new MyJSONObject("DownloadNag", strLocalDownloadNag));
        jsonOptions.add(new MyJSONObject("LegacyUI", strLocalLegacyUI));
        jsonOptions.add(new MyJSONObject("ArchiveImportedFiles", strLocalArchiveImportedFiles));
        jsonOptions.add(new MyJSONObject("AllowDataRangeSetting", strLocalAllowDataRangeSetting));
        jsonOptions.add(new MyJSONObject("JavaLookAndFeel", strLocalJavaLookAndFeel));
        jsonOptions.add(new MyJSONObject("FlatLafTheme", strLocalFlatLafTheme));
        jsonOptions.add(new MyJSONObject("ForceMainMenuUI", Boolean.toString(forceMainMenuUI)));
        jsonOptions.add(new MyJSONObject("COMPort", strUserComPort));
        jsonOptions.add(new MyJSONObject("AutoResetTM", Boolean.toString(autoResetTM)));
        jsonOptions.add(new MyJSONObject("DateFormatIndex", Integer.toString(intDateFormatIndex)));
        jsonOptions.add(new MyJSONObject("Use24HourTime", Boolean.toString(use24HourTime)));
        jsonOptions.add(new MyJSONObject("ShowDepInfoXLSXReport", Boolean.toString(showDepInfXLSXReport)));
        jsonDeployment.add(new MyJSONObject("Protocol", strLocalProtocol));
        jsonDeployment.add(new MyJSONObject("Tampering", strLocalTampering));
        jsonDeployment.add(new MyJSONObject("Weather", strLocalWeather));
        jsonDeployment.add(new MyJSONObject("Mitigation", strLocalMitigation));
        jsonDeployment.add(new MyJSONObject("Comment", strLocalComment));
        jsonReport.add(new MyJSONObject("DeployedBy", strLocalDeployedBy));
        jsonReport.add(new MyJSONObject("RetrievedBy", strLocalRetrievedBy));
        jsonReport.add(new MyJSONObject("AnalyzedBy", strLocalAnalyzedBy));
        jsonReport.add(new MyJSONObject("ReportText", strLocalReportText));
        jsonObjCompany.put("Company", jsonCompany);
        jsonObjOptions.put("Options", jsonOptions);
        jsonObjDeployment.put("Deployment", jsonDeployment);
        jsonObjReport.put("Report", jsonReport);
        jsonStrings.add("[\n\n");
        jsonStrings.add(jsonObjCompany.toJSONArrayElementString());
        jsonStrings.add(jsonObjOptions.toJSONArrayElementString());
        jsonStrings.add(jsonObjDeployment.toJSONArrayElementString());
        jsonStrings.add(jsonObjReport.toJSONString());
        jsonStrings.add("\n\n]");
        try {
            PrintWriter pw = new PrintWriter(newFilename);
            for (int i = 0; i < jsonStrings.size(); ++i) {
                pw.write((String)jsonStrings.get(i));
            }
            pw.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Unable to create config.json file!");
        }
    }

    public void createPDFJSON() {
        LinkedList<String> jsonStrings = new LinkedList<String>();
        String pathPDFJSON = InitDirs.configDir + File.separator + "pdf.json";
        MyJSONObject jsonObjPDF = new MyJSONObject();
        JSONArray jsonPDF = new JSONArray();
        if (new File(pathPDFJSON).exists()) {
            return;
        }
        jsonPDF.add(new MyJSONObject("PDFMarginTop", Integer.toString(intPDFMarginTop)));
        jsonPDF.add(new MyJSONObject("PDFMarginBottom", Integer.toString(intPDFMarginBottom)));
        jsonPDF.add(new MyJSONObject("PDFMarginSide", Integer.toString(intPDFMarginSide)));
        jsonPDF.add(new MyJSONObject("PDFBannerFontSize", Integer.toString(intPDFBannerFontSize)));
        jsonPDF.add(new MyJSONObject("PDFFooterFontSize", Integer.toString(intPDFFooterFontSize)));
        jsonPDF.add(new MyJSONObject("PDFHeadingFontSize", Integer.toString(intPDFHeadingFontSize)));
        jsonPDF.add(new MyJSONObject("PDFPrimaryFontSize", Integer.toString(intPDFPrimaryFontSize)));
        jsonPDF.add(new MyJSONObject("PDFBannerFontColor", strPDFBannerFontColor));
        jsonPDF.add(new MyJSONObject("PDFPrimaryFontColor", strPDFPrimaryFontColor));
        jsonPDF.add(new MyJSONObject("PDFHourlyDetailedFontColor", strPDFHourlyDetailedFontColor));
        jsonPDF.add(new MyJSONObject("PDFHourlyExcludedFontColor", strPDFHourlyExcludedFontColor));
        jsonPDF.add(new MyJSONObject("PDFHighlightColor", strPDFHighlightColor));
        jsonPDF.add(new MyJSONObject("PDFLineColor", strPDFLineColor));
        jsonPDF.add(new MyJSONObject("PDFBackgroundColor", strPDFBackgroundColor));
        jsonObjPDF.put("PDF", jsonPDF);
        jsonStrings.add(jsonObjPDF.toJSONString());
        try {
            PrintWriter pw = new PrintWriter(pathPDFJSON);
            for (int i = 0; i < jsonStrings.size(); ++i) {
                pw.write((String)jsonStrings.get(i));
            }
            pw.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Unable to create pdf.json file!");
        }
    }

    public void createDateFmtJSON() {
        String pathDateFmtJSON = InitDirs.configDir + File.separator + "datefmt.json";
        JSONArray jsonArrDateFmt = new JSONArray();
        LinkedList<String> formattedLines = new LinkedList<String>();
        if (new File(pathDateFmtJSON).exists()) {
            return;
        }
        jsonArrDateFmt.add(new String("MMM-dd-yyyy"));
        jsonArrDateFmt.add(new String("MMM/dd/yyyy"));
        jsonArrDateFmt.add(new String("MMM.dd.yyyy"));
        jsonArrDateFmt.add(new String("MMM/dd/yy"));
        jsonArrDateFmt.add(new String("MM/dd/yyyy"));
        jsonArrDateFmt.add(new String("MM/dd/yy"));
        jsonArrDateFmt.add(new String("yyyy-MM-dd"));
        jsonArrDateFmt.add(new String("yyyy/MM/dd"));
        jsonArrDateFmt.add(new String("yyyy.MM.dd"));
        jsonArrDateFmt.add(new String("dd.MM.yyyy"));
        jsonArrDateFmt.add(new String("dd/MM/yyyy"));
        jsonArrDateFmt.add(new String("dd-MM-yyyy"));
        jsonArrDateFmt.add(new String("dd.MMM.yyyy"));
        jsonArrDateFmt.add(new String("dd/MMM/yyyy"));
        jsonArrDateFmt.add(new String("dd-MMM-yyyy"));
        jsonArrDateFmt.add(new String("dd.MM.yy"));
        jsonArrDateFmt.add(new String("dd/MM/yy"));
        jsonArrDateFmt.add(new String("dd-MM-yy"));
        jsonArrDateFmt.add(new String("dd.MMM.yy"));
        jsonArrDateFmt.add(new String("dd/MMM/yy"));
        jsonArrDateFmt.add(new String("dd-MMM-yy"));
        String strJSONString = jsonArrDateFmt.toJSONString();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strJSONString.length(); ++i) {
            sb.append(strJSONString.charAt(i));
            if (strJSONString.charAt(i) != ',') continue;
            sb.append(newline);
            formattedLines.add(sb.toString());
            sb.setLength(0);
        }
        formattedLines.add(sb.toString() + newline);
        try {
            PrintWriter pw = new PrintWriter(pathDateFmtJSON);
            for (int j = 0; j < formattedLines.size(); ++j) {
                pw.write((String)formattedLines.get(j));
            }
            pw.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Unable to create datefmt.json!");
        }
    }

    public static void parseConfigJSON() {
        String configFileName = InitDirs.configDir + File.separator + "config.json";
        StringBuilder configJSONStringBuilder = new StringBuilder();
        String strAllConfig = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(configFileName)));
            String strLine = br.readLine();
            while (strLine != null) {
                configJSONStringBuilder.append(strLine);
                strLine = br.readLine();
            }
            br.close();
            strAllConfig = configJSONStringBuilder.toString().trim();
            if (!strAllConfig.startsWith("[")) {
                strAllConfig = "[" + strAllConfig;
            }
            if (!strAllConfig.endsWith("]")) {
                strAllConfig = strAllConfig + "]";
            }
            JSONArray jsonArrConfigAll = (JSONArray)JSONValue.parseWithException(strAllConfig);
            for (JSONObject tempObj : jsonArrConfigAll) {
                JSONArray jsonArrSubObj;
                if (tempObj.containsKey("Company")) {
                    jsonArrSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("Company").toString());
                    for (JSONObject tempSubObj : jsonArrSubObj) {
                        if (tempSubObj.containsKey("Line1")) {
                            strCompanyName = (String)tempSubObj.get("Line1");
                        }
                        if (tempSubObj.containsKey("Line2")) {
                            strAddress1 = (String)tempSubObj.get("Line2");
                        }
                        if (tempSubObj.containsKey("Line3")) {
                            strAddress2 = (String)tempSubObj.get("Line3");
                        }
                        if (!tempSubObj.containsKey("Line4")) continue;
                        strAddress3 = (String)tempSubObj.get("Line4");
                    }
                }
                if (tempObj.containsKey("Options")) {
                    jsonArrSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("Options").toString());
                    for (JSONObject tempSubObj : jsonArrSubObj) {
                        if (tempSubObj.containsKey("UnitType")) {
                            unitType = (String)tempSubObj.get("UnitType");
                        }
                        if (tempSubObj.containsKey("DisplayLogo")) {
                            displayLogo = (Boolean)tempSubObj.get("DisplayLogo");
                        }
                        if (tempSubObj.containsKey("DisplaySig")) {
                            Long longJSONval = (long)((Long)tempSubObj.get("DisplaySig"));
                            displaySig = longJSONval.intValue();
                        }
                        if (tempSubObj.containsKey("HighlightAverage")) {
                            highlightAverage = (Boolean)tempSubObj.get("HighlightAverage");
                        }
                        if (tempSubObj.containsKey("OpenPDFWindow")) {
                            openPDFWind = (Boolean)tempSubObj.get("OpenPDFWindow");
                        }
                        if (tempSubObj.containsKey("TiltSensitivity")) {
                            Long longJSONVal = (long)((Long)tempSubObj.get("TiltSensitivity"));
                            tiltSensitivity = longJSONVal.intValue();
                        }
                        if (tempSubObj.containsKey("AutoLoadFile")) {
                            autoLoadFile = (Boolean)tempSubObj.get("AutoLoadFile");
                        }
                        if (tempSubObj.containsKey("UseTwoChambers")) {
                            boolUseTwoChambers = (Boolean)tempSubObj.get("UseTwoChambers");
                        }
                        if (tempSubObj.containsKey("ShowCMButton")) {
                            boolShowCMButton = (Boolean)tempSubObj.get("ShowCMButton");
                        }
                        if (tempSubObj.containsKey("ShowWXButton")) {
                            boolShowWXButton = (Boolean)tempSubObj.get("ShowWXButton");
                        }
                        if (tempSubObj.containsKey("ShowXLSHighlights")) {
                            boolShowXLSHighlights = (Boolean)tempSubObj.get("ShowXLSHighlights");
                        }
                        if (tempSubObj.containsKey("CountLimiter")) {
                            countLimiter = (Boolean)tempSubObj.get("CountLimiter");
                        }
                        if (tempSubObj.containsKey("PhotodiodeFailureRecovery")) {
                            photodiodeFailureRecovery = (Boolean)tempSubObj.get("PhotodiodeFailureRecovery");
                        }
                        if (tempSubObj.containsKey("IncludeFirstFourHours")) {
                            boolean bl = excludeFirst4Hours = (Boolean)tempSubObj.get("IncludeFirstFourHours") != true;
                        }
                        if (tempSubObj.containsKey("PageSize")) {
                            String configPageSize;
                            switch (configPageSize = (String)tempSubObj.get("PageSize")) {
                                case "A4": {
                                    pageSizePDF = PDRectangle.A4;
                                    strPageSizePDF = "A4";
                                }
                                case "LEGAL": {
                                    pageSizePDF = PDRectangle.LEGAL;
                                    strPageSizePDF = "LEGAL";
                                }
                                case "LETTER": {
                                    pageSizePDF = PDRectangle.LETTER;
                                    strPageSizePDF = "LETTER";
                                }
                            }
                            pageSizePDF = PDRectangle.LETTER;
                            strPageSizePDF = "LETTER";
                        }
                        if (tempSubObj.containsKey("AutoGenPDF")) {
                            autoGeneratePDF = (Boolean)tempSubObj.get("AutoGenPDF");
                        }
                        if (tempSubObj.containsKey("DownloadNag")) {
                            configNagDownload = (Boolean)tempSubObj.get("DownloadNag");
                        }
                        if (tempSubObj.containsKey("LegacyUI")) {
                            usingLegacyUI = (Boolean)tempSubObj.get("LegacyUI");
                        }
                        if (tempSubObj.containsKey("ArchiveImportedFiles")) {
                            archiveImportedFiles = (Boolean)tempSubObj.get("ArchiveImportedFiles");
                        }
                        if (tempSubObj.containsKey("AllowDataRangeSetting")) {
                            allowDataRangeSetting = (Boolean)tempSubObj.get("AllowDataRangeSetting");
                        }
                        if (tempSubObj.containsKey("JavaLookAndFeel")) {
                            strJavaLookAndFeel = (String)tempSubObj.get("JavaLookAndFeel");
                        }
                        if (tempSubObj.containsKey("FlatLafTheme")) {
                            strFlatLafTheme = (String)tempSubObj.get("FlatLafTheme");
                        }
                        if (tempSubObj.containsKey("ForceMainMenuUI")) {
                            forceMainMenuUI = (Boolean)tempSubObj.get("ForceMainMenuUI");
                        }
                        if (forceMainMenuUI) {
                            usingLegacyUI = false;
                        }
                        if (tempSubObj.containsKey("COMPort")) {
                            strUserComPort = (String)tempSubObj.get("COMPort");
                        }
                        if (tempSubObj.containsKey("AutoResetTM")) {
                            autoResetTM = (Boolean)tempSubObj.get("AutoResetTM");
                        }
                        if (tempSubObj.containsKey("DateFormatIndex")) {
                            Long longformat = (long)((Long)tempSubObj.get("DateFormatIndex"));
                            intDateFormatIndex = longformat.intValue();
                        }
                        if (tempSubObj.containsKey("Use24HourTime")) {
                            use24HourTime = (Boolean)tempSubObj.get("Use24HourTime");
                        }
                        if (!tempSubObj.containsKey("ShowDepInfoXLSXReport")) continue;
                        showDepInfXLSXReport = (Boolean)tempSubObj.get("ShowDepInfoXLSXReport");
                    }
                }
                if (tempObj.containsKey("Deployment")) {
                    jsonArrSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("Deployment").toString());
                    for (JSONObject tempSubObj : jsonArrSubObj) {
                        if (tempSubObj.containsKey("Protocol")) {
                            strProtocol = (String)tempSubObj.get("Protocol");
                        }
                        if (tempSubObj.containsKey("Tampering")) {
                            strTampering = (String)tempSubObj.get("Tampering");
                        }
                        if (tempSubObj.containsKey("Weather")) {
                            strWeather = (String)tempSubObj.get("Weather");
                        }
                        if (tempSubObj.containsKey("Mitigation")) {
                            strMitigation = (String)tempSubObj.get("Mitigation");
                        }
                        if (!tempSubObj.containsKey("Comment")) continue;
                        strComment = (String)tempSubObj.get("Comment");
                    }
                }
                if (!tempObj.containsKey("Report")) continue;
                jsonArrSubObj = (JSONArray)JSONValue.parseWithException(tempObj.get("Report").toString());
                for (JSONObject tempSubObj : jsonArrSubObj) {
                    if (tempSubObj.containsKey("DeployedBy")) {
                        strDeployedBy = (String)tempSubObj.get("DeployedBy");
                    }
                    if (tempSubObj.containsKey("RetrievedBy")) {
                        strRetrievedBy = (String)tempSubObj.get("RetrievedBy");
                    }
                    if (tempSubObj.containsKey("AnalyzedBy")) {
                        strAnalyzedBy = (String)tempSubObj.get("AnalyzedBy");
                    }
                    if (!tempSubObj.containsKey("ReportText")) continue;
                    strReportText = (String)tempSubObj.get("ReportText");
                }
            }
        }
        catch (IOException ioEX) {
            Logging.main("Unhandled IOException in parseConfigJSON()!");
        }
        catch (ParseException pe) {
            Logging.main("Parse exception when parsing config.json!");
            pe.printStackTrace();
        }
        catch (ClassCastException ccEx) {
            Logging.main("ClassCastException in parseConfigJSON(). Recommended to regenerate config files and try again.");
            ccEx.printStackTrace();
        }
    }

    public static void parseChartJSON() {
        try {
            File chartResource = new File(InitDirs.configDir + File.separator + "chart.json");
            if (!chartResource.exists()) {
                Logging.main("Chart.json could not be found. Using default values for all charts.");
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(chartResource.getAbsolutePath())));){
                String currentLine;
                StringBuilder sb = new StringBuilder();
                while ((currentLine = br.readLine()) != null) {
                    sb.append(currentLine);
                }
                br.close();
                String strChart = sb.toString();
                JSONObject objChartShell = (JSONObject)JSONValue.parseWithException(strChart);
                Object object = objChartShell.get("Chart");
                for (Object simpleObj : (JSONArray)object) {
                    JSONObject objChart = (JSONObject)simpleObj;
                    if (objChart.containsKey("ChartRangeRadon")) {
                        strChartRangeRadon = objChart.get("ChartRangeRadon").toString();
                    }
                    if (objChart.containsKey("ChartRangeHumidity")) {
                        strChartRangeHumidity = objChart.get("ChartRangeHumidity").toString();
                    }
                    if (objChart.containsKey("ChartRangeTemperatureUS")) {
                        strChartRangeTemperatureUS = objChart.get("ChartRangeTemperatureUS").toString();
                    }
                    if (objChart.containsKey("ChartRangeTemperatureSI")) {
                        strChartRangeTemperatureSI = objChart.get("ChartRangeTemperatureSI").toString();
                    }
                    if (objChart.containsKey("ChartRangePressureUS")) {
                        strChartRangePressureUS = objChart.get("ChartRangePressureUS").toString();
                    }
                    if (objChart.containsKey("ChartRangePressureSI")) {
                        strChartRangePressureSI = objChart.get("ChartRangePressureSI").toString();
                    }
                    if (objChart.containsKey("ChartRangeTilts")) {
                        strChartRangeTilts = objChart.get("ChartRangeTilts").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitRadon")) {
                        strChartTickUnitRadon = objChart.get("ChartTickUnitRadon").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitHumidity")) {
                        strChartTickUnitHumidity = objChart.get("ChartTickUnitHumidity").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitTemperatureUS")) {
                        strChartTickUnitTemperatureUS = objChart.get("ChartTickUnitTemperatureUS").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitTemperatureSI")) {
                        strChartTickUnitTemperatureSI = objChart.get("ChartTickUnitTemperatureSI").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitPressureUS")) {
                        strChartTickUnitPressureUS = objChart.get("ChartTickUnitPressureUS").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitPressureSI")) {
                        strChartTickUnitPressureSI = objChart.get("ChartTickUnitPressureSI").toString();
                    }
                    if (objChart.containsKey("ChartTickUnitTilts")) {
                        strChartTickUnitTilts = objChart.get("ChartTickUnitTilts").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsRadonUS")) {
                        strChartFractionDigitsRadonUS = objChart.get("ChartFractionDigitsRadonUS").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsRadonSI")) {
                        strChartFractionDigitsRadonSI = objChart.get("ChartFractionDigitsRadonSI").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsTemperatureUS")) {
                        strChartFractionDigitsTemperatureUS = objChart.get("ChartFractionDigitsTemperatureUS").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsTemperatureSI")) {
                        strChartFractionDigitsTemperatureSI = objChart.get("ChartFractionDigitsTemperatureSI").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsPressureUS")) {
                        strChartFractionDigitsPressureUS = objChart.get("ChartFractionDigitsPressureUS").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsPressureSI")) {
                        strChartFractionDigitsPressureSI = objChart.get("ChartFractionDigitsPressureSI").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsHumidity")) {
                        strChartFractionDigitsHumidity = objChart.get("ChartFractionDigitsHumidity").toString();
                    }
                    if (objChart.containsKey("ChartFractionDigitsTilts")) {
                        strChartFractionDigitsTilts = objChart.get("ChartFractionDigitsTilts").toString();
                    }
                    if (objChart.containsKey("ChartStrokeRadonAvg")) {
                        fltChartStrokeRadonAvg = Float.parseFloat(objChart.get("ChartStrokeRadonAvg").toString());
                    }
                    if (objChart.containsKey("ChartStrokeRadon1")) {
                        fltChartStrokeRadon1 = Float.parseFloat(objChart.get("ChartStrokeRadon1").toString());
                    }
                    if (objChart.containsKey("ChartStrokeRadon2")) {
                        fltChartStrokeRadon2 = Float.parseFloat(objChart.get("ChartStrokeRadon2").toString());
                    }
                    if (objChart.containsKey("ChartStrokeHumidity")) {
                        fltChartStrokeHumidity = Float.parseFloat(objChart.get("ChartStrokeHumidity").toString());
                    }
                    if (objChart.containsKey("ChartStrokeTemperature")) {
                        fltChartStrokeTemperature = Float.parseFloat(objChart.get("ChartStrokeTemperature").toString());
                    }
                    if (objChart.containsKey("ChartStrokePressure")) {
                        fltChartStrokePressure = Float.parseFloat(objChart.get("ChartStrokePressure").toString());
                    }
                    if (objChart.containsKey("ChartStrokeTilts")) {
                        fltChartStrokeTilts = Float.parseFloat(objChart.get("ChartStrokeTilts").toString());
                    }
                    if (objChart.containsKey("ChartColorRadonAvg")) {
                        strChartColorRadonAvg = objChart.get("ChartColorRadonAvg").toString();
                    }
                    if (objChart.containsKey("ChartColorRadon1")) {
                        strChartColorRadon1 = objChart.get("ChartColorRadon1").toString();
                    }
                    if (objChart.containsKey("ChartColorRadon2")) {
                        strChartColorRadon2 = objChart.get("ChartColorRadon2").toString();
                    }
                    if (objChart.containsKey("ChartColorHumidity")) {
                        strChartColorHumidity = objChart.get("ChartColorHumidity").toString();
                    }
                    if (objChart.containsKey("ChartColorTemperature")) {
                        strChartColorTemperature = objChart.get("ChartColorTemperature").toString();
                    }
                    if (objChart.containsKey("ChartColorPressure")) {
                        strChartColorPressure = objChart.get("ChartColorPressure").toString();
                    }
                    if (objChart.containsKey("ChartColorTilts")) {
                        strChartColorTilts = objChart.get("ChartColorTilts").toString();
                    }
                    if (objChart.containsKey("ChartColorBackground")) {
                        strChartColorBackground = objChart.get("ChartColorBackground").toString();
                    }
                    if (objChart.containsKey("ChartColorXAxisLabels")) {
                        strChartColorXAxisLabels = objChart.get("ChartColorXAxisLabels").toString();
                    }
                    if (objChart.containsKey("ChartColorLegendBackground")) {
                        strChartColorLegendBackground = objChart.get("ChartColorLegendBackground").toString();
                    }
                    if (objChart.containsKey("ChartColorLegendLabels")) {
                        strChartColorLegendLabels = objChart.get("ChartColorLegendLabels").toString();
                    }
                    if (objChart.containsKey("ChartImageWidth")) {
                        intChartImageWidth = Integer.parseInt(objChart.get("ChartImageWidth").toString());
                    }
                    if (!objChart.containsKey("ChartImageHeight")) continue;
                    intChartImageHeight = Integer.parseInt(objChart.get("ChartImageHeight").toString());
                }
            }
        }
        catch (Exception anyEx) {
            Logging.main("Exception caught in AppUI.parseChartJSON()!");
            anyEx.printStackTrace();
        }
    }

    public static void parsePDFJSON() {
        try {
            File chartResource = new File(InitDirs.configDir + File.separator + "pdf.json");
            if (!chartResource.exists()) {
                Logging.main("PDF.json could not be found. Using default values for all PDF variables.");
                return;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(chartResource.getAbsolutePath())));){
                String currentLine;
                StringBuilder sb = new StringBuilder();
                while ((currentLine = br.readLine()) != null) {
                    sb.append(currentLine);
                }
                br.close();
                String strPDF = sb.toString();
                JSONObject objPDFShell = (JSONObject)JSONValue.parseWithException(strPDF);
                Object object = objPDFShell.get("PDF");
                for (Object simpleObj : (JSONArray)object) {
                    JSONObject objPDF = (JSONObject)simpleObj;
                    if (objPDF.containsKey("PDFMarginTop")) {
                        intPDFMarginTop = Integer.parseInt(objPDF.get("PDFMarginTop").toString());
                    }
                    if (objPDF.containsKey("PDFMarginBottom")) {
                        intPDFMarginBottom = Integer.parseInt(objPDF.get("PDFMarginBottom").toString());
                    }
                    if (objPDF.containsKey("PDFMarginSide")) {
                        intPDFMarginSide = Integer.parseInt(objPDF.get("PDFMarginSide").toString());
                    }
                    if (objPDF.containsKey("PDFBannerFontSize")) {
                        intPDFBannerFontSize = Integer.parseInt(objPDF.get("PDFBannerFontSize").toString());
                    }
                    if (objPDF.containsKey("PDFFooterFontSize")) {
                        intPDFFooterFontSize = Integer.parseInt(objPDF.get("PDFFooterFontSize").toString());
                    }
                    if (objPDF.containsKey("PDFHeadingFontSize")) {
                        intPDFHeadingFontSize = Integer.parseInt(objPDF.get("PDFHeadingFontSize").toString());
                    }
                    if (objPDF.containsKey("PDFPrimaryFontSize")) {
                        intPDFPrimaryFontSize = Integer.parseInt(objPDF.get("PDFPrimaryFontSize").toString());
                    }
                    if (objPDF.containsKey("PDFPrimaryFontColor")) {
                        strPDFPrimaryFontColor = objPDF.get("PDFPrimaryFontColor").toString();
                    }
                    if (objPDF.containsKey("PDFBannerFontColor")) {
                        strPDFBannerFontColor = objPDF.get("PDFBannerFontColor").toString();
                    }
                    if (objPDF.containsKey("PDFHourlyDetailedFontColor")) {
                        strPDFHourlyDetailedFontColor = objPDF.get("PDFHourlyDetailedFontColor").toString();
                    }
                    if (objPDF.containsKey("PDFHourlyExcludedFontColor")) {
                        strPDFHourlyExcludedFontColor = objPDF.get("PDFHourlyExcludedFontColor").toString();
                    }
                    if (objPDF.containsKey("PDFHighlightColor")) {
                        strPDFHighlightColor = objPDF.get("PDFHighlightColor").toString();
                    }
                    if (objPDF.containsKey("PDFLineColor")) {
                        strPDFLineColor = objPDF.get("PDFLineColor").toString();
                    }
                    if (!objPDF.containsKey("PDFBackgroundColor")) continue;
                    strPDFBackgroundColor = objPDF.get("PDFBackgroundColor").toString();
                }
            }
        }
        catch (Exception anyEx) {
            Logging.main("Exception caught in AppUI.parsePDFJSON()!");
            anyEx.printStackTrace();
        }
    }

    public static void parseDateFmtJSON() {
        try {
            String currentLine;
            File fileResource = new File(InitDirs.configDir + File.separator + "datefmt.json");
            if (!fileResource.exists()) {
                Logging.main("datefmt.json could not be found. Using default values for all date format variables.");
                return;
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileResource.getAbsolutePath())));
            while ((currentLine = br.readLine()) != null) {
                sb.append(currentLine);
            }
            br.close();
            JSONArray arrDateFmtStrings = (JSONArray)JSONValue.parseWithException(sb.toString());
            for (int i = 0; i < arrDateFmtStrings.size(); ++i) {
                dateFormatStrings.add((String)arrDateFmtStrings.get(i));
            }
        }
        catch (Exception anyEx) {
            Logging.main("Exception caught in AppUI.parseDateFmtJSON()!");
            anyEx.printStackTrace();
        }
    }

    public static void findOperatingSystem() {
        String strOperatingSystem = System.getProperty("os.name");
        Logging.main("Operating System: " + strOperatingSystem);
        InitDirs.boolMacOS = strOperatingSystem.startsWith("Mac");
    }

    public void DisplayAvgRadonLabel(double AvgRnC) {
        String strAvgRnC = unitType.equals("SI") ? new DecimalFormat("0").format(AvgRnC) : new DecimalFormat("0.0").format(AvgRnC);
        lblFinalAvg.setText("Average Radon: " + strAvgRnC + (unitType.equals("SI") ? " Bq/m\u00b3" : " pCi/L"));
    }

    public void checkAutoLoadFile() {
        block8: {
            File dataFile = null;
            this.CloseFile();
            switch (this.deviceType) {
                case RECON: {
                    dataFile = new File(ReconProtocol.filenameJSON);
                    break;
                }
                case CWLM: {
                    break;
                }
                default: {
                    dataFile = new File(TMProtocol.filenameJSON);
                }
            }
            if (dataFile.exists() && autoLoadFile) {
                try {
                    LoadSavedFile.main(dataFile.getAbsolutePath());
                    lblLoadedFile.setVisible(true);
                    lblLoadedFileName.setVisible(true);
                    btnGeneratePDF.setVisible(true);
                    btnMainImages.setVisible(true);
                    btnGeneratePDF.setEnabled(true);
                    btnCloseFile.setVisible(true);
                    this.btnExport.setVisible(true);
                    if (MainMenuUI.appUI instanceof MainMenuUI) {
                        this.btnTestDetails.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    Logging.main("ERROR when auto-loading the file!");
                    lblLoadedFile.setVisible(false);
                    lblLoadedFileName.setVisible(false);
                    btnGeneratePDF.setVisible(false);
                    btnMainImages.setVisible(false);
                    btnGeneratePDF.setEnabled(false);
                    btnCloseFile.setVisible(false);
                    this.btnExport.setVisible(false);
                    if (!(MainMenuUI.appUI instanceof MainMenuUI)) break block8;
                    this.btnTestDetails.setVisible(false);
                }
            }
        }
    }

    public void EnableAllButtons(boolean boolEnableButtons) {
        Window[] progWindows;
        this.btnAllDataDump.setEnabled(boolEnableButtons);
        this.btnClearMemory.setEnabled(boolEnableButtons);
        this.btnClearSession.setEnabled(boolEnableButtons);
        this.btnClearTamperFlag.setEnabled(boolEnableButtons);
        btnConfig.setEnabled(boolEnableButtons);
        this.btnConnect.setEnabled(boolEnableButtons);
        this.btnDownloadSession.setEnabled(boolEnableButtons);
        this.btnEraseReconData.setEnabled(boolEnableButtons);
        btnGeneratePDF.setEnabled(boolEnableButtons);
        this.btnOpenPDF.setEnabled(boolEnableButtons);
        this.btnOpenSavedFile.setEnabled(boolEnableButtons);
        this.btnSyncTime.setEnabled(boolEnableButtons);
        btnCloseFile.setEnabled(boolEnableButtons);
        this.btnDisplaySettings.setEnabled(boolEnableButtons);
        this.btnExport.setEnabled(boolEnableButtons);
        btnMainImages.setEnabled(boolEnableButtons);
        if (MainMenuUI.appUI instanceof MainMenuUI) {
            this.btnTestDetails.setEnabled(boolEnableButtons);
            btnRange.setEnabled(boolEnableButtons);
        }
        for (Window window : progWindows = Window.getWindows()) {
            if (!window.getClass().toString().contains("Config.FlagForm")) continue;
            FlagForm.EnableAllButtons(boolEnableButtons);
        }
    }

    public void HideReconConnectedComponents() {
        this.btnEraseReconData.setVisible(false);
        this.btnClearSession.setVisible(false);
        this.btnClearMemory.setVisible(false);
        this.btnAllDataDump.setVisible(false);
        this.btnClearTamperFlag.setVisible(false);
        this.btnSyncTime.setVisible(false);
        this.btnDisplaySettings.setVisible(false);
        this.EnableFileNaming(false);
        lblReconSN.setVisible(false);
        lblFirmwareVersion.setVisible(false);
        lblDataSessions.setVisible(false);
        lblCalibrationDate.setVisible(false);
        lblCalibrationDue.setVisible(false);
        this.btnDownloadSession.setVisible(false);
        this.lblStatusNoRecon.setVisible(true);
        this.btnDisplaySettings.setVisible(false);
    }

    public void EnableFileNaming(boolean boolWantToEnable) {
        this.txtNewFileName.setEnabled(boolWantToEnable);
        this.txtNewFileName.setVisible(boolWantToEnable);
        this.chkUseStreetAddressForFilename.setEnabled(boolWantToEnable);
        this.chkUseStreetAddressForFilename.setVisible(boolWantToEnable);
        if (boolWantToEnable) {
            switch (this.deviceType) {
                case RECON: {
                    cboSessionSelect.setVisible(true);
                    break;
                }
                case TM: {
                    cboSessionSelect.setVisible(false);
                    break;
                }
                case MTM: {
                    cboSessionSelect.setVisible(false);
                    break;
                }
                case MTM2: {
                    if (Double.parseDouble(TMProtocol.firmwareVersion) < 4.08) {
                        cboSessionSelect.setVisible(false);
                        break;
                    }
                    cboSessionSelect.setVisible(true);
                    break;
                }
                default: {
                    cboSessionSelect.setVisible(false);
                    break;
                }
            }
        } else {
            cboSessionSelect.setVisible(boolWantToEnable);
        }
    }

    protected void RefreshDefaultFileName() {
        try {
            if (this.getDataSessions() > 0) {
                if (ReconProtocol.currentSession < 0) {
                    ReconProtocol.currentSession = 0;
                }
                if (TMProtocol.currentSession < 0) {
                    TMProtocol.currentSession = 0;
                }
                this.EnableFileNaming(true);
                this.deviceType = ScanComm.run(11);
                switch (this.deviceType) {
                    case RECON: {
                        this.txtNewFileName.setText(ReconProtocol.defaultFilename);
                        break;
                    }
                    case MTM2: {
                        this.txtNewFileName.setText(TMProtocol.defaultFilename);
                        break;
                    }
                    default: {
                        this.txtNewFileName.setText(TMProtocol.defaultFilename);
                    }
                }
                this.txtNewFileName.requestFocus();
                this.txtNewFileName.selectAll();
            } else {
                this.EnableFileNaming(false);
            }
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    protected void RefreshSessionList() {
        sessionStrings.clear();
        cboSessionSelect.removeAllItems();
        if (this.getDataSessions() < 1) {
            return;
        }
        try {
            this.deviceType = ScanComm.run(12);
            for (int k = 0; k < sessionStrings.size(); ++k) {
                Logging.main("Session detected: " + sessionStrings.get(k));
                cboSessionSelect.addItem(sessionStrings.get(k));
            }
            cboSessionSelect.setSelectedIndex(cboSessionSelect.getItemCount() - 1);
            ReconProtocol.currentSession = cboSessionSelect.getSelectedIndex();
        }
        catch (Exception anyEx) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    public static void SetStartEndDateStrings(String startOrEnd, String month, String day, String year, String hour, String minute) {
        switch (startOrEnd) {
            case "start": {
                startDateTime = month + "," + day + "," + year + "," + hour + "," + minute;
                break;
            }
            case "end": {
                endDateTime = month + "," + day + "," + year + "," + hour + "," + minute;
                break;
            }
        }
    }

    public static void RefreshStartEndDateLabels() {
        try {
            SimpleDateFormat originalFormat = new SimpleDateFormat("MM,dd,yy,HH,mm");
            Date startDate = originalFormat.parse(startDateTime);
            Date endDate = originalFormat.parse(endDateTime);
            lblStartDateTimeDynamic.setText(niceDateFormat.format(startDate));
            lblEndDateTimeDynamic.setText(niceDateFormat.format(endDate));
            lblTotalHoursDynamic.setText(Long.toString((endDate.getTime() - startDate.getTime()) / 3600000L));
            if (allowDataRangeSetting) {
                btnRange.setEnabled(true);
                btnRange.setVisible(true);
            } else {
                btnRange.setEnabled(false);
                btnRange.setVisible(false);
            }
            pnlStartEndDate.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void CloseFile() {
        if (isFileLoaded) {
            String fileName = lblLoadedFileName.getText();
            Logging.main("Closing " + fileName + ".");
            isFileLoaded = false;
            lblFinalAvg.setText("");
            lblLoadedFileName.setText("");
            lblLoadedFile.setVisible(false);
            btnMainImages.setVisible(false);
            btnCloseFile.setVisible(false);
            btnGeneratePDF.setVisible(false);
            this.btnExport.setVisible(false);
            if (this instanceof MainMenuUI) {
                this.btnTestDetails.setVisible(false);
                lblStartDateTimeDynamic.setText("");
                lblEndDateTimeDynamic.setText("");
                lblTotalHoursDynamic.setText("");
                pnlStartEndDate.setVisible(false);
                pnlGraph.removeAll();
                pnlGraph.revalidate();
                pnlGraph.repaint();
            } else if (this instanceof LegacyUI) {
                LegacyUI.CloseGraphWindows();
            }
            if (rewriteDataFile) {
                Logging.main("Rewriting data file " + fileName + ".");
                CreateJSONData.main(DataExporter.GetTrimmedDataSession(LoadSavedFile.fileBuffer), InitDirs.dataDir + File.separator + fileName, false, true);
                rewriteDataFile = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void ShowExportDialog(final String fileName) {
        final JFileChooser exportDataFileChooser = new JFileChooser();
        exportDataFileChooser.setDialogTitle("Export Data Session");
        exportDataFileChooser.setCurrentDirectory(InitDirs.dataDir);
        exportDataFileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter csvFilter = new FileNameExtensionFilter("Comma Separated Values (.csv)", "csv");
        FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("MS Excel raw data (.xls)", "xls");
        FileNameExtensionFilter rrmFilter = new FileNameExtensionFilter("Radon Report Manager txt (.txt)", "txt");
        FileNameExtensionFilter xlsxRepFilter = new FileNameExtensionFilter("MS Excel Report (.xlsx)", "xlsx");
        exportDataFileChooser.setFileFilter(xlsFilter);
        exportDataFileChooser.addChoosableFileFilter(xlsxRepFilter);
        exportDataFileChooser.addChoosableFileFilter(csvFilter);
        exportDataFileChooser.addChoosableFileFilter(rrmFilter);
        exportDataFileChooser.setSelectedFile(new File(fileName + ".xls"));
        exportDataFileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (exportDataFileChooser.getFileFilter().getDescription().contains("csv")) {
                    exportDataFileChooser.setSelectedFile(new File(fileName + ".csv"));
                } else if (exportDataFileChooser.getFileFilter().getDescription().contains("raw")) {
                    exportDataFileChooser.setSelectedFile(new File(fileName + ".xls"));
                } else if (exportDataFileChooser.getFileFilter().getDescription().contains("Report Manager")) {
                    exportDataFileChooser.setSelectedFile(new File(fileName + ".txt"));
                } else if (exportDataFileChooser.getFileFilter().getDescription().contains("Excel Report")) {
                    exportDataFileChooser.setSelectedFile(new File(fileName + ".xlsx"));
                }
            }
        });
        File finalFile = null;
        int selection = exportDataFileChooser.showSaveDialog(this);
        if (selection != 0) return;
        try {
            if (exportDataFileChooser.getFileFilter().getDescription().contains("csv")) {
                if (!exportDataFileChooser.getSelectedFile().getName().endsWith(".csv")) {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath() + ".csv");
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export .csv cancelled.");
                        return;
                    }
                    DataExporter.ExportCSV(finalFile);
                } else {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath());
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export .csv cancelled.");
                        return;
                    }
                    DataExporter.ExportCSV(finalFile);
                }
                Logging.main("Exported to csv file: " + finalFile.getAbsolutePath());
                return;
            }
            if (exportDataFileChooser.getFileFilter().getDescription().contains("raw")) {
                if (LoadSavedFile.dataType != LoadSavedFile.DataType.RECON) {
                    Logging.main("XLS export is currently only available for Recon data.");
                    Logging.main("Export to CSV and open in a spreadsheet program instead.");
                    return;
                }
                if (!exportDataFileChooser.getSelectedFile().getName().endsWith(".xls")) {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath() + ".xls");
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export .xls cancelled.");
                        return;
                    }
                    DataExporter.ExportXLS(finalFile);
                } else {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath());
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export .xls cancelled.");
                        return;
                    }
                    DataExporter.ExportXLS(finalFile);
                }
                Logging.main("Exported to xls file: " + finalFile.getAbsolutePath());
                return;
            }
            if (exportDataFileChooser.getFileFilter().getDescription().contains("Report Manager")) {
                if (LoadSavedFile.dataType != LoadSavedFile.DataType.RECON) {
                    Logging.main("RRM export is currently only available for Recon data.");
                    return;
                }
                if (!exportDataFileChooser.getSelectedFile().getName().endsWith(".txt")) {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath() + ".txt");
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export RRM .txt cancelled.");
                        return;
                    }
                    DataExporter.ExportRRMText(finalFile);
                } else {
                    finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath());
                    if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                        Logging.main("Export RRM .txt cancelled.");
                        return;
                    }
                    DataExporter.ExportRRMText(finalFile);
                }
                Logging.main("Exported to txt file: " + finalFile.getAbsolutePath());
                return;
            }
            if (!exportDataFileChooser.getFileFilter().getDescription().contains("Excel Report")) return;
            if (LoadSavedFile.dataType != LoadSavedFile.DataType.RECON) {
                Logging.main("This export format is only available for Recon data.");
                return;
            }
            if (!exportDataFileChooser.getSelectedFile().getName().endsWith(".xlsx")) {
                finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath() + ".xlsx");
                if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                    Logging.main("Export Excel Report xlsx cancelled.");
                    return;
                }
                DataExporter.ExportXLSXReport(finalFile);
            } else {
                finalFile = new File(exportDataFileChooser.getSelectedFile().getAbsolutePath());
                if (!this.ShowFileExistsOptionPane(finalFile.getAbsolutePath())) {
                    Logging.main("Export Excel Report xlsx cancelled.");
                    return;
                }
                DataExporter.ExportXLSXReport(finalFile);
            }
            Logging.main("Exported to xlsx file: " + finalFile.getAbsolutePath());
            return;
        }
        catch (BiffException bEx) {
            Logging.main("ERROR: BiffException when attempting to export to xls!");
            return;
        }
        catch (InterruptedException iEx) {
            Logging.main("ERROR: InterruptedException when attempting to export file!");
            return;
        }
        catch (WriteException wEx) {
            Logging.main("ERROR: WriteException when attempting to export to xls!");
            return;
        }
        catch (IOException ioEx) {
            Logging.main("ERROR: IOException when attempting to export file!");
        }
    }

    public boolean ShowFileExistsOptionPane(String fileName) {
        File theFile = new File(fileName);
        if (theFile.exists()) {
            int result = JOptionPane.showConfirmDialog(this, theFile.getName() + " exists.\nOverwrite?", "File Exists", 0, 3);
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                return false;
            }
            return false;
        }
        return true;
    }

    public AppUI() {
        lblSystemConsole = new JLabel();
        this.btnConnect = new JButton();
        lblVersion = new JLabel();
        this.limiterLabel = new JLabel();
        lblFinalAvg = new JLabel();
        this.pnlMainDeployment = new JPanel();
        this.lblTestSiteInfo1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        txtCustomerInfo = new JTextArea();
        this.lblTestSiteInfo = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        txtTestSiteInfo = new JTextArea();
        this.lblLocation = new JLabel();
        this.lblMainWeather = new JLabel();
        this.lblMainProtocol = new JLabel();
        this.lblMainMitigation = new JLabel();
        this.lblMainTampering = new JLabel();
        this.lblMainComment = new JLabel();
        txtLocation = new JTextField();
        txtMainTampering = new JTextField();
        txtMainProtocol = new JTextField();
        txtMainWeather = new JTextField();
        txtMainMitigation = new JTextField();
        this.lblMainDeployedBy = new JLabel();
        txtMainDeployedBy = new JTextField();
        this.lblMainRetrievedBy = new JLabel();
        txtMainRetrievedBy = new JTextField();
        this.lblMainAnalyzedBy = new JLabel();
        txtMainAnalyzedBy = new JTextField();
        txtMainComment = new JTextField();
        pnlStartEndDate = new JPanel();
        this.lblStartDate = new JLabel();
        this.lblEndDateTime = new JLabel();
        this.lblTotalHours = new JLabel();
        btnRange = new JButton();
        lblStartDateTimeDynamic = new JLabel();
        lblEndDateTimeDynamic = new JLabel();
        lblTotalHoursDynamic = new JLabel();
        btnMainImages = new JButton();
        this.pnlFileMgmt = new JPanel();
        this.btnOpenSavedFile = new JButton();
        this.btnOpenPDF = new JButton();
        btnGeneratePDF = new JButton();
        btnCloseFile = new JButton();
        this.pnlReconStatus = new JPanel();
        cboSessionSelect = new JComboBox();
        this.txtNewFileName = new JTextField();
        this.chkUseStreetAddressForFilename = new JCheckBox();
        lblFirmwareVersion = new JLabel();
        lblReconSN = new JLabel();
        lblCalibrationDate = new JLabel();
        lblDataSessions = new JLabel();
        lblCalibrationDue = new JLabel();
        this.btnDownloadSession = new JButton();
        this.lblStatusNoRecon = new JLabel();
        pnlGraph = new JPanel();
        lblLoadedFile = new JLabel();
        lblLoadedFileName = new JLabel();
        this.pnlReconButtons = new JPanel();
        this.btnEraseReconData = new JButton();
        this.btnClearSession = new JButton();
        this.btnClearMemory = new JButton();
        this.btnAllDataDump = new JButton();
        this.btnClearTamperFlag = new JButton();
        this.btnSyncTime = new JButton();
        this.btnDisplaySettings = new JButton();
        this.pnlAppControl = new JPanel();
        btnConfig = new JButton();
        this.btnCloseProgram = new JButton();
        this.pnlDisplayHelp = new JPanel();
        this.pnlApplicationLog = new JPanel();
        this.scrollPaneLog = new JScrollPane();
        txtLogScroll = new JTextArea();
    }

    static {
        strCompanyName = "";
        strAddress1 = "";
        strAddress2 = "";
        strAddress3 = "";
        unitType = "US";
        displayLogo = false;
        displaySig = 1;
        highlightAverage = true;
        openPDFWind = true;
        tiltSensitivity = 5;
        autoLoadFile = true;
        boolUseTwoChambers = false;
        boolShowCMButton = false;
        boolShowWXButton = false;
        boolShowXLSHighlights = false;
        countLimiter = true;
        photodiodeFailureRecovery = false;
        excludeFirst4Hours = true;
        strPageSizePDF = "LETTER";
        pageSizePDF = PDRectangle.LETTER;
        autoGeneratePDF = true;
        configNagDownload = true;
        usingLegacyUI = false;
        archiveImportedFiles = true;
        allowDataRangeSetting = false;
        strJavaLookAndFeel = "FlatLaf";
        strFlatLafTheme = "Light";
        strProtocol = "Closed Building Conditions Met";
        strTampering = "No Tampering Detected";
        strWeather = "No Abnormal Weather Conditions";
        strMitigation = "No Mitigation System Installed";
        strComment = "Thanks for the business!";
        strDeployedBy = "";
        strRetrievedBy = "";
        strAnalyzedBy = "";
        strReportText = "Radon is the second leading cause of lung cancer after smoking. The U.S. Environmental Protection Agency (US EPA) and the Surgeon General strongly recommend that further action be taken when a home\u2019s radon test results are 4.0 pCi/L or greater. The national average indoor radon level is about 1.3 pCi/L. The higher the home\u2019s radon level, the greater the health risk to you and your family. Reducing your radon levels can be done easily, effectively and fairly inexpensively. Even homes with very high radon levels can be reduced below 4.0 pCi/L. Please refer to the EPA website at www.epa.gov/radon for further information to assist you in evaluating your test results or deciding if further action is needed.";
        forceMainMenuUI = false;
        strUserComPort = "auto";
        autoResetTM = true;
        intDateFormatIndex = 0;
        strDateFormat = "MMM-dd-yyyy";
        use24HourTime = true;
        showDepInfXLSXReport = false;
        strChartRangeRadon = "auto";
        strChartRangeHumidity = "0 100";
        strChartRangeTemperatureUS = "50 100";
        strChartRangeTemperatureSI = "10 40";
        strChartRangePressureUS = "28 32";
        strChartRangePressureSI = "975 1025";
        strChartRangeTilts = "0 10";
        strChartTickUnitRadon = "auto";
        strChartTickUnitHumidity = "10";
        strChartTickUnitTemperatureUS = "5";
        strChartTickUnitTemperatureSI = "3";
        strChartTickUnitPressureUS = "0.5";
        strChartTickUnitPressureSI = "5";
        strChartTickUnitTilts = "1";
        strChartFractionDigitsRadonUS = "1 1";
        strChartFractionDigitsRadonSI = "0 0";
        strChartFractionDigitsTemperatureUS = "0 0";
        strChartFractionDigitsTemperatureSI = "0 0";
        strChartFractionDigitsPressureUS = "1 1";
        strChartFractionDigitsPressureSI = "0 0";
        strChartFractionDigitsHumidity = "0 0";
        strChartFractionDigitsTilts = "0 0";
        fltChartStrokeRadonAvg = 3.0f;
        fltChartStrokeRadon1 = 1.25f;
        fltChartStrokeRadon2 = 1.25f;
        fltChartStrokeHumidity = 1.5f;
        fltChartStrokeTemperature = 1.5f;
        fltChartStrokePressure = 1.5f;
        fltChartStrokeTilts = 1.0f;
        strChartColorRadonAvg = "#666666";
        strChartColorRadon1 = "#00cc00";
        strChartColorRadon2 = "#ff00ff";
        strChartColorHumidity = "#0000ff";
        strChartColorTemperature = "#ff0000";
        strChartColorPressure = "#ff6600";
        strChartColorTilts = "#cccccc";
        strChartColorBackground = "#ffffff";
        strChartColorXAxisLabels = "#000000";
        strChartColorLegendBackground = "#ffffff";
        strChartColorLegendLabels = "#000000";
        intChartImageWidth = 500;
        intChartImageHeight = 300;
        intPDFMarginTop = 10;
        intPDFMarginBottom = 30;
        intPDFMarginSide = 30;
        intPDFBannerFontSize = 18;
        intPDFFooterFontSize = 8;
        intPDFHeadingFontSize = 14;
        intPDFPrimaryFontSize = 12;
        strPDFPrimaryFontColor = "#000000";
        strPDFBannerFontColor = "#000000";
        strPDFHourlyDetailedFontColor = "#000000";
        strPDFHourlyExcludedFontColor = "#999999";
        strPDFHighlightColor = "#ffffcc";
        strPDFLineColor = "#000000";
        strPDFBackgroundColor = "#ffffff";
        dateFormatCalibration = new SimpleDateFormat("MM/dd/yyyy");
        dateFormatStartEndTime = new SimpleDateFormat("MM-dd-yyyy HH:mm");
        niceDateFormat = new SimpleDateFormat("MMM d, yyyy @ HH:mm");
    }

    public static enum RDevice {
        RECON,
        CWLM,
        TM,
        MTM,
        MTM2,
        NONE;

    }

    protected class ClearTamperStatus
    extends SwingWorker<Void, Void> {
        protected ClearTamperStatus() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("ClearTamperFlag button pressed.");
            AppUI.this.deviceType = ScanComm.run(1);
            if (AppUI.this.deviceType == RDevice.RECON && MainMenuUI.convertFirmwareVersionToNumber() >= 1.16) {
                AppUI.this.deviceType = ScanComm.run(9);
            }
            AppUI.this.EnableAllButtons(true);
            if (AppUI.this.deviceType != RDevice.RECON) {
                AppUI.this.HideReconConnectedComponents();
            }
            return null;
        }
    }

    protected class SyncReconTime
    extends SwingWorker<Void, Void> {
        protected SyncReconTime() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("SyncTime button pressed.");
            AppUI.this.deviceType = ScanComm.run(7);
            AppUI.this.EnableAllButtons(true);
            if (AppUI.this.deviceType == RDevice.NONE) {
                AppUI.this.HideReconConnectedComponents();
            }
            return null;
        }
    }

    protected class GeneratePDF
    extends SwingWorker<Void, Void> {
        protected GeneratePDF() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("Generate PDF button pressed.");
            CreatePDF generate_pdf = new CreatePDF();
            generate_pdf.main();
            Desktop desktop = null;
            if (openPDFWind) {
                try {
                    if (Desktop.isDesktopSupported()) {
                        desktop = Desktop.getDesktop();
                        desktop.open(InitDirs.reportsDir);
                    } else {
                        Logging.main("Opening PDF folder window - unsupported desktop.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            AppUI.this.EnableAllButtons(true);
            return null;
        }
    }

    protected class DownloadSession
    extends SwingWorker<Void, Void> {
        protected DownloadSession() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("Download Session button pressed.");
            boolean downloadingSession = false;
            if (configNagDownload) {
                String msg = "Be sure to fill out the deployment information prior\nto generating your report! You may update the fields\nat any time and generate your report again if you\nforget.\n\n";
                JCheckBox chkDoNotRemind = new JCheckBox("Do not show again.");
                Object[] message = new Object[]{msg, chkDoNotRemind};
                int proceed = JOptionPane.showConfirmDialog(null, message, "Proceed with download?", 0, 3);
                if (proceed == 0) {
                    downloadingSession = true;
                    AppUI.this.deviceType = ScanComm.run(6);
                }
                boolean bl = configNagDownload = !chkDoNotRemind.isSelected();
                if (!configNagDownload) {
                    Config tempConfig = new Config();
                    tempConfig.setVisible(false);
                    tempConfig.UpdateNagSetting();
                    tempConfig.dispose();
                }
            } else {
                downloadingSession = true;
                AppUI.this.deviceType = ScanComm.run(6);
            }
            if (AppUI.this.getDataSessions() > 0 && downloadingSession && AppUI.this.invalidFilename) {
                JOptionPane.showMessageDialog(null, "Invalid characters detected in filename. Default filename used.");
            }
            switch (AppUI.this.deviceType) {
                case RECON: {
                    AppUI.this.EnableAllButtons(true);
                    AppUI.this.RefreshSessionList();
                    AppUI.this.RefreshDefaultFileName();
                    if (!autoGeneratePDF || !downloadingSession) break;
                    GeneratePDF pdfWorker = new GeneratePDF();
                    pdfWorker.execute();
                    break;
                }
                case TM: {
                    AppUI.this.EnableAllButtons(true);
                    AppUI.this.RefreshDefaultFileName();
                    if (!autoGeneratePDF || !downloadingSession) break;
                    GeneratePDF pdfWorker = new GeneratePDF();
                    pdfWorker.execute();
                    break;
                }
                case MTM: {
                    AppUI.this.EnableAllButtons(true);
                    AppUI.this.RefreshDefaultFileName();
                    if (!autoGeneratePDF || !downloadingSession) break;
                    GeneratePDF pdfWorker = new GeneratePDF();
                    pdfWorker.execute();
                    break;
                }
                case MTM2: {
                    AppUI.this.EnableAllButtons(true);
                    AppUI.this.RefreshSessionList();
                    AppUI.this.RefreshDefaultFileName();
                    if (!autoGeneratePDF || !downloadingSession) break;
                    GeneratePDF pdfWorker = new GeneratePDF();
                    pdfWorker.execute();
                    break;
                }
                case NONE: {
                    AppUI.this.HideReconConnectedComponents();
                    break;
                }
            }
            return null;
        }
    }

    protected class ClearReconMemory
    extends SwingWorker<Void, Void> {
        protected ClearReconMemory() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("Clear Session button pressed.");
            AppUI.this.deviceType = ScanComm.run(4);
            AppUI.this.EnableAllButtons(true);
            AppUI.this.EnableFileNaming(false);
            return null;
        }
    }

    protected class ClearCurrentSession
    extends SwingWorker<Void, Void> {
        protected ClearCurrentSession() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("Clear Current Session button pressed.");
            AppUI.this.deviceType = ScanComm.run(3);
            AppUI.this.EnableAllButtons(true);
            AppUI.this.RefreshSessionList();
            AppUI.this.RefreshDefaultFileName();
            return null;
        }
    }

    protected class AllDataDump
    extends SwingWorker<Void, Void> {
        protected AllDataDump() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            Logging.main("AllDataDump button pressed.");
            AppUI.this.deviceType = ScanComm.run(5);
            AppUI.this.EnableAllButtons(true);
            return null;
        }
    }

    protected class ConnectWorker
    extends SwingWorker<Void, Void> {
        protected ConnectWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            AppUI.this.EnableAllButtons(false);
            lblReconSN.setVisible(false);
            lblFirmwareVersion.setVisible(false);
            lblDataSessions.setVisible(false);
            lblCalibrationDate.setVisible(false);
            lblCalibrationDue.setVisible(false);
            AppUI.this.btnClearMemory.setVisible(false);
            AppUI.this.btnClearSession.setVisible(false);
            AppUI.this.btnAllDataDump.setVisible(false);
            AppUI.this.btnDownloadSession.setVisible(false);
            AppUI.this.btnClearTamperFlag.setVisible(false);
            AppUI.this.btnOpenSavedFile.setVisible(true);
            AppUI.this.btnOpenPDF.setVisible(true);
            btnGeneratePDF.setVisible(false);
            AppUI.this.btnEraseReconData.setVisible(false);
            lblLoadedFile.setVisible(false);
            lblLoadedFileName.setVisible(false);
            btnMainImages.setVisible(false);
            Logging.main("Connect button pressed.");
            AppUI.this.deviceType = ScanComm.run(1);
            switch (AppUI.this.deviceType) {
                case RECON: {
                    AppUI.this.lblStatusNoRecon.setVisible(false);
                    if (boolShowCMButton) {
                        AppUI.this.btnClearMemory.setVisible(true);
                    } else {
                        AppUI.this.btnClearMemory.setVisible(false);
                    }
                    if (boolShowWXButton) {
                        AppUI.this.btnClearTamperFlag.setVisible(true);
                    } else {
                        AppUI.this.btnClearTamperFlag.setVisible(false);
                    }
                    AppUI.this.btnClearSession.setVisible(false);
                    AppUI.this.btnAllDataDump.setVisible(true);
                    AppUI.this.btnDownloadSession.setVisible(true);
                    AppUI.this.btnOpenSavedFile.setVisible(true);
                    btnGeneratePDF.setVisible(false);
                    AppUI.this.btnEraseReconData.setVisible(true);
                    AppUI.this.btnOpenPDF.setVisible(true);
                    AppUI.this.btnDisplaySettings.setVisible(true);
                    AppUI.this.btnSyncTime.setVisible(true);
                    if (stickerCalDate.contains("Not calibrated")) {
                        lblCalibrationDate.setText("Calibration Date: not calibrated");
                        lblCalibrationDue.setText("Calibration Due: not calibrated");
                    } else {
                        lblCalibrationDate.setText("Calibration Date: " + stickerCalDate);
                        lblCalibrationDue.setText("Calibration Due: " + AppUI.NextCalDate(stickerCalDate));
                    }
                    AppUI.this.RefreshSessionList();
                    AppUI.this.RefreshDefaultFileName();
                    break;
                }
                case TM: {
                    AppUI.this.lblStatusNoRecon.setVisible(false);
                    AppUI.this.btnDownloadSession.setVisible(true);
                    AppUI.this.btnSyncTime.setVisible(true);
                    AppUI.this.btnEraseReconData.setVisible(true);
                    AppUI.this.btnAllDataDump.setVisible(true);
                    AppUI.this.RefreshDefaultFileName();
                    break;
                }
                case MTM: {
                    AppUI.this.lblStatusNoRecon.setVisible(false);
                    AppUI.this.btnDownloadSession.setVisible(true);
                    AppUI.this.btnSyncTime.setVisible(true);
                    AppUI.this.btnEraseReconData.setVisible(true);
                    AppUI.this.btnAllDataDump.setVisible(true);
                    AppUI.this.RefreshDefaultFileName();
                    break;
                }
                case MTM2: {
                    AppUI.this.lblStatusNoRecon.setVisible(false);
                    AppUI.this.btnDownloadSession.setVisible(true);
                    AppUI.this.btnSyncTime.setVisible(true);
                    AppUI.this.btnEraseReconData.setVisible(true);
                    AppUI.this.btnAllDataDump.setVisible(true);
                    AppUI.this.RefreshSessionList();
                    AppUI.this.RefreshDefaultFileName();
                    break;
                }
                case CWLM: {
                    AppUI.this.HideReconConnectedComponents();
                    break;
                }
                case NONE: {
                    AppUI.this.HideReconConnectedComponents();
                    break;
                }
            }
            AppUI.this.EnableAllButtons(true);
            lblFinalAvg.setText("");
            return null;
        }
    }
}

