/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.TiltSensitivity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedList;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.read.biff.BiffException;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DataExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ExportXLS(File outputFile) throws BiffException, WriteException, InterruptedException, IOException {
        WritableWorkbook XLfile = null;
        WritableSheet sheet = null;
        WritableCellFormat XL_Decimal0_Format = null;
        WritableCellFormat XL_Decimal10_Format = null;
        WritableCellFormat XL_Decimal100_Format = null;
        Number Recon_RecordNumber = null;
        Label Recon_Flag = null;
        Number Recon_Year = null;
        Number Recon_Month = null;
        Number Recon_Day = null;
        Number Recon_Hour = null;
        Number Recon_Minute = null;
        Number Recon_Second = null;
        Number Recon_Chamber1Count = null;
        Number Recon_Chamber2Count = null;
        Formula Recon_Chamber1CountPerHour = null;
        Formula Recon_Chamber2CountPerHour = null;
        Formula Recon_Chamber1RadonConc = null;
        Formula Recon_Chamber2RadonConc = null;
        Number Recon_MainInputVoltage = null;
        Number Recon_BattVoltage = null;
        Number Recon_HumidityMin = null;
        Number Recon_HumidityAvg = null;
        Number Recon_HumidityMax = null;
        Number Recon_PressureMin = null;
        Number Recon_PressureAvg = null;
        Number Recon_PressureMax = null;
        Number Recon_TemperatureMin = null;
        Number Recon_TemperatureAvg = null;
        Number Recon_TemperatureMax = null;
        Number Recon_Movements = null;
        Number Recon_CurrentAvg = null;
        Number Recon_HVSupply = null;
        Number Recon_RecordsInSample = null;
        Number Recon_CF1 = null;
        Number Recon_CF2 = null;
        double AvgHumidity = 0.0;
        double AvgTemperature = 0.0;
        double AvgPressure = 0.0;
        long TotalMovements = 0L;
        long TotalChamber1Counts = 0L;
        long TotalChamber2Counts = 0L;
        double CF1 = 0.0;
        double CF2 = 0.0;
        boolean BeginAveraging = false;
        long ActiveRecordCounts = 0L;
        boolean TempYear = false;
        DateTimeFormatter DateTimeDisplay = DateTimeFormatter.ofPattern("MM-dd-yyyy HH:mm");
        Object StartDate = null;
        Object EndDate = null;
        long totalSeconds = 0L;
        long testHours = 0L;
        long testMinutes = 0L;
        long testSeconds = 0L;
        long i = 0L;
        boolean startReached = false;
        int countRow = 0;
        LinkedList<String[]> workingDataSet = new LinkedList<String[]>();
        String strOutputFileName = outputFile.getAbsolutePath();
        CF1 = LoadSavedFile.LoadedReconCF1;
        CF2 = LoadSavedFile.LoadedReconCF2;
        try {
            for (int iter = 0; iter < LoadSavedFile.fileBuffer.size(); ++iter) {
                workingDataSet.add(LoadSavedFile.fileBuffer.get(iter).split(","));
            }
            Workbook workbook = Workbook.getWorkbook((File)new File("ReconTemplate.xls"));
            XLfile = Workbook.createWorkbook((File)new File(strOutputFileName), (Workbook)workbook);
            workbook.close();
            sheet = XLfile.getSheet(0);
            XL_Decimal0_Format = new WritableCellFormat((DisplayFormat)new NumberFormat("0"));
            XL_Decimal0_Format.setAlignment(Alignment.CENTRE);
            XL_Decimal10_Format = new WritableCellFormat((DisplayFormat)new NumberFormat("0.0"));
            XL_Decimal10_Format.setAlignment(Alignment.CENTRE);
            XL_Decimal100_Format = new WritableCellFormat((DisplayFormat)new NumberFormat("0.00"));
            XL_Decimal100_Format.setAlignment(Alignment.CENTRE);
            for (int iter = 0; iter < workingDataSet.size(); ++iter) {
                if (((String[])workingDataSet.get(iter))[2].equals("H") || ((String[])workingDataSet.get(iter))[2].equals("Z")) continue;
                int rows_total = sheet.getRows();
                sheet.insertRow(rows_total + 1);
                if (((String[])workingDataSet.get(iter))[2].equals("S")) {
                    startReached = true;
                    countRow = LoadSavedFile.longTermMode ? rows_total + 2 : rows_total + 6;
                    ++i;
                }
                if (((String[])workingDataSet.get(iter))[2].equals("I") && startReached) {
                    ++i;
                }
                Recon_RecordNumber = new Number(0, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[1]));
                sheet.addCell((WritableCell)Recon_RecordNumber);
                Recon_Flag = new Label(1, rows_total, ((String[])workingDataSet.get(iter))[2]);
                sheet.addCell((WritableCell)Recon_Flag);
                Recon_Year = new Number(2, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[3]));
                sheet.addCell((WritableCell)Recon_Year);
                Recon_Month = new Number(3, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[4]));
                sheet.addCell((WritableCell)Recon_Month);
                Recon_Day = new Number(4, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[5]));
                sheet.addCell((WritableCell)Recon_Day);
                Recon_Hour = new Number(5, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[6]));
                sheet.addCell((WritableCell)Recon_Hour);
                Recon_Minute = new Number(6, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[7]));
                sheet.addCell((WritableCell)Recon_Minute);
                Recon_Second = new Number(7, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[8]));
                sheet.addCell((WritableCell)Recon_Second);
                Recon_Movements = new Number(8, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[9]));
                sheet.addCell((WritableCell)Recon_Movements);
                Recon_Chamber1Count = new Number(9, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[10]));
                sheet.addCell((WritableCell)Recon_Chamber1Count);
                if (LoadSavedFile.longTermMode) {
                    if (rows_total == countRow) {
                        Recon_Chamber1CountPerHour = new Formula(10, rows_total, "SUM(J" + rows_total + ":J" + (rows_total + 1) + ")");
                        sheet.addCell((WritableCell)Recon_Chamber1CountPerHour);
                        Recon_Chamber1RadonConc = AppUI.unitType.equals("US") ? new Formula(11, rows_total, "K" + (rows_total + 1) + "/$AE$2", (CellFormat)XL_Decimal10_Format) : new Formula(11, rows_total, "K" + (rows_total + 1) + "/$AE$2*37", (CellFormat)XL_Decimal0_Format);
                        sheet.addCell((WritableCell)Recon_Chamber1RadonConc);
                        Recon_Chamber2CountPerHour = new Formula(13, rows_total, "SUM(M" + rows_total + ":M" + (rows_total + 1) + ")");
                        sheet.addCell((WritableCell)Recon_Chamber2CountPerHour);
                        Recon_Chamber2RadonConc = AppUI.unitType.equals("US") ? new Formula(14, rows_total, "N" + (rows_total + 1) + "/$AF$2", (CellFormat)XL_Decimal10_Format) : new Formula(14, rows_total, "N" + (rows_total + 1) + "/$AF$2*37", (CellFormat)XL_Decimal0_Format);
                        sheet.addCell((WritableCell)Recon_Chamber2RadonConc);
                        i = 0L;
                        countRow = rows_total + 2;
                    }
                } else if (rows_total == countRow) {
                    Recon_Chamber1CountPerHour = new Formula(10, rows_total, "SUM(J" + (rows_total - 4) + ":J" + (rows_total + 1) + ")");
                    sheet.addCell((WritableCell)Recon_Chamber1CountPerHour);
                    Recon_Chamber1RadonConc = AppUI.unitType.equals("US") ? new Formula(11, rows_total, "K" + (rows_total + 1) + "/$AE$2", (CellFormat)XL_Decimal10_Format) : new Formula(11, rows_total, "K" + (rows_total + 1) + "/$AE$2*37", (CellFormat)XL_Decimal0_Format);
                    sheet.addCell((WritableCell)Recon_Chamber1RadonConc);
                    Recon_Chamber2CountPerHour = new Formula(13, rows_total, "SUM(M" + (rows_total - 4) + ":M" + (rows_total + 1) + ")");
                    sheet.addCell((WritableCell)Recon_Chamber2CountPerHour);
                    Recon_Chamber2RadonConc = AppUI.unitType.equals("US") ? new Formula(14, rows_total, "N" + (rows_total + 1) + "/$AF$2", (CellFormat)XL_Decimal10_Format) : new Formula(14, rows_total, "N" + (rows_total + 1) + "/$AF$2*37", (CellFormat)XL_Decimal0_Format);
                    sheet.addCell((WritableCell)Recon_Chamber2RadonConc);
                    i = 0L;
                    countRow = rows_total + 6;
                }
                Recon_Chamber2Count = new Number(12, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[11]));
                sheet.addCell((WritableCell)Recon_Chamber2Count);
                Recon_MainInputVoltage = new Number(15, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[12]), (CellFormat)XL_Decimal100_Format);
                sheet.addCell((WritableCell)Recon_MainInputVoltage);
                Recon_BattVoltage = new Number(16, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[13]), (CellFormat)XL_Decimal100_Format);
                sheet.addCell((WritableCell)Recon_BattVoltage);
                Recon_HumidityMin = new Number(17, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[14]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_HumidityMin);
                Recon_HumidityAvg = new Number(18, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[15]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_HumidityAvg);
                Recon_HumidityMax = new Number(19, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[16]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_HumidityMax);
                Recon_PressureMin = new Number(20, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[17]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_PressureMin);
                Recon_PressureAvg = new Number(21, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[18]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_PressureAvg);
                Recon_PressureMax = new Number(22, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[19]), (CellFormat)XL_Decimal10_Format);
                sheet.addCell((WritableCell)Recon_PressureMax);
                Recon_TemperatureMin = new Number(23, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[20]), (CellFormat)XL_Decimal100_Format);
                sheet.addCell((WritableCell)Recon_TemperatureMin);
                Recon_TemperatureAvg = new Number(24, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[21]), (CellFormat)XL_Decimal100_Format);
                sheet.addCell((WritableCell)Recon_TemperatureAvg);
                Recon_TemperatureMax = new Number(25, rows_total, Double.parseDouble(((String[])workingDataSet.get(iter))[22]), (CellFormat)XL_Decimal100_Format);
                sheet.addCell((WritableCell)Recon_TemperatureMax);
                Recon_CurrentAvg = new Number(26, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[23]));
                sheet.addCell((WritableCell)Recon_CurrentAvg);
                Recon_HVSupply = new Number(27, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[24]));
                sheet.addCell((WritableCell)Recon_HVSupply);
                Recon_RecordsInSample = new Number(28, rows_total, (double)Long.parseLong(((String[])workingDataSet.get(iter))[25].replaceAll("[\n\r]", "")));
                sheet.addCell((WritableCell)Recon_RecordsInSample);
                if (rows_total == 1) {
                    Recon_CF1 = new Number(30, rows_total, CF1);
                    sheet.addCell((WritableCell)Recon_CF1);
                    Recon_CF2 = new Number(31, rows_total, CF2);
                    sheet.addCell((WritableCell)Recon_CF2);
                }
                if (!AppUI.boolShowXLSHighlights || ((String[])workingDataSet.get(iter)).length != 28) continue;
                if (((String[])workingDataSet.get(iter))[26].contains("true")) {
                    WritableCell Ch1Cell = sheet.getWritableCell(9, rows_total);
                    WritableCellFormat Ch1CellFormat = new WritableCellFormat(Ch1Cell.getCellFormat());
                    Ch1CellFormat.setBackground(Colour.YELLOW);
                    Ch1CellFormat.setAlignment(Alignment.CENTRE);
                    Ch1Cell.setCellFormat((CellFormat)Ch1CellFormat);
                }
                if (!((String[])workingDataSet.get(iter))[27].contains("true")) continue;
                WritableCell Ch2Cell = sheet.getWritableCell(12, rows_total);
                WritableCellFormat Ch2CellFormat = new WritableCellFormat(Ch2Cell.getCellFormat());
                Ch2CellFormat.setBackground(Colour.YELLOW);
                Ch2CellFormat.setAlignment(Alignment.CENTRE);
                Ch2Cell.setCellFormat((CellFormat)Ch2CellFormat);
            }
            XLfile.addNameArea("Ch1Counts", sheet, 9, 1, 9, sheet.getRows() - 1);
            XLfile.addNameArea("Ch2Counts", sheet, 11, 1, 11, sheet.getRows() - 1);
        }
        catch (IOException ex) {
            Logging.main("ERROR: IOException in ExportXLS.main()!");
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception caught in ExportXLS.main()!");
        }
        finally {
            XLfile.write();
            XLfile.close();
        }
    }

    public static void ExportCSV(File outputFile) {
        String outputFileName = outputFile.getAbsolutePath();
        DecimalFormat cfFormat = new DecimalFormat("0.000");
        boolean wasLineModified = false;
        try {
            CharSequence[] strLine_parsed;
            int i;
            PrintWriter pw = new PrintWriter(outputFileName);
            for (i = 0; i < LoadSavedFile.fileBuffer.size(); ++i) {
                if (LoadSavedFile.fileBuffer.get(i).contains("H,") || LoadSavedFile.fileBuffer.get(i).contains("Z,") || LoadSavedFile.fileBuffer.get(i).contains("D,")) continue;
                strLine_parsed = LoadSavedFile.fileBuffer.get(i).split(",");
                if (strLine_parsed[26].contains("true")) {
                    strLine_parsed[10] = strLine_parsed[26].substring(5).replaceAll("\\)", "").trim();
                    wasLineModified = true;
                }
                if (strLine_parsed[27].contains("true")) {
                    strLine_parsed[11] = strLine_parsed[27].substring(5).replaceAll("\\)", "").trim();
                    wasLineModified = true;
                }
                if (wasLineModified) {
                    LoadSavedFile.fileBuffer.set(i, String.join((CharSequence)",", strLine_parsed));
                }
                wasLineModified = false;
            }
            for (i = 0; i < LoadSavedFile.fileBuffer.size(); ++i) {
                strLine_parsed = LoadSavedFile.fileBuffer.get(i).split(",");
                CharSequence[] strLine_corrected = new String[26];
                if (!(LoadSavedFile.fileBuffer.get(i).contains("H,") || LoadSavedFile.fileBuffer.get(i).contains("Z,") || LoadSavedFile.fileBuffer.get(i).contains("D,"))) {
                    for (int j = 0; j < 26; ++j) {
                        strLine_corrected[j] = strLine_parsed[j];
                        LoadSavedFile.fileBuffer.set(i, String.join((CharSequence)",", strLine_corrected));
                    }
                }
                pw.write(LoadSavedFile.fileBuffer.get(i) + AppUI.newline);
            }
            pw.write(AppUI.newline + "Instrument Serial:\t" + LoadSavedFile.strInstrumentSerial + AppUI.newline);
            pw.write("Calibration Date =\t" + LoadSavedFile.strCalDate + AppUI.newline);
            pw.write("Chamber 1 CF:\t\t" + cfFormat.format(LoadSavedFile.LoadedReconCF1) + AppUI.newline);
            pw.write("Chamber 2 CF:\t\t" + cfFormat.format(LoadSavedFile.LoadedReconCF2) + AppUI.newline);
            pw.close();
        }
        catch (FileNotFoundException fnfEx) {
            Logging.main("ERROR: FileNotFoundException in DataExporter.ExportCSV()!");
        }
    }

    public static void ExportRRMText(File outputFile) {
        LinkedList<String> modifiedDataBuffer = new LinkedList<String>();
        String outputFileName = outputFile.getAbsolutePath();
        DecimalFormat cfFormat = new DecimalFormat("0.000");
        DecimalFormat formatTenth = new DecimalFormat("0.0");
        DecimalFormat formatHundredth = new DecimalFormat("0.00");
        String newline = "\r\n";
        DateTimeFormatter dateForm = DateTimeFormatter.ofPattern("M/d/uuuu h:mm:ss a");
        LocalDateTime startOfTest = LocalDateTime.now();
        LocalDateTime endOfTest = LocalDateTime.now();
        boolean beginAveraging = false;
        int averageCount = 0;
        int totalMovements = 0;
        float averageTemp = 0.0f;
        float averagePres = 0.0f;
        float averageHum = 0.0f;
        CharSequence[] newStringArray = null;
        try {
            for (int i = 0; i < LoadSavedFile.fileBuffer.size(); ++i) {
                CharSequence[] lineParsed;
                newStringArray = lineParsed = LoadSavedFile.fileBuffer.get(i).split(",");
                if (!String.join((CharSequence)",", lineParsed).contains("=DB")) continue;
                if (!(((String)lineParsed[2]).contains("H") && ((String)lineParsed[2]).contains("Z") || !((String)lineParsed[lineParsed.length - 1]).contains("true") && !((String)lineParsed[lineParsed.length - 1]).contains("false"))) {
                    newStringArray = new String[lineParsed.length - 2];
                    for (int j = 0; j < newStringArray.length; ++j) {
                        newStringArray[j] = ((String)lineParsed[j]).trim();
                    }
                }
                if (((String)lineParsed[2]).contains("S")) {
                    startOfTest = LocalDateTime.parse("20" + ((String)lineParsed[3]).trim() + "-" + ((String)lineParsed[4]).trim() + "-" + ((String)lineParsed[5]).trim() + "T" + ((String)lineParsed[6]).trim() + ":" + ((String)lineParsed[7]).trim() + ":" + ((String)lineParsed[8]).trim());
                    beginAveraging = true;
                }
                if (((String)lineParsed[2]).contains("E")) {
                    endOfTest = LocalDateTime.parse("20" + ((String)lineParsed[3]).trim() + "-" + ((String)lineParsed[4]).trim() + "-" + ((String)lineParsed[5]).trim() + "T" + ((String)lineParsed[6]).trim() + ":" + ((String)lineParsed[7]).trim() + ":" + ((String)lineParsed[8]).trim());
                }
                if (((String)lineParsed[2]).contains("Z")) {
                    beginAveraging = false;
                }
                if (beginAveraging) {
                    ++averageCount;
                    totalMovements += Integer.parseInt(((String)lineParsed[9]).trim());
                    averageHum += Float.parseFloat(((String)lineParsed[15]).trim());
                    averagePres += Float.parseFloat(((String)lineParsed[18]).trim());
                    averageTemp += Float.parseFloat(((String)lineParsed[21]).trim());
                }
                modifiedDataBuffer.add(i, String.join((CharSequence)",", newStringArray));
            }
            averageHum /= (float)averageCount;
            averageTemp /= (float)averageCount;
            averagePres /= (float)averageCount;
            String strStartDateTime = dateForm.format(startOfTest);
            String strEndDateTime = dateForm.format(endOfTest);
            float hours = ChronoUnit.HOURS.between(startOfTest, endOfTest);
            float minutes = ChronoUnit.MINUTES.between(startOfTest, endOfTest);
            float seconds = ChronoUnit.SECONDS.between(startOfTest, endOfTest);
            String strDurSeconds = Integer.toString((int)(seconds % 60.0f));
            String strDurMinutes = Integer.toString((int)(minutes % 60.0f));
            String strDurDays = Integer.toString((int)(hours / 24.0f));
            String strDurHours = Integer.toString((int)(hours % 24.0f));
            String strTotalTestDuration = strDurDays + " days, " + strDurHours + " hours, " + strDurMinutes + " minutes, " + strDurSeconds + " seconds";
            PrintWriter pw = new PrintWriter(outputFileName);
            for (int i = 0; i < modifiedDataBuffer.size(); ++i) {
                pw.write("[" + (String)modifiedDataBuffer.get(i) + "]" + newline);
            }
            pw.write(newline);
            pw.write(newline);
            pw.write(newline);
            pw.write(newline);
            pw.write("Customer information:" + newline);
            pw.write(LoadSavedFile.strCustomerInfo.trim());
            pw.write(newline);
            pw.write(newline);
            pw.write("Test site information:" + newline);
            pw.write(LoadSavedFile.strTestSiteInfo.trim());
            pw.write(newline);
            pw.write(newline);
            pw.write("SUMMARY: " + newline);
            pw.write("Instrument Serial: " + LoadSavedFile.strInstrumentSerial.trim() + newline);
            pw.write("Start Date/Time: " + strStartDateTime + newline);
            pw.write("End Date/Time: " + strEndDateTime + newline);
            pw.write("Total Test Duration: " + strTotalTestDuration + newline);
            pw.write("Total Movements: " + Integer.toString(totalMovements) + newline);
            pw.write("Avg. Humidity = " + formatTenth.format(averageHum) + "%" + newline);
            pw.write("Avg. Pressure = " + formatTenth.format(averagePres) + "mBar" + newline);
            pw.write("Avg. Temperature = " + formatHundredth.format(averageTemp) + "C" + newline);
            pw.write("Chamber 1 CF: " + cfFormat.format(LoadSavedFile.LoadedReconCF1) + newline);
            pw.write("Chamber 2 CF: " + cfFormat.format(LoadSavedFile.LoadedReconCF2) + newline);
            pw.write("Calibration Date = " + LoadSavedFile.strCalDate + newline);
            pw.write("Protocol: " + LoadSavedFile.strReportProtocol.trim() + newline);
            pw.write("Tampering: " + LoadSavedFile.strReportTampering.trim() + newline);
            pw.write("Weather: " + LoadSavedFile.strReportWeather.trim() + newline);
            pw.write("Mitigation: " + LoadSavedFile.strReportMitigation.trim() + newline);
            pw.write("Comment: " + LoadSavedFile.strReportComment.trim() + newline);
            pw.write("Location: " + LoadSavedFile.strLocation.trim() + newline);
            pw.write(newline);
            pw.write(newline);
            pw.write("Analyzed By: " + LoadSavedFile.strAnalyzedBy.trim() + newline);
            pw.write("Deployed By: " + LoadSavedFile.strDeployedBy.trim() + newline);
            pw.write("Retrieved By: " + LoadSavedFile.strRetrievedBy.trim());
            pw.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in DataExporter.ExportRRMText()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    public static void ExportXLSXReport(File outputFile) {
        SimpleDateFormat calDateInputFormat = new SimpleDateFormat("LL/dd/yyyy");
        SimpleDateFormat startEndDateInputFormat = new SimpleDateFormat("LL-dd-yyyy HH:mm");
        LinkedList<XSSFRow> listHourlyRows = new LinkedList<XSSFRow>();
        LinkedList<Object[]> listSessionAverages = DataExporter.GetHourlyAverageList();
        int startAverage = AppUI.excludeFirst4Hours ? 4 : 0;
        int intNumHoursCounted = 0;
        double dblFinalRadonAvg1 = 0.0;
        double dblFinalRadonAvg2 = 0.0;
        for (int i = 0; i < listSessionAverages.size(); ++i) {
            if (i < startAverage) continue;
            if (!AppUI.boolUseTwoChambers) {
                dblFinalRadonAvg1 += ((Double)listSessionAverages.get(i)[2]).doubleValue();
            } else {
                dblFinalRadonAvg1 += ((Double)listSessionAverages.get(i)[2]).doubleValue();
                dblFinalRadonAvg2 += ((Double)listSessionAverages.get(i)[3]).doubleValue();
            }
            ++intNumHoursCounted;
        }
        if (!AppUI.boolUseTwoChambers) {
            dblFinalRadonAvg1 /= (double)intNumHoursCounted;
        } else {
            dblFinalRadonAvg1 /= (double)intNumHoursCounted;
            dblFinalRadonAvg2 /= (double)intNumHoursCounted;
        }
        String strRadonUnit = LoadSavedFile.strUnitSystem.equals("US") ? "pCi/L" : "Bq/m\u00b3";
        try {
            FileOutputStream output = new FileOutputStream(outputFile.getAbsolutePath());
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet1 = workbook.createSheet("Radon Report");
            String strFormat0 = "0";
            String strFormat1 = "0.0";
            XSSFDataFormat fmt = workbook.createDataFormat();
            XSSFCellStyle csOne = workbook.createCellStyle();
            XSSFCellStyle csZero = workbook.createCellStyle();
            csOne.setDataFormat(fmt.getFormat(strFormat1));
            csZero.setDataFormat(fmt.getFormat(strFormat0));
            XSSFFont plainFontBig = workbook.createFont();
            plainFontBig.setFontHeightInPoints((short)14);
            plainFontBig.setFontName("Sans");
            plainFontBig.setBold(false);
            XSSFCellStyle stylePlainBig = workbook.createCellStyle();
            stylePlainBig.setFont((Font)plainFontBig);
            XSSFFont plainFontMed = workbook.createFont();
            plainFontMed.setFontHeightInPoints((short)12);
            plainFontMed.setFontName("Sans");
            plainFontMed.setBold(false);
            XSSFCellStyle stylePlainMed = workbook.createCellStyle();
            stylePlainMed.setFont((Font)plainFontMed);
            XSSFFont boldFontSmall = workbook.createFont();
            boldFontSmall.setFontHeightInPoints((short)10);
            boldFontSmall.setFontName("Sans");
            boldFontSmall.setBold(true);
            XSSFCellStyle styleBoldSmall = workbook.createCellStyle();
            styleBoldSmall.setFont((Font)boldFontSmall);
            XSSFFont redFontBig = workbook.createFont();
            redFontBig.setFontHeightInPoints((short)14);
            redFontBig.setFontName("Sans");
            redFontBig.setBold(true);
            redFontBig.setColor(IndexedColors.RED.getIndex());
            XSSFCellStyle styleRedRadon = workbook.createCellStyle();
            styleRedRadon.setFont((Font)redFontBig);
            XSSFCellStyle styleWrapped = workbook.createCellStyle();
            styleWrapped.setWrapText(true);
            int rowPos = 0;
            int colPos = 0;
            int colRadon1 = 0;
            int colRadon2 = 0;
            Date dateNow = new Date();
            sheet1.createRow(rowPos).createCell(colPos).setCellValue(AppUI.dateFormat.format(dateNow));
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)stylePlainBig);
            sheet1.createRow(++rowPos).createCell(colPos).setCellValue("RDT " + MainMenuUI.appUI.version);
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)stylePlainMed);
            sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Instrument SN: " + LoadSavedFile.strInstrumentSerial);
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)stylePlainMed);
            rowPos += 2;
            if (AppUI.showDepInfXLSXReport) {
                sheet1.createRow(rowPos).createCell(colPos).setCellValue("CUSTOMER INFORMATION");
                sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                sheet1.createRow(++rowPos).createCell(colPos).setCellValue(AppUI.txtCustomerInfo.getText());
                sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleWrapped);
                sheet1.getRow(rowPos).setHeightInPoints(3.0f * sheet1.getDefaultRowHeightInPoints());
                sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("TEST SITE INFORMATION");
                sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                sheet1.createRow(++rowPos).createCell(colPos).setCellValue(AppUI.txtTestSiteInfo.getText());
                sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleWrapped);
                sheet1.getRow(rowPos).setHeightInPoints(3.0f * sheet1.getDefaultRowHeightInPoints());
                sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("TEST LOCATION");
                sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                sheet1.createRow(++rowPos).createCell(colPos).setCellValue(AppUI.txtLocation.getText());
                rowPos += 2;
            }
            sheet1.createRow(rowPos).createCell(colPos).setCellValue("CALIBRATION DATE");
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
            ++rowPos;
            try {
                String strCalDate = AppUI.dateFormat.format(calDateInputFormat.parse(LoadSavedFile.strCalDate));
                sheet1.createRow(rowPos).createCell(colPos).setCellValue(strCalDate);
                rowPos += 2;
            }
            catch (Exception pe) {
                sheet1.createRow(rowPos).createCell(colPos).setCellValue("Unknown");
                rowPos += 2;
            }
            sheet1.createRow(rowPos).createCell(colPos).setCellValue("START");
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
            sheet1.createRow(++rowPos).createCell(colPos).setCellValue(AppUI.dateTimeFormat.format(startEndDateInputFormat.parse(LoadSavedFile.strStartDate)));
            sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("END");
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
            sheet1.createRow(++rowPos).createCell(colPos).setCellValue(AppUI.dateTimeFormat.format(startEndDateInputFormat.parse(LoadSavedFile.strEndDate)));
            sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("RADON AVG.");
            sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
            XSSFRow rowRadonAvg = sheet1.createRow(++rowPos);
            rowPos += 2;
            if (!AppUI.boolUseTwoChambers) {
                if (AppUI.unitType.equals("US")) {
                    styleRedRadon.setDataFormat(fmt.getFormat(strFormat1));
                    rowRadonAvg.createCell(colPos).setCellValue(dblFinalRadonAvg1);
                    rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                } else {
                    styleRedRadon.setDataFormat(fmt.getFormat(strFormat0));
                    rowRadonAvg.createCell(colPos).setCellValue(dblFinalRadonAvg1);
                    rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                }
            } else if (AppUI.unitType.equals("US")) {
                styleRedRadon.setDataFormat(fmt.getFormat(strFormat1));
                rowRadonAvg.createCell(colPos).setCellValue(dblFinalRadonAvg1);
                rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                rowRadonAvg.createCell(++colPos).setCellValue(dblFinalRadonAvg2);
                rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                colPos = 0;
            } else {
                styleRedRadon.setDataFormat(fmt.getFormat(strFormat0));
                rowRadonAvg.createCell(colPos).setCellValue(dblFinalRadonAvg1);
                rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                rowRadonAvg.createCell(++colPos).setCellValue(dblFinalRadonAvg2);
                rowRadonAvg.getCell(colPos).setCellStyle((CellStyle)styleRedRadon);
                colPos = 0;
            }
            if (AppUI.showDepInfXLSXReport) {
                if (MainMenuUI.appUI instanceof MainMenuUI) {
                    sheet1.createRow(rowPos).createCell(colPos).setCellValue("Deployed by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainDeployedBy.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Retrieved by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainRetrievedBy.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Analyzed by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainAnalyzedBy.getText());
                    colPos = 0;
                    sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("Protocol:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainProtocol.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Tampering:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainTampering.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Weather:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainWeather.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Mitigation:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainMitigation.getText());
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Comment:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(AppUI.txtMainComment.getText());
                    rowPos += 2;
                    colPos = 0;
                } else {
                    sheet1.createRow(rowPos).createCell(colPos).setCellValue("Deployed by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strDeployedBy);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Retrieved by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strRetrievedBy);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Analyzed by:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strAnalyzedBy);
                    colPos = 0;
                    sheet1.createRow(rowPos += 2).createCell(colPos).setCellValue("Protocol:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strReportProtocol);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Tampering:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strReportTampering);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Weather:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strReportWeather);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Mitigation:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strReportMitigation);
                    colPos = 0;
                    sheet1.createRow(++rowPos).createCell(colPos).setCellValue("Comment:");
                    sheet1.getRow(rowPos).getCell(colPos).setCellStyle((CellStyle)styleBoldSmall);
                    sheet1.getRow(rowPos).createCell(++colPos).setCellValue(LoadSavedFile.strReportComment);
                    rowPos += 2;
                    colPos = 0;
                }
            }
            XSSFRow rowHourlyLabels = sheet1.createRow(rowPos);
            rowHourlyLabels.createCell(colPos).setCellValue("Hour");
            rowHourlyLabels.createCell(++colPos).setCellValue("Date/Time");
            ++colPos;
            if (!AppUI.boolUseTwoChambers) {
                rowHourlyLabels.createCell(colPos).setCellValue("Radon (" + strRadonUnit + ")");
                colRadon1 = colPos++;
            } else {
                rowHourlyLabels.createCell(colPos).setCellValue("Radon (" + strRadonUnit + ")");
                colRadon1 = colPos++;
                rowHourlyLabels.createCell(colPos).setCellValue("Radon (" + strRadonUnit + ")");
                colRadon2 = colPos++;
            }
            rowHourlyLabels.createCell(colPos).setCellValue("Tilts");
            ++colPos;
            if (AppUI.unitType.equals("US")) {
                rowHourlyLabels.createCell(colPos).setCellValue("Temp. (F)");
                rowHourlyLabels.createCell(++colPos).setCellValue("Humidity");
                rowHourlyLabels.createCell(++colPos).setCellValue("Pressure (inHG)");
                colPos = 0;
            } else {
                rowHourlyLabels.createCell(colPos).setCellValue("Temp. (C)");
                rowHourlyLabels.createCell(++colPos).setCellValue("Humidity");
                rowHourlyLabels.createCell(++colPos).setCellValue("Pressure (mBar)");
                colPos = 0;
            }
            for (Cell tempCell : rowHourlyLabels) {
                tempCell.setCellStyle((CellStyle)styleBoldSmall);
            }
            ++rowPos;
            for (int i = 0; i < listSessionAverages.size(); ++i) {
                listHourlyRows.addLast(sheet1.createRow(rowPos));
                ++rowPos;
                for (int j = 0; j < listSessionAverages.get(i).length; ++j) {
                    if (listSessionAverages.get(i)[j] instanceof String) {
                        ((Row)listHourlyRows.getLast()).createCell(colPos).setCellValue((String)listSessionAverages.get(i)[j]);
                        ((Row)listHourlyRows.getLast()).getCell(colPos).setCellStyle((CellStyle)csZero);
                    } else if (listSessionAverages.get(i)[j] instanceof Long) {
                        ((Row)listHourlyRows.getLast()).createCell(colPos).setCellValue((double)((Long)listSessionAverages.get(i)[j]).longValue());
                        ((Row)listHourlyRows.getLast()).getCell(colPos).setCellStyle((CellStyle)csZero);
                    } else if (listSessionAverages.get(i)[j] instanceof Double) {
                        ((Row)listHourlyRows.getLast()).createCell(colPos).setCellValue(((Double)listSessionAverages.get(i)[j]).doubleValue());
                        ((Row)listHourlyRows.getLast()).getCell(colPos).setCellStyle((CellStyle)csOne);
                    }
                    if (++colPos <= listSessionAverages.get(i).length - 1) continue;
                    colPos = 0;
                }
            }
            if (AppUI.unitType.equals("SI")) {
                int colCount;
                if (colRadon1 != 0) {
                    block8: for (Row tempRow : sheet1) {
                        colCount = 0;
                        for (Cell tempCell : tempRow) {
                            if (tempCell.getCellType() != CellType.STRING && colCount == colRadon1) {
                                tempCell.setCellStyle((CellStyle)csZero);
                                continue block8;
                            }
                            ++colCount;
                        }
                    }
                }
                if (colRadon2 != 0) {
                    block10: for (Row tempRow : sheet1) {
                        colCount = 0;
                        for (Cell tempCell : tempRow) {
                            if (tempCell.getCellType() != CellType.STRING && colCount == colRadon2) {
                                tempCell.setCellStyle((CellStyle)csZero);
                                continue block10;
                            }
                            ++colCount;
                        }
                    }
                }
            }
            sheet1.autoSizeColumn(0);
            sheet1.autoSizeColumn(1);
            sheet1.autoSizeColumn(2);
            sheet1.autoSizeColumn(3);
            sheet1.autoSizeColumn(4);
            sheet1.autoSizeColumn(5);
            sheet1.autoSizeColumn(6);
            sheet1.autoSizeColumn(7);
            for (Row tempRow : sheet1) {
                for (Cell tempCell : tempRow) {
                    CellStyle centerCS = tempCell.getCellStyle();
                    centerCS.setAlignment(HorizontalAlignment.CENTER);
                    tempCell.setCellStyle(centerCS);
                }
            }
            workbook.write((OutputStream)output);
            output.close();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in DataExporter.ExportReportXLSX()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    public static LinkedList<String[]> GetTrimmedDataSession(LinkedList<String> input) {
        LinkedList<String[]> outputSamples = new LinkedList<String[]>();
        for (int it = 0; it < input.size(); ++it) {
            String[] stringsTrimmed = input.get(it).split(",");
            for (int it1 = 0; it1 < stringsTrimmed.length; ++it1) {
                stringsTrimmed[it1] = stringsTrimmed[it1].trim();
            }
            outputSamples.add(stringsTrimmed);
        }
        return outputSamples;
    }

    private static LinkedList<Object[]> GetHourlyAverageList() {
        int hourSampleCounter = 6;
        if (LoadSavedFile.longTermMode) {
            hourSampleCounter = 2;
        }
        LinkedList<String[]> listWorking = LoadSavedFile.dataRangePresent ? DataExporter.GetTrimmedDataSession(LoadSavedFile.rangeBuffer) : DataExporter.GetTrimmedDataSession(LoadSavedFile.fileBuffer);
        LinkedList<Object[]> listResult = new LinkedList<Object[]>();
        Boolean beginAveraging = false;
        int averageCount = 0;
        int chamber1Counts = 0;
        int chamber2Counts = 0;
        int totalMovements = 0;
        float averageTemp = 0.0f;
        float averagePres = 0.0f;
        float averageHum = 0.0f;
        Date hourlyDateTime = new Date();
        Date hourlyDateTimeLast = new Date();
        SimpleDateFormat formatDataTime = new SimpleDateFormat("yyLLddHHmm");
        long hourCount = 0L;
        for (int i = 0; i < listWorking.size(); ++i) {
            PrintWriter pw;
            StringWriter sw;
            if (!String.join((CharSequence)",", listWorking.get(i)).contains("=DB")) continue;
            if (listWorking.get(i)[2].contains("S")) {
                try {
                    hourlyDateTimeLast = formatDataTime.parse(listWorking.get(i)[3].trim() + listWorking.get(i)[4].trim() + listWorking.get(i)[5].trim() + listWorking.get(i)[6].trim() + listWorking.get(i)[7].trim());
                }
                catch (Exception anyEx) {
                    Logging.main("ERROR: Exception in DataExporter.GetHourlyAverageList()!");
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    anyEx.printStackTrace(pw);
                    Logging.main(sw.toString());
                }
                beginAveraging = true;
            }
            if (listWorking.get(i)[2].contains("Z")) {
                beginAveraging = false;
            }
            if (!beginAveraging.booleanValue()) continue;
            if (listWorking.get(i)[2].contains("S")) {
                ++averageCount;
                continue;
            }
            chamber1Counts += Integer.parseInt(listWorking.get(i)[10].trim());
            chamber2Counts += Integer.parseInt(listWorking.get(i)[11].trim());
            totalMovements += Integer.parseInt(listWorking.get(i)[9].trim());
            averageHum += Float.parseFloat(listWorking.get(i)[15].trim());
            if (AppUI.unitType.equals("US")) {
                averagePres = (float)((double)averagePres + (double)Float.parseFloat(listWorking.get(i)[18].trim()) * 0.02953);
                averageTemp += Float.parseFloat(listWorking.get(i)[21].trim()) * 9.0f / 5.0f + 32.0f;
            } else {
                averagePres += Float.parseFloat(listWorking.get(i)[18].trim());
                averageTemp += Float.parseFloat(listWorking.get(i)[21].trim());
            }
            if (averageCount == hourSampleCounter) {
                ++hourCount;
                try {
                    hourlyDateTime = formatDataTime.parse(listWorking.get(i)[3].trim() + listWorking.get(i)[4].trim() + listWorking.get(i)[5].trim() + listWorking.get(i)[6].trim() + listWorking.get(i)[7].trim());
                    long diffMinutes = (hourlyDateTime.getTime() - hourlyDateTimeLast.getTime()) / 60000L;
                    if (diffMinutes < 60L) continue;
                    hourlyDateTimeLast = new Date(hourlyDateTime.getTime());
                }
                catch (Exception anyEx) {
                    Logging.main("ERROR: Exception in DataExporter.GetHourlyAverageList()!");
                    sw = new StringWriter();
                    pw = new PrintWriter(sw);
                    anyEx.printStackTrace(pw);
                    Logging.main(sw.toString());
                }
                String strDateTime = AppUI.dateTimeFormat.format(hourlyDateTime);
                if (AppUI.unitType.equals("US")) {
                    if (AppUI.boolUseTwoChambers) {
                        listResult.add(new Object[]{Long.toString(hourCount), strDateTime, new Double((double)chamber1Counts / LoadSavedFile.LoadedReconCF1), new Double((double)chamber2Counts / LoadSavedFile.LoadedReconCF2), new Long(TiltSensitivity.main(totalMovements)), new Double((double)averageTemp / (double)hourSampleCounter), new Double((double)averageHum / (double)hourSampleCounter), new Double(averagePres / (float)hourSampleCounter)});
                    } else {
                        listResult.add(new Object[]{Long.toString(hourCount), strDateTime, new Double(((double)chamber1Counts / LoadSavedFile.LoadedReconCF1 + (double)chamber2Counts / LoadSavedFile.LoadedReconCF2) / 2.0), new Long(TiltSensitivity.main(totalMovements)), new Double((double)averageTemp / (double)hourSampleCounter), new Double((double)averageHum / (double)hourSampleCounter), new Double(averagePres / (float)hourSampleCounter)});
                    }
                } else if (AppUI.unitType.equals("SI")) {
                    if (AppUI.boolUseTwoChambers) {
                        listResult.add(new Object[]{Long.toString(hourCount), strDateTime, new Double((double)chamber1Counts / LoadSavedFile.LoadedReconCF1 * 37.0), new Double((double)chamber2Counts / LoadSavedFile.LoadedReconCF2 * 37.0), new Long(TiltSensitivity.main(totalMovements)), new Double((double)averageTemp / (double)hourSampleCounter), new Double((double)averageHum / (double)hourSampleCounter), new Double(averagePres / (float)hourSampleCounter)});
                    } else {
                        listResult.add(new Object[]{Long.toString(hourCount), strDateTime, new Double(((double)chamber1Counts / LoadSavedFile.LoadedReconCF1 * 37.0 + (double)chamber2Counts / LoadSavedFile.LoadedReconCF2 * 37.0) / 2.0), new Long(TiltSensitivity.main(totalMovements)), new Double((double)averageTemp / (double)hourSampleCounter), new Double((double)averageHum / (double)hourSampleCounter), new Double(averagePres / (float)hourSampleCounter)});
                    }
                } else {
                    Logging.main("DataExporter.GetHourlyAverageList(): Something went very wrong! Unit type not defined or invalid!");
                }
                averageCount = 0;
                chamber1Counts = 0;
                chamber2Counts = 0;
                totalMovements = 0;
                averageTemp = 0.0f;
                averageHum = 0.0f;
                averagePres = 0.0f;
            }
            ++averageCount;
        }
        return listResult;
    }
}

