/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFText2HTML
extends PDFTextStripper {
    private static final int INITIAL_PDF_TO_HTML_BYTES = 8192;
    private final FontState fontState = new FontState();

    public PDFText2HTML() throws IOException {
        this.setLineSeparator(this.LINE_SEPARATOR);
        this.setParagraphStart("<p>");
        this.setParagraphEnd("</p>" + this.LINE_SEPARATOR);
        this.setPageStart("<div style=\"page-break-before:always; page-break-after:always\">");
        this.setPageEnd("</div>" + this.LINE_SEPARATOR);
        this.setArticleStart(this.LINE_SEPARATOR);
        this.setArticleEnd(this.LINE_SEPARATOR);
    }

    @Deprecated
    protected void writeHeader() throws IOException {
    }

    @Override
    protected void startDocument(PDDocument document) throws IOException {
        StringBuilder buf = new StringBuilder(8192);
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/html4/loose.dtd\">\n");
        buf.append("<html><head>");
        buf.append("<title>").append(PDFText2HTML.escape(this.getTitle())).append("</title>\n");
        buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=\"UTF-8\">\n");
        buf.append("</head>\n");
        buf.append("<body>\n");
        super.writeString(buf.toString());
    }

    @Override
    public void endDocument(PDDocument document) throws IOException {
        super.writeString("</body></html>");
    }

    protected String getTitle() {
        String titleGuess = this.document.getDocumentInformation().getTitle();
        if (titleGuess != null && titleGuess.length() > 0) {
            return titleGuess;
        }
        Iterator<List<TextPosition>> textIter = this.getCharactersByArticle().iterator();
        float lastFontSize = -1.0f;
        StringBuilder titleText = new StringBuilder();
        while (textIter.hasNext()) {
            for (TextPosition position : textIter.next()) {
                float currentFontSize = position.getFontSize();
                if (currentFontSize != lastFontSize || titleText.length() > 64) {
                    if (titleText.length() > 0) {
                        return titleText.toString();
                    }
                    lastFontSize = currentFontSize;
                }
                if (!(currentFontSize > 13.0f)) continue;
                titleText.append(position.getUnicode());
            }
        }
        return "";
    }

    @Override
    protected void startArticle(boolean isLTR) throws IOException {
        if (isLTR) {
            super.writeString("<div>");
        } else {
            super.writeString("<div dir=\"RTL\">");
        }
    }

    @Override
    protected void endArticle() throws IOException {
        super.endArticle();
        super.writeString("</div>");
    }

    @Override
    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        super.writeString(this.fontState.push(text, textPositions));
    }

    @Override
    protected void writeString(String chars) throws IOException {
        super.writeString(PDFText2HTML.escape(chars));
    }

    @Override
    protected void writeParagraphEnd() throws IOException {
        super.writeString(this.fontState.clear());
        super.writeParagraphEnd();
    }

    private static String escape(String chars) {
        StringBuilder builder = new StringBuilder(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            PDFText2HTML.appendEscaped(builder, chars.charAt(i));
        }
        return builder.toString();
    }

    private static void appendEscaped(StringBuilder builder, char character) {
        if (character < ' ' || character > '~') {
            char charAsInt = character;
            builder.append("&#").append((int)charAsInt).append(";");
        } else {
            switch (character) {
                case '\"': {
                    builder.append("&quot;");
                    break;
                }
                case '&': {
                    builder.append("&amp;");
                    break;
                }
                case '<': {
                    builder.append("&lt;");
                    break;
                }
                case '>': {
                    builder.append("&gt;");
                    break;
                }
                default: {
                    builder.append(String.valueOf(character));
                }
            }
        }
    }

    private static class FontState {
        private final List<String> stateList = new ArrayList<String>();
        private final Set<String> stateSet = new HashSet<String>();

        private FontState() {
        }

        public String push(String text, List<TextPosition> textPositions) {
            StringBuilder buffer = new StringBuilder();
            if (text.length() == textPositions.size()) {
                for (int i = 0; i < text.length(); ++i) {
                    this.push(buffer, text.charAt(i), textPositions.get(i));
                }
            } else if (!text.isEmpty()) {
                if (textPositions.isEmpty()) {
                    return text;
                }
                this.push(buffer, text.charAt(0), textPositions.get(0));
                buffer.append(PDFText2HTML.escape(text.substring(1)));
            }
            return buffer.toString();
        }

        public String clear() {
            StringBuilder buffer = new StringBuilder();
            this.closeUntil(buffer, null);
            this.stateList.clear();
            this.stateSet.clear();
            return buffer.toString();
        }

        protected String push(StringBuilder buffer, char character, TextPosition textPosition) {
            boolean bold = false;
            boolean italics = false;
            PDFontDescriptor descriptor = textPosition.getFont().getFontDescriptor();
            if (descriptor != null) {
                bold = this.isBold(descriptor);
                italics = this.isItalic(descriptor);
            }
            buffer.append(bold ? this.open("b") : this.close("b"));
            buffer.append(italics ? this.open("i") : this.close("i"));
            PDFText2HTML.appendEscaped(buffer, character);
            return buffer.toString();
        }

        private String open(String tag) {
            if (this.stateSet.contains(tag)) {
                return "";
            }
            this.stateList.add(tag);
            this.stateSet.add(tag);
            return this.openTag(tag);
        }

        private String close(String tag) {
            int index;
            if (!this.stateSet.contains(tag)) {
                return "";
            }
            StringBuilder tagsBuilder = new StringBuilder();
            this.stateList.remove(index);
            this.stateSet.remove(tag);
            for (index = this.closeUntil(tagsBuilder, tag); index < this.stateList.size(); ++index) {
                tagsBuilder.append(this.openTag(this.stateList.get(index)));
            }
            return tagsBuilder.toString();
        }

        private int closeUntil(StringBuilder tagsBuilder, String endTag) {
            int i = this.stateList.size();
            while (i-- > 0) {
                String tag = this.stateList.get(i);
                tagsBuilder.append(this.closeTag(tag));
                if (endTag == null || !tag.equals(endTag)) continue;
                return i;
            }
            return -1;
        }

        private String openTag(String tag) {
            return "<" + tag + ">";
        }

        private String closeTag(String tag) {
            return "</" + tag + ">";
        }

        private boolean isBold(PDFontDescriptor descriptor) {
            if (descriptor.isForceBold()) {
                return true;
            }
            return descriptor.getFontName().contains("Bold");
        }

        private boolean isItalic(PDFontDescriptor descriptor) {
            if (descriptor.isItalic()) {
                return true;
            }
            return descriptor.getFontName().contains("Italic");
        }
    }
}

