/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.Config;
import MainMenu.AppUI;
import MainMenu.CreateGraph;
import MainMenu.InitDirs;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;

public class CreatePDF {
    public static String strCompany_Name;
    public static String strCompany_Address1;
    public static String strCompany_Address2;
    public static String strCompany_Address3;
    public static String strInstrumentType;
    public static String strCustomReportText;
    private static PDImageXObject imageSignature;
    private static PDImageXObject imageCompanyLogo;
    private static LinkedList<PDImageXObject> imageReportImages;
    float PDF_Y = 0.0f;
    SimpleDateFormat dateArrayCounter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static String validDate;
    static String validDateTimeForPDF;
    Date currentDate = new Date();
    Date arrayDate = new Date();
    public static boolean boolFoundSignature;
    public static boolean boolFoundSignatureBMP;
    public static boolean boolFoundSignaturePNG;
    public static boolean boolFoundSignatureJPG;
    public static boolean boolFoundSignatureJPEG;
    public static boolean boolFoundLogo;
    public static boolean boolFoundLogoBMP;
    public static boolean boolFoundLogoPNG;
    public static boolean boolFoundLogoJPG;
    public static boolean boolFoundLogoJPEG;
    static int marginTop;
    static int marginBottom;
    static int marginSide;
    static int intBannerFontSize;
    static int intFooterFontSize;
    static int intHeadingFontSize;
    static int intPrimaryFontSize;
    private int numImages = 0;
    private int numImagePages = 0;
    private File reportImagesDir;
    private File[] reportImageFiles;
    private LinkedList<PDPage> imagePages = null;
    private boolean drawingUserImages = false;
    private boolean isMainMenuUI = MainMenuUI.appUI instanceof MainMenuUI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main() throws IOException, ParseException {
        File fileCompanyLogoPNG;
        File fileCompanyLogoJPEG;
        File fileCompanyLogoJPG;
        File fileSignatureAnalystPNG;
        File fileSignatureAnalystJPEG;
        File fileSignatureAnalystJPG;
        strInstrumentType = LoadSavedFile.dataType == LoadSavedFile.DataType.RECON ? "Recon CRM" : (LoadSavedFile.dataType == LoadSavedFile.DataType.ANYTM ? "Tamper Mon" : "Unknown");
        marginTop = AppUI.intPDFMarginTop;
        marginBottom = AppUI.intPDFMarginBottom;
        marginSide = AppUI.intPDFMarginSide;
        intBannerFontSize = AppUI.intPDFBannerFontSize;
        intFooterFontSize = AppUI.intPDFFooterFontSize;
        intHeadingFontSize = AppUI.intPDFHeadingFontSize;
        intPrimaryFontSize = AppUI.intPDFPrimaryFontSize;
        int extensionIndex = AppUI.lblLoadedFileName.getText().lastIndexOf(".");
        String PDF_Name = AppUI.lblLoadedFileName.getText();
        PDF_Name = PDF_Name.substring(0, extensionIndex) + ".pdf";
        PDDocument doc = new PDDocument();
        File fileSignatureAnalystBMP = new File(InitDirs.configDir + File.separator + "signature.bmp");
        if (fileSignatureAnalystBMP.exists()) {
            boolFoundSignatureBMP = true;
            Logging.main("Analyst signature found as BMP!");
        }
        if ((fileSignatureAnalystJPG = new File(InitDirs.configDir + File.separator + "signature.jpg")).exists()) {
            boolFoundSignatureJPG = true;
            Logging.main("Analyst signature found as JPG!");
        }
        if ((fileSignatureAnalystJPEG = new File(InitDirs.configDir + File.separator + "signature.jpeg")).exists()) {
            boolFoundSignatureJPEG = true;
            Logging.main("Analyst signature found as JPEG!");
        }
        if ((fileSignatureAnalystPNG = new File(InitDirs.configDir + File.separator + "signature.png")).exists()) {
            boolFoundSignaturePNG = true;
            Logging.main("Analyst signature found as PNG!");
        }
        if (boolFoundSignatureBMP || boolFoundSignaturePNG || boolFoundSignatureJPG || boolFoundSignatureJPEG) {
            boolFoundSignature = true;
        } else {
            Logging.main("No digital signature (as BMP/PNG/JPG/JPEG) found for PDF... ignoring.");
        }
        File fileCompanyLogoBMP = new File(InitDirs.configDir + File.separator + "logo.bmp");
        if (fileCompanyLogoBMP.exists()) {
            boolFoundLogoBMP = true;
            Logging.main("Company Logo found as BMP!");
        }
        if ((fileCompanyLogoJPG = new File(InitDirs.configDir + File.separator + "logo.jpg")).exists()) {
            boolFoundLogoJPG = true;
            Logging.main("Company Logo found as JPG!");
        }
        if ((fileCompanyLogoJPEG = new File(InitDirs.configDir + File.separator + "logo.jpeg")).exists()) {
            boolFoundLogoJPEG = true;
            Logging.main("Company Logo found as JPEG!");
        }
        if ((fileCompanyLogoPNG = new File(InitDirs.configDir + File.separator + "logo.png")).exists()) {
            boolFoundLogoPNG = true;
            Logging.main("Company Logo found as PNG!");
        }
        if (boolFoundLogoBMP || boolFoundLogoPNG || boolFoundLogoJPG || boolFoundLogoJPEG) {
            boolFoundLogo = true;
        } else {
            Logging.main("No company logo (as BMP/PNG/JPG/JPEG) found for PDF... ignoring.");
        }
        try {
            int arrayCounter;
            PDPage page = new PDPage(AppUI.pageSizePDF);
            Logging.main("Setting page size to..." + AppUI.pageSizePDF);
            doc.addPage(page);
            File fontCalibri = new File(InitDirs.fontsDir + File.separator + "calibri.ttf");
            if (fontCalibri.exists()) {
                Logging.main("Calibri font found!");
            } else {
                Logging.main("ERROR: Calibri font NOT found... switching to embedded Helvetica.");
                Logging.main("ERROR: Calibri font attempted path = " + fontCalibri);
            }
            File fontCalibriBold = new File(InitDirs.fontsDir + File.separator + "calibri_bold.ttf");
            if (fontCalibri.exists()) {
                Logging.main("Calibri Bold font found!");
            } else {
                Logging.main("ERROR: Calibri Bold font NOT found... switching to embedded Helvetica.");
                Logging.main("ERROR: Calibri Bold font attempted path = " + fontCalibriBold);
            }
            PDType1Font fontDefault = fontCalibri.exists() ? PDType0Font.load((PDDocument)doc, (File)new File(InitDirs.fontsDir + File.separator + "calibri.ttf")) : PDType1Font.HELVETICA;
            PDType1Font fontBold = fontCalibri.exists() ? PDType0Font.load((PDDocument)doc, (File)new File(InitDirs.fontsDir + File.separator + "calibri_bold.ttf")) : PDType1Font.HELVETICA_BOLD;
            PDPageContentStream contents = new PDPageContentStream(doc, page);
            Logging.main("Beginning PDF creation...");
            CreatePDF.setPageBackgroundFill(page, contents);
            contents.setFont((PDFont)fontDefault, (float)intHeadingFontSize);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
            contents.setLeading(14.5f);
            float textHeight = fontDefault.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)intHeadingFontSize;
            this.PDF_Y = page.getMediaBox().getHeight() - (float)marginTop - textHeight;
            CreatePDF.GetCompanyInfo();
            if (AppUI.displayLogo) {
                this.drawCompanyLogo(doc, contents, page);
            } else {
                this.DrawCompanyHeader(contents, page, (PDFont)fontDefault, marginTop);
            }
            this.DrawTitleHeader(contents, page, "Radon Test Report", (PDFont)fontBold, (PDFont)fontDefault);
            this.DrawCustomerTestSiteBlock(contents, page, (PDFont)fontBold, (PDFont)fontDefault);
            this.drawTestSummaryBlock(contents, page, (PDFont)fontDefault, (PDFont)fontBold);
            this.DrawAverageRadonBanner(contents, page, (PDFont)fontBold, true);
            String textLine = "Cal. Date: " + LoadSavedFile.strCalDate + "   Cal. Due: ";
            String strDateCalibrationDue = "Unknown";
            if (CreatePDF.isValidDate(LoadSavedFile.strCalDate)) {
                try {
                    Date calDate = AppUI.dateFormatCalibration.parse(LoadSavedFile.strCalDate);
                    String strCalDateFormatted = AppUI.dateFormat.format(calDate);
                    textLine = "Cal. Date: " + strCalDateFormatted + "   Cal. Due: ";
                    Calendar dateInstance = Calendar.getInstance();
                    dateInstance.setTime(AppUI.dateFormatCalibration.parse(LoadSavedFile.strCalDate));
                    dateInstance.add(1, 1);
                    strDateCalibrationDue = AppUI.dateFormat.format(dateInstance.getTime());
                }
                catch (ParseException ex) {
                    Logging.main("Unable to parse calibration date... this shouldn't have happened!");
                    strDateCalibrationDue = "Unknown";
                }
            } else {
                strDateCalibrationDue = "Unknown";
            }
            textLine = textLine + strDateCalibrationDue;
            float textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            contents.beginText();
            contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
            float PDF_Y_temp = this.PDF_Y;
            contents.newLineAtOffset(page.getMediaBox().getWidth() - (float)marginSide - textWidth, PDF_Y_temp -= 1.5f * (float)intPrimaryFontSize);
            contents.showText(textLine);
            contents.endText();
            Logging.main("CreatePDF:: Calibration dates successfully printed!");
            contents.beginText();
            textLine = "Analyzed By: ";
            contents.setFont((PDFont)fontBold, (float)intPrimaryFontSize);
            textWidth = fontBold.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Deployed By: ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Retrieved By: ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
            this.PDF_Y -= 1.5f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainAnalyzedBy.getText() : LoadSavedFile.strAnalyzedBy;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainDeployedBy.getText() : LoadSavedFile.strDeployedBy;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainRetrievedBy.getText() : LoadSavedFile.strRetrievedBy;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            Logging.main("CreatePDF:: Analyzed / Deployed / Retrieved By successfully printed!");
            this.PDF_Y -= 1.0f * (float)intPrimaryFontSize;
            contents.beginText();
            contents.setFont((PDFont)fontBold, (float)intPrimaryFontSize);
            PDF_Y_temp = this.PDF_Y;
            textLine = "Protocol:  ";
            textWidth = fontBold.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp -= 1.5f * (float)intPrimaryFontSize);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Tampering:  ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Weather:  ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Mitigation:  ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            PDF_Y_temp -= 1.1f * (float)intPrimaryFontSize;
            textLine = "Comment:  ";
            if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            }
            contents.newLineAtOffset((float)marginSide, PDF_Y_temp);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
            this.PDF_Y -= 1.5f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainProtocol.getText() : LoadSavedFile.strReportProtocol;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainTampering.getText() : LoadSavedFile.strReportTampering;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainWeather.getText() : LoadSavedFile.strReportWeather;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainMitigation.getText() : LoadSavedFile.strReportMitigation;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
            textLine = this.isMainMenuUI ? MainMenuUI.txtMainComment.getText() : LoadSavedFile.strReportComment;
            contents.newLineAtOffset((float)marginSide + textWidth, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            Logging.main("CreatePDF:: Protocol, Tampering, Weather, Comments, etc. successfully printed!");
            this.PDF_Y -= 1.0f * (float)intPrimaryFontSize;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            this.PDF_Y -= 3.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            contents.beginText();
            contents.setFont((PDFont)fontBold, (float)intHeadingFontSize);
            this.PDF_Y -= 1.0f * (float)intHeadingFontSize;
            textLine = "Radon Health Risk Information";
            contents.newLineAtOffset((float)marginSide, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            Config customReport = new Config();
            textLine = strCustomReportText = customReport.getCustomReportText();
            contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
            this.PDF_Y -= 2.0f * (float)intPrimaryFontSize;
            this.WrapMultiLineText(contents, page, marginSide, this.PDF_Y, textLine, (PDFont)fontDefault, intPrimaryFontSize, marginSide);
            Logging.main("CreatePDF:: Signature Option = " + String.valueOf(AppUI.displaySig));
            if (AppUI.displaySig == 1) {
                this.drawSignatureLine(contents, page, (PDFont)fontDefault);
            } else if (AppUI.displaySig == 2) {
                this.drawSignatureLine(contents, page, (PDFont)fontDefault);
                this.drawDigitalSignature(doc, contents, page, (PDFont)fontDefault);
            }
            contents.close();
            PDPage page_chart = new PDPage(AppUI.pageSizePDF);
            doc.addPage(page_chart);
            contents = new PDPageContentStream(doc, page_chart);
            CreatePDF.setPageBackgroundFill(page_chart, contents);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
            this.PDF_Y = page_chart.getMediaBox().getHeight() - (float)marginTop - textHeight;
            if (AppUI.displayLogo) {
                this.drawCompanyLogo(doc, contents, page_chart);
            } else {
                this.DrawCompanyHeader(contents, page_chart, (PDFont)fontDefault, marginTop);
            }
            this.DrawTitleHeader(contents, page_chart, "Graphical Radon Report", (PDFont)fontBold, (PDFont)fontDefault);
            this.DrawCustomerTestSiteBlock(contents, page_chart, (PDFont)fontBold, (PDFont)fontDefault);
            this.drawTestSummaryBlock(contents, page, (PDFont)fontDefault, (PDFont)fontBold);
            this.DrawAverageRadonBanner(contents, page_chart, (PDFont)fontBold, true);
            File graphPNGFile = new File(InitDirs.baseDir + File.separator + "graph.png");
            PDImageXObject graphPNG = PDImageXObject.createFromFile((String)graphPNGFile.getAbsolutePath(), (PDDocument)doc);
            this.PDF_Y -= page_chart.getMediaBox().getHeight() - this.PDF_Y;
            contents.drawImage(graphPNG, (float)(marginSide * 2), this.PDF_Y);
            contents.close();
            PDPage page_detailed = new PDPage(AppUI.pageSizePDF);
            doc.addPage(page_detailed);
            contents = new PDPageContentStream(doc, page_detailed);
            CreatePDF.setPageBackgroundFill(page_detailed, contents);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
            this.PDF_Y = page_detailed.getMediaBox().getHeight() - (float)marginTop - textHeight;
            if (AppUI.displayLogo) {
                this.drawCompanyLogo(doc, contents, page_detailed);
            } else {
                this.DrawCompanyHeader(contents, page_detailed, (PDFont)fontDefault, marginTop);
            }
            this.DrawTitleHeader(contents, page_detailed, "Hourly Radon Report", (PDFont)fontBold, (PDFont)fontDefault);
            this.DrawCustomerTestSiteBlock(contents, page_detailed, (PDFont)fontBold, (PDFont)fontDefault);
            this.drawTestSummaryBlock(contents, page, (PDFont)fontDefault, (PDFont)fontBold);
            this.DrawAverageRadonBanner(contents, page_detailed, (PDFont)fontBold, true);
            this.DrawDetailedColumnHeaders(contents, (PDFont)fontBold);
            if (!AppUI.boolUseTwoChambers) {
                for (arrayCounter = 0; arrayCounter < CreateGraph.HourlyReconData.size(); ++arrayCounter) {
                    this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
                    contents.beginText();
                    contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
                    contents.newLineAtOffset((float)marginSide, this.PDF_Y);
                    if (AppUI.excludeFirst4Hours && arrayCounter < 4) {
                        contents.setNonStrokingColor(Color.decode(AppUI.strPDFHourlyExcludedFontColor));
                    } else {
                        contents.setNonStrokingColor(Color.decode(AppUI.strPDFHourlyDetailedFontColor));
                    }
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(0);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(45.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(1);
                    textLine = textLine.replace("T", " ");
                    if (CreatePDF.isValidDateTimeForPDF(textLine)) {
                        this.arrayDate = this.dateArrayCounter.parse(textLine);
                        textLine = AppUI.dateTimeFormat.format(this.arrayDate);
                    } else {
                        System.out.println("WARNING! Invalid date detected in CreatePDF::main() [" + textLine + "]");
                    }
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(115.0f, 0.0f);
                    textLine = AppUI.photodiodeFailureRecovery && CreateGraph.photodiodeFailure_Ch1 && !CreateGraph.photodiodeFailure_Ch2 ? CreateGraph.HourlyReconData.get(arrayCounter).get(10) : (AppUI.photodiodeFailureRecovery && CreateGraph.photodiodeFailure_Ch2 && !CreateGraph.photodiodeFailure_Ch1 ? CreateGraph.HourlyReconData.get(arrayCounter).get(9) : CreateGraph.HourlyReconData.get(arrayCounter).get(2));
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(90.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(3);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(100.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(4);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(95.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(5);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(70.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(6);
                    contents.showText(textLine);
                    contents.endText();
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    if (!(this.PDF_Y - 1.0f * (float)intPrimaryFontSize <= (float)marginBottom) || arrayCounter >= CreateGraph.HourlyReconData.size() - 1) continue;
                    contents.close();
                    page_detailed = new PDPage(AppUI.pageSizePDF);
                    doc.addPage(page_detailed);
                    contents = new PDPageContentStream(doc, page_detailed);
                    CreatePDF.setPageBackgroundFill(page_detailed, contents);
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
                    this.PDF_Y = page_detailed.getMediaBox().getHeight() - (float)marginTop - textHeight;
                    if (AppUI.displayLogo) {
                        this.drawCompanyLogo(doc, contents, page_detailed);
                    } else {
                        this.DrawCompanyHeader(contents, page_detailed, (PDFont)fontDefault, marginTop);
                    }
                    this.DrawTitleHeader(contents, page_detailed, "Hourly Radon Report", (PDFont)fontBold, (PDFont)fontDefault);
                    this.DrawCustomerTestSiteBlock(contents, page_detailed, (PDFont)fontBold, (PDFont)fontDefault);
                    this.drawTestSummaryBlock(contents, page, (PDFont)fontDefault, (PDFont)fontBold);
                    this.DrawAverageRadonBanner(contents, page_detailed, (PDFont)fontBold, true);
                    this.PDF_Y -= 15.0f;
                    this.DrawDetailedColumnHeaders(contents, (PDFont)fontBold);
                }
            } else {
                for (arrayCounter = 0; arrayCounter < CreateGraph.HourlyReconData.size(); ++arrayCounter) {
                    this.PDF_Y -= 1.1f * (float)intPrimaryFontSize;
                    contents.beginText();
                    contents.setFont((PDFont)fontDefault, (float)intPrimaryFontSize);
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
                    contents.newLineAtOffset((float)marginSide, this.PDF_Y);
                    if (AppUI.excludeFirst4Hours && arrayCounter < 4) {
                        contents.setNonStrokingColor(Color.gray);
                    } else {
                        contents.setNonStrokingColor(Color.black);
                    }
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(0);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(25.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(1);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(100.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(7);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(35.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(8);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(50.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(2);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(68.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(3);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(75.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(4);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(95.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(5);
                    contents.showText(textLine);
                    contents.moveTextPositionByAmount(62.0f, 0.0f);
                    textLine = CreateGraph.HourlyReconData.get(arrayCounter).get(6);
                    contents.showText(textLine);
                    contents.endText();
                    if (!(this.PDF_Y - 1.0f * (float)intPrimaryFontSize <= (float)marginBottom) || arrayCounter >= CreateGraph.HourlyReconData.size() - 1) continue;
                    contents.close();
                    page_detailed = new PDPage(AppUI.pageSizePDF);
                    doc.addPage(page_detailed);
                    contents = new PDPageContentStream(doc, page_detailed);
                    CreatePDF.setPageBackgroundFill(page_detailed, contents);
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
                    this.PDF_Y = page_detailed.getMediaBox().getHeight() - (float)marginTop - textHeight;
                    if (AppUI.displayLogo) {
                        this.drawCompanyLogo(doc, contents, page_detailed);
                    } else {
                        this.DrawCompanyHeader(contents, page_detailed, (PDFont)fontDefault, marginTop);
                    }
                    this.DrawTitleHeader(contents, page_detailed, "Radon Detailed Report", (PDFont)fontBold, (PDFont)fontDefault);
                    this.DrawCustomerTestSiteBlock(contents, page_detailed, (PDFont)fontBold, (PDFont)fontDefault);
                    this.drawTestSummaryBlock(contents, page, (PDFont)fontDefault, (PDFont)fontBold);
                    this.DrawAverageRadonBanner(contents, page_detailed, (PDFont)fontBold, true);
                    this.PDF_Y -= 15.0f;
                    this.DrawDetailedColumnHeaders(contents, (PDFont)fontBold);
                }
            }
            contents.close();
            this.LoadUserImages(doc);
            if (this.drawingUserImages) {
                int i;
                if (this.numImagePages > 0) {
                    this.imagePages = new LinkedList();
                    for (i = 0; i < this.numImagePages; ++i) {
                        PDPage page_images = new PDPage(AppUI.pageSizePDF);
                        this.imagePages.push(page_images);
                    }
                }
                for (i = 0; i < this.imagePages.size(); ++i) {
                    doc.addPage(this.imagePages.get(i));
                    contents = new PDPageContentStream(doc, this.imagePages.get(i));
                    CreatePDF.setPageBackgroundFill(this.imagePages.get(i), contents);
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
                    this.DrawReportImages(doc, contents, this.imagePages.get(i), (PDFont)fontBold, (PDFont)fontDefault, textHeight);
                    contents.close();
                }
            }
            this.drawFooterInfo(doc);
            Logging.main("End PDF generation stage. Writing to file...");
            if (InitDirs.reportsDir.exists() && InitDirs.reportsDir.isDirectory()) {
                doc.save(InitDirs.reportsDir + File.separator + PDF_Name);
            } else {
                Logging.main("Reports directory does not exist.  Creating...");
                InitDirs.reportsDir.mkdirs();
                doc.save(InitDirs.reportsDir + File.separator + PDF_Name);
            }
            File ReconPDF = new File(InitDirs.reportsDir + File.separator + PDF_Name);
            if (ReconPDF.exists()) {
                Logging.main(PDF_Name + " has been created.");
                AppUI.lblSystemConsole.setText("PDF has been created.");
            } else {
                Logging.main("Problem creating PDF.");
                AppUI.lblSystemConsole.setText("Problem creating PDF.");
            }
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
        finally {
            doc.close();
        }
    }

    private void WrapMultiLineText(PDPageContentStream contents, PDPage page, float startX, float startY, String textLine, PDFont fontUsed, int fontSize, int marginSide) {
        Logging.main("CreatePDF::WrapMultiLineText() called!");
        ArrayList<String> lines = new ArrayList<String>();
        int lastSpace = -1;
        try {
            while (textLine.length() > 0) {
                String subString;
                float textWidth;
                int spaceIndex = textLine.indexOf(32, lastSpace + 1);
                if (spaceIndex < 0) {
                    spaceIndex = textLine.length();
                }
                if ((textWidth = (float)fontSize * fontUsed.getStringWidth(subString = textLine.substring(0, spaceIndex)) / 1000.0f) > page.getMediaBox().getWidth() - (float)(2 * marginSide)) {
                    if (lastSpace < 0) {
                        lastSpace = spaceIndex;
                    }
                    subString = textLine.substring(0, lastSpace);
                    lines.add(subString);
                    textLine = textLine.substring(lastSpace).trim();
                    lastSpace = -1;
                    Logging.main("MultiLine Wrap = " + subString);
                    continue;
                }
                if (spaceIndex == textLine.length()) {
                    lines.add(textLine);
                    textLine = "";
                    continue;
                }
                lastSpace = spaceIndex;
            }
            contents.beginText();
            contents.newLineAtOffset(startX, startY);
            for (String line : lines) {
                contents.showText(line);
                contents.newLineAtOffset(0.0f, -1.1f * (float)fontSize);
                this.PDF_Y -= 1.1f * (float)fontSize;
            }
            contents.endText();
        }
        catch (Exception ex) {
            Logging.main("ERROR: Unhandled exception in CreatePDF::WrapMultiLineText()!");
            Logging.main("CreatePDF::WrapMultiLineText() textLine = " + textLine);
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    public static void GetCompanyInfo() {
        Logging.main("Called CreatePDF::GetCompanyInfo() for PDF generation...");
        strCompany_Name = AppUI.strCompanyName;
        strCompany_Address1 = AppUI.strAddress1;
        strCompany_Address2 = AppUI.strAddress2;
        strCompany_Address3 = AppUI.strAddress3;
        Logging.main("CreatePDF::GetCompanyInfo(): Successfully parsed company information for PDF!");
    }

    public void DrawCompanyHeader(PDPageContentStream contents, PDPage page, PDFont fontDefault, int marginTop) {
        Logging.main("CreatePDF::DrawCompanyHeader has been called...");
        int fontSize = 14;
        float textHeight = fontDefault.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)fontSize;
        try {
            contents.beginText();
            contents.setFont(fontDefault, (float)fontSize);
            contents.setLeading(14.5f);
            String textLine = strCompany_Name;
            contents.newLineAtOffset(20.0f, this.PDF_Y);
            contents.showText(textLine);
            textLine = strCompany_Address1;
            this.PDF_Y -= 1.0f * (float)fontSize;
            contents.newLineAtOffset(0.0f, -1.0f * (float)fontSize);
            contents.showText(textLine);
            textLine = strCompany_Address2;
            this.PDF_Y -= 1.0f * (float)fontSize;
            contents.newLineAtOffset(0.0f, -1.0f * (float)fontSize);
            contents.showText(textLine);
            textLine = strCompany_Address3;
            this.PDF_Y -= 1.0f * (float)fontSize;
            contents.newLineAtOffset(0.0f, -1.0f * (float)fontSize);
            contents.showText(textLine);
            contents.endText();
            Logging.main("Successful CreatePDF::DrawCompanyHeader()!");
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
            Logging.main("ERROR: Unhandled error in CreatePDF::DrawCompanyHeader()!");
        }
    }

    public void DrawTitleHeader(PDPageContentStream contents, PDPage page, String strTitle, PDFont fontTitle, PDFont fontDate) {
        try {
            contents.beginText();
            int fontSize = 18;
            contents.setFont(fontTitle, (float)fontSize);
            contents.setLeading(14.5f);
            String textLine = strTitle;
            float textWidth = fontTitle.getStringWidth(textLine) / 1000.0f * (float)fontSize;
            float textHeight = fontTitle.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)fontSize;
            this.PDF_Y = AppUI.displayLogo && boolFoundLogo ? (this.PDF_Y -= 20.0f) : (this.PDF_Y -= 50.0f);
            contents.moveTextPositionByAmount((page.getMediaBox().getWidth() - textWidth) / 2.0f, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            contents.beginText();
            fontSize = 12;
            textLine = AppUI.dateFormat.format(this.currentDate);
            textWidth = fontDate.getStringWidth(textLine) / 1000.0f * (float)fontSize;
            textHeight = fontDate.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)fontSize;
            this.PDF_Y -= 5.0f;
            contents.moveTextPositionByAmount((page.getMediaBox().getWidth() - textWidth) / 2.0f, this.PDF_Y);
            contents.newLine();
            contents.setFont(fontDate, (float)fontSize);
            contents.showText(textLine);
            contents.endText();
            Logging.main("Successful CreatePDF::DrawTitleHeader()!");
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    public void DrawCustomerTestSiteBlock(PDPageContentStream contents, PDPage page, PDFont fontBold, PDFont fontDefault) {
        try {
            this.PDF_Y -= 35.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            this.PDF_Y -= 3.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            contents.beginText();
            String textLine = "Customer Information:";
            contents.setFont(fontBold, (float)intPrimaryFontSize);
            float textWidth = fontBold.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            float textHeight = fontBold.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)intPrimaryFontSize;
            this.PDF_Y -= 17.0f;
            contents.moveTextPositionByAmount((float)(marginSide + 5), this.PDF_Y);
            contents.showText(textLine);
            contents.newLine();
            contents.setFont(fontDefault, (float)intPrimaryFontSize);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            String[] CustomerInfo_parsed = AppUI.txtCustomerInfo.getText().split("\\n");
            for (int i = 0; i < CustomerInfo_parsed.length; ++i) {
                textLine = CustomerInfo_parsed[i].replaceAll("\\t", " ").trim();
                if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                    textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                }
                contents.showText(textLine);
                contents.newLine();
            }
            contents.newLine();
            contents.endText();
            contents.beginText();
            textLine = "Test Site:";
            contents.setFont(fontBold, (float)intPrimaryFontSize);
            contents.moveTextPositionByAmount((page.getMediaBox().getWidth() - (float)marginSide) / 2.0f + 30.0f, this.PDF_Y);
            contents.showText(textLine);
            contents.newLine();
            contents.setFont(fontDefault, (float)intPrimaryFontSize);
            String[] TestSiteInfo_parsed = AppUI.txtTestSiteInfo.getText().split("\\n");
            for (int i = 0; i < TestSiteInfo_parsed.length; ++i) {
                textLine = TestSiteInfo_parsed[i].replaceAll("\\t", " ").trim();
                if (fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize > textWidth) {
                    textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                }
                contents.showText(textLine);
                contents.newLine();
            }
            this.PDF_Y += 1.0f * (float)intPrimaryFontSize;
            contents.endText();
            int LongestTextBlock = 1;
            LongestTextBlock = CustomerInfo_parsed.length > TestSiteInfo_parsed.length ? CustomerInfo_parsed.length : TestSiteInfo_parsed.length;
            this.PDF_Y -= textHeight * (float)(LongestTextBlock + 2);
            contents.addRect((float)marginSide, this.PDF_Y, (page.getMediaBox().getWidth() - (float)marginSide) / 2.0f - 25.0f, textHeight * (float)(LongestTextBlock + 2));
            contents.stroke();
            contents.addRect((page.getMediaBox().getWidth() - (float)marginSide) / 2.0f + 25.0f, this.PDF_Y, (page.getMediaBox().getWidth() - (float)marginSide) / 2.0f - 25.0f, textHeight * (float)(LongestTextBlock + 2));
            contents.stroke();
            this.PDF_Y -= 3.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            this.PDF_Y -= 3.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    private void DrawAverageRadonBanner(PDPageContentStream contents, PDPage page, PDFont font, boolean drawTopDoubleLines) {
        try {
            Logging.main("CreatePDF::DrawAverageRadonBanner called for page !");
            String strOverallAvgRnC = LoadSavedFile.strUnitSystem.equals("SI") ? new DecimalFormat("0").format(CreateGraph.OverallAvgRnC) : new DecimalFormat("0.0").format(CreateGraph.OverallAvgRnC);
            if (drawTopDoubleLines) {
                this.PDF_Y -= 0.5f * (float)intPrimaryFontSize;
                contents.moveTo((float)marginSide, this.PDF_Y);
                contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
                contents.stroke();
                this.PDF_Y -= 3.0f;
                contents.moveTo((float)marginSide, this.PDF_Y);
                contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
                contents.stroke();
            }
            contents.beginText();
            contents.setFont(font, (float)intBannerFontSize);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFBannerFontColor));
            this.PDF_Y -= 1.0f * (float)intBannerFontSize;
            String textLine = "Average Radon Concentration in:          " + AppUI.txtLocation.getText() + "          " + strOverallAvgRnC;
            textLine = LoadSavedFile.strUnitSystem.equals("SI") ? textLine + " Bq/m\u00b3" : textLine + " pCi/L";
            contents.newLineAtOffset((float)marginSide, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            if (AppUI.highlightAverage) {
                Logging.main("CreatePDF::DrawAverageRadonBanner, Attempting to highight average radon concentration banner...");
                PDAnnotationTextMarkup highlight = new PDAnnotationTextMarkup("Highlight");
                highlight.setRectangle(PDRectangle.A4);
                float[] quadPoints = new float[]{marginSide, this.PDF_Y + 15.0f, page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y + 15.0f, marginSide, this.PDF_Y - 5.0f, page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y - 5.0f};
                highlight.setQuadPoints(quadPoints);
                int c = Integer.parseInt(AppUI.strPDFHighlightColor.substring(1), 16);
                float r = (float)((c & 0xFF0000) >> 16) / 255.0f;
                float g = (float)((c & 0xFF00) >> 8) / 255.0f;
                float b = (float)((c & 0xFF) >> 0) / 255.0f;
                PDColor color_highlight = new PDColor(new float[]{r, g, b}, (PDColorSpace)PDDeviceRGB.INSTANCE);
                highlight.setColor(color_highlight);
                List annotations = page.getAnnotations();
                annotations.add(highlight);
                Logging.main("CreatePDF::DrawAverageRadonBanner, Highlighting complete!");
            }
            this.PDF_Y -= 0.5f * (float)intBannerFontSize;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            this.PDF_Y -= 3.0f;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            Logging.main("Successful CreatePDF::DrawAverageRadonBanner()!");
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    private void DrawDetailedColumnHeaders(PDPageContentStream contents, PDFont font) {
        try {
            String strRadonUnits;
            String strPressUnits;
            String strTempUnits;
            if (LoadSavedFile.strUnitSystem.equals("SI")) {
                strTempUnits = " (\u00b0C)";
                strPressUnits = " (mbar)";
                strRadonUnits = " (Bq/m\u00b3)";
            } else {
                strTempUnits = " (\u00b0F)";
                strPressUnits = " (inHg)";
                strRadonUnits = " (pCi/L)";
            }
            this.PDF_Y -= 15.0f;
            contents.beginText();
            contents.setFont(font, (float)intPrimaryFontSize);
            contents.newLineAtOffset((float)marginSide, this.PDF_Y);
            if (AppUI.boolUseTwoChambers) {
                String textLine = "Record#";
                contents.showText(textLine);
                float textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Date/Time";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Ch1";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Ch2";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Avg" + strRadonUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Temp." + strTempUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Pressure" + strPressUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Humidity (%)";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
                textLine = "Tilts";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(15.0f + textWidth, 0.0f);
            } else {
                String textLine = "Record#";
                contents.showText(textLine);
                float textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Date/Time";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Radon" + strRadonUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Temperature" + strTempUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Pressure" + strPressUnits;
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Humidity (%)";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
                textLine = "Tilts";
                contents.showText(textLine);
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                contents.moveTextPositionByAmount(20.0f + textWidth, 0.0f);
            }
            contents.endText();
        }
        catch (IOException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    public void drawTestSummaryBlock(PDPageContentStream contents, PDPage page, PDFont fontDefault, PDFont fontBold) {
        try {
            Date startEndTime = AppUI.dateFormatStartEndTime.parse(LoadSavedFile.strStartDate);
            String strStartTimeFormatted = AppUI.dateTimeFormat.format(startEndTime);
            startEndTime = AppUI.dateFormatStartEndTime.parse(LoadSavedFile.strEndDate);
            String strEndTimeFormatted = AppUI.dateTimeFormat.format(startEndTime);
            String textLine = "A Rad Elec Recon\u00ae CRM (NRPP Device Code #8304 / NRSB Device Code #31823) was used for radon screening measurements that were conducted at the above referenced test site by: " + strCompany_Name;
            this.PDF_Y -= 20.0f;
            this.WrapMultiLineText(contents, page, marginSide, this.PDF_Y, textLine, fontDefault, intPrimaryFontSize, marginSide);
            contents.beginText();
            contents.setFont(fontBold, (float)intHeadingFontSize);
            this.PDF_Y -= 0.5f * (float)intHeadingFontSize;
            textLine = "The results are as follows:";
            contents.newLineAtOffset((float)marginSide, this.PDF_Y);
            contents.showText(textLine);
            contents.endText();
            this.PDF_Y -= 1.0f * (float)intHeadingFontSize;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            contents.beginText();
            contents.setFont(fontBold, (float)intPrimaryFontSize);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
            this.PDF_Y -= 1.0f * (float)intPrimaryFontSize;
            String[] strColumnHeaders = new String[]{"Serial#", "Instrument", "Location", "Start Date/Time", "End Date/Time", "Results "};
            strColumnHeaders[5] = LoadSavedFile.strUnitSystem.equals("SI") ? strColumnHeaders[5] + "(Bq/m\u00b3)" : strColumnHeaders[5] + "(pCi/L)";
            contents.newLineAtOffset((page.getMediaBox().getWidth() - (float)(marginSide * 2)) / -6.0f + (float)marginSide, this.PDF_Y);
            for (int i = 0; i < strColumnHeaders.length; ++i) {
                contents.moveTextPositionByAmount((page.getMediaBox().getWidth() - (float)(marginSide * 2)) / 6.0f, 0.0f);
                switch (i) {
                    case 1: {
                        contents.moveTextPositionByAmount(-40.0f, 0.0f);
                    }
                    case 4: {
                        contents.moveTextPositionByAmount(15.0f, 0.0f);
                    }
                    case 5: {
                        contents.moveTextPositionByAmount(10.0f, 0.0f);
                    }
                }
                contents.showText(strColumnHeaders[i]);
            }
            contents.endText();
            this.PDF_Y -= 0.5f * (float)intPrimaryFontSize;
            contents.moveTo((float)marginSide, this.PDF_Y);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, this.PDF_Y);
            contents.stroke();
            String strOverallAvgRnC = LoadSavedFile.strUnitSystem.equals("SI") ? new DecimalFormat("0").format(CreateGraph.OverallAvgRnC) : new DecimalFormat("0.0").format(CreateGraph.OverallAvgRnC);
            contents.setFont(fontDefault, (float)intPrimaryFontSize);
            this.PDF_Y -= 1.0f * (float)intPrimaryFontSize;
            contents.beginText();
            contents.newLineAtOffset((page.getMediaBox().getWidth() - (float)(marginSide * 2)) / -6.0f + (float)marginSide, this.PDF_Y);
            String[] stringArray = new String[6];
            stringArray[0] = LoadSavedFile.strInstrumentSerial;
            stringArray[1] = strInstrumentType;
            stringArray[2] = AppUI.txtLocation.getText();
            stringArray[3] = strStartTimeFormatted;
            stringArray[4] = strEndTimeFormatted;
            stringArray[5] = strOverallAvgRnC;
            String[] combinedDataArray = stringArray;
            for (int i = 0; i < combinedDataArray.length; ++i) {
                contents.moveTextPositionByAmount((page.getMediaBox().getWidth() - (float)(marginSide * 2)) / 6.0f, 0.0f);
                switch (i) {
                    case 1: {
                        contents.moveTextPositionByAmount(-40.0f, 0.0f);
                    }
                    case 4: {
                        contents.moveTextPositionByAmount(15.0f, 0.0f);
                    }
                    case 5: {
                        contents.moveTextPositionByAmount(10.0f, 0.0f);
                    }
                }
                if (i == combinedDataArray.length - 1) {
                    contents.moveTextPositionByAmount((float)(30 - strOverallAvgRnC.length() / 2), 0.0f);
                }
                contents.showText(combinedDataArray[i]);
            }
            contents.endText();
            Logging.main("Successful CreatePDF::DrawTestSummaryBlock()!");
        }
        catch (Exception ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    private void drawSignatureLine(PDPageContentStream contents, PDPage page, PDFont font) {
        try {
            contents.beginText();
            String textLine = "Signature: ";
            float textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            contents.setFont(font, (float)intPrimaryFontSize);
            contents.newLineAtOffset((float)marginSide, (float)marginBottom);
            contents.showText(textLine);
            contents.endText();
            contents.moveTo((float)marginSide + textWidth, (float)marginBottom);
            contents.lineTo(page.getMediaBox().getWidth() / 2.0f - (float)marginSide, (float)marginBottom);
            contents.stroke();
            contents.beginText();
            textLine = "Date: ";
            textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
            contents.setFont(font, (float)intPrimaryFontSize);
            contents.newLineAtOffset(page.getMediaBox().getWidth() / 2.0f + 30.0f, (float)marginBottom);
            contents.showText(textLine);
            contents.endText();
            contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
            contents.moveTo(page.getMediaBox().getWidth() / 2.0f + 30.0f + textWidth, (float)marginBottom);
            contents.lineTo(page.getMediaBox().getWidth() - (float)marginSide, (float)marginBottom);
            contents.stroke();
            Logging.main("Successful CreatePDF::drawSignatureLine()!");
        }
        catch (IOException ex) {
            Logging.main("ERROR: Unable to draw signature line!");
        }
    }

    private void drawDigitalSignature(PDDocument doc, PDPageContentStream contents, PDPage page, PDFont font) {
        try {
            if (boolFoundSignature) {
                Logging.main("CreatePDF::DrawDigitalSignature called.");
                String textLine = "Signature: ";
                float textWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                File fileSignatureAnalyst = new File(InitDirs.configDir + File.separator + "signature.png");
                if (!fileSignatureAnalyst.exists() && !(fileSignatureAnalyst = new File(InitDirs.configDir + File.separator + "signature.bmp")).exists()) {
                    fileSignatureAnalyst = new File(InitDirs.configDir + File.separator + "signature.jpg");
                    if (!fileSignatureAnalyst.exists()) {
                        fileSignatureAnalyst = new File(InitDirs.configDir + File.separator + "signature.jpeg");
                    } else {
                        Logging.main("CreatePDF::DrawDigitalSignature ERROR: Signature file not found!");
                    }
                }
                Logging.main("Digital Signature Path = " + fileSignatureAnalyst.getAbsolutePath());
                imageSignature = PDImageXObject.createFromFile((String)fileSignatureAnalyst.getAbsolutePath(), (PDDocument)doc);
                Dimension scaledSig = CreatePDF.getScaledDimension(new Dimension(imageSignature.getWidth(), imageSignature.getHeight()), new Dimension((int)page.getMediaBox().getWidth() / 2, 40));
                contents.drawImage(imageSignature, (float)marginSide + textWidth + 2.0f, (float)(marginBottom + 2), (float)scaledSig.width, (float)scaledSig.height);
                textLine = "Date: ";
                float textDateWidth = font.getStringWidth(textLine) / 1000.0f * (float)intPrimaryFontSize;
                textLine = DateFormat.getDateInstance().format(new Date());
                textWidth = font.getStringWidth(textLine) / 1000.0f * (float)(intPrimaryFontSize + 4);
                contents.beginText();
                contents.setFont(font, (float)(intPrimaryFontSize + 4));
                contents.newLineAtOffset(((page.getMediaBox().getWidth() + page.getMediaBox().getWidth()) / 2.0f - (float)marginSide) / 2.0f + textDateWidth + 30.0f + textWidth / 2.0f, (float)(marginBottom + 5));
                contents.showText(textLine);
                contents.endText();
                Logging.main("Successful CreatePDF::DrawDigitalSignature()!");
            }
        }
        catch (Exception ex) {
            Logging.main("CreatePDF::DrawDigitalSignature ERROR! Unable to draw digital signature!");
            Logging.main("CreatePDF::DrawDigitalSignature // " + ex);
        }
    }

    private void drawCompanyLogo(PDDocument doc, PDPageContentStream contents, PDPage page) {
        try {
            if (boolFoundLogo) {
                Logging.main("CreatePDF::DrawCompanyLogo called.");
                File fileCompanyLogo = new File(InitDirs.configDir + File.separator + "logo.png");
                if (!fileCompanyLogo.exists() && !(fileCompanyLogo = new File(InitDirs.configDir + File.separator + "logo.bmp")).exists()) {
                    fileCompanyLogo = new File(InitDirs.configDir + File.separator + "logo.jpg");
                    if (!fileCompanyLogo.exists()) {
                        fileCompanyLogo = new File(InitDirs.configDir + File.separator + "logo.jpeg");
                    } else {
                        Logging.main("CreatePDF::DrawCompanyLogo ERROR: Logo file not found!");
                    }
                }
                Logging.main("Logo Path = " + fileCompanyLogo.getAbsolutePath());
                imageCompanyLogo = PDImageXObject.createFromFile((String)fileCompanyLogo.getAbsolutePath(), (PDDocument)doc);
                Dimension scaledLogo = CreatePDF.getScaledDimension(new Dimension(imageCompanyLogo.getWidth(), imageCompanyLogo.getHeight()), new Dimension((int)page.getMediaBox().getWidth() - marginSide * 2, 96));
                contents.drawImage(imageCompanyLogo, (float)(marginSide + 2), this.PDF_Y - (float)scaledLogo.height, (float)scaledLogo.width, (float)scaledLogo.height);
                this.PDF_Y = (float)((double)this.PDF_Y - scaledLogo.getHeight());
                Logging.main("Raw Company Logo Dimensions = " + imageCompanyLogo.getWidth() + " width, " + imageCompanyLogo.getHeight() + " height.");
                Logging.main("Scaled Company Logo Dimensions = " + scaledLogo.width + " width, " + scaledLogo.height + " height.");
                Logging.main("Successful CreatePDF::DrawCompanyLogo()!");
            }
        }
        catch (Exception ex) {
            Logging.main("CreatePDF::DrawCompanyLogo ERROR! Unable to draw company logo!");
            Logging.main("CreatePDF::DrawCompanyLogo // " + ex);
        }
    }

    private void drawFooterInfo(PDDocument doc) {
        try {
            PDType1Font fontDefault;
            File fontCalibri = new File(InitDirs.fontsDir + File.separator + "calibri.ttf");
            Object object = fontDefault = fontCalibri.exists() ? PDType0Font.load((PDDocument)doc, (File)new File(InitDirs.fontsDir + File.separator + "calibri.ttf")) : PDType1Font.HELVETICA;
            if (doc.getNumberOfPages() >= 1) {
                for (int numPages = 0; numPages < doc.getNumberOfPages(); ++numPages) {
                    PDPage page = doc.getPage(numPages);
                    PDPageContentStream contents = new PDPageContentStream(doc, page, true, false);
                    contents.setNonStrokingColor(Color.decode(AppUI.strPDFPrimaryFontColor));
                    contents.setStrokingColor(Color.decode(AppUI.strPDFLineColor));
                    String textLine = "Page " + (numPages + 1) + " / " + doc.getNumberOfPages() + " (" + MainMenuUI.appUI.version + ")";
                    float textWidth = fontDefault.getStringWidth(textLine) / 1000.0f * (float)intFooterFontSize;
                    contents.beginText();
                    contents.setFont((PDFont)fontDefault, (float)intFooterFontSize);
                    contents.newLineAtOffset(page.getMediaBox().getWidth() - (float)marginSide - textWidth, (float)((double)marginBottom * 0.5));
                    contents.showText(textLine);
                    contents.endText();
                    contents.close();
                }
            }
        }
        catch (IOException ex) {
            Logging.main("Could not write page footer lines!");
        }
    }

    private void LoadUserImages(PDDocument doc) {
        this.reportImagesDir = new File(InitDirs.imagesDir + File.separator + AppUI.strLoadedFileName);
        if (!this.reportImagesDir.exists()) {
            return;
        }
        imageReportImages = new LinkedList();
        for (File eachFile : this.reportImageFiles = this.reportImagesDir.listFiles()) {
            try {
                imageReportImages.push(PDImageXObject.createFromFile((String)eachFile.getAbsolutePath(), (PDDocument)doc));
                Logging.main("DEBUG: PDF generation found the file " + eachFile + " in " + this.reportImagesDir);
                ++this.numImages;
                Logging.main("DEBUG: PDF generation: total images to add = " + Integer.toString(this.numImages));
            }
            catch (Exception anyEx) {
                anyEx.toString();
                anyEx.printStackTrace();
            }
        }
        this.numImagePages = (int)Math.ceil((double)this.numImages / 4.0);
        this.drawingUserImages = this.numImagePages > 0;
        Logging.main("DEBUG: PDF generation: Total number of images pages is " + this.numImagePages);
    }

    private void DrawReportImages(PDDocument doc, PDPageContentStream contents, PDPage page, PDFont boldFont, PDFont defaultFont, float tHeight) {
        Dimension singleImageSize = new Dimension(535, 420);
        Dimension multiImageSize = new Dimension(270, 205);
        int center = (int)page.getMediaBox().getWidth() / 2;
        int imagesX = this.numImages == 1 ? center - (int)singleImageSize.getWidth() / 2 : center - (int)multiImageSize.getWidth();
        int imagePos = 1;
        int imageIndex = 0;
        int imagesDrawn = 0;
        boolean endPage = false;
        this.PDF_Y = page.getMediaBox().getHeight() - (float)marginTop - tHeight;
        if (AppUI.displayLogo) {
            this.drawCompanyLogo(doc, contents, page);
        } else {
            this.DrawCompanyHeader(contents, page, defaultFont, marginTop);
        }
        this.DrawTitleHeader(contents, page, "Images", boldFont, defaultFont);
        this.DrawCustomerTestSiteBlock(contents, page, boldFont, defaultFont);
        this.drawTestSummaryBlock(contents, page, defaultFont, boldFont);
        int imagesY = (int)this.PDF_Y - marginTop;
        while (imageReportImages.size() > 0) {
            Dimension scaledImageSize;
            Logging.main("DEBUG: PDF generation: attempting to draw an image");
            if (imagesDrawn > 3) break;
            if (this.numImages == 1) {
                try {
                    scaledImageSize = CreatePDF.getScaledDimension(new Dimension(imageReportImages.get(imageIndex).getWidth(), imageReportImages.get(imageIndex).getHeight()), new Dimension(singleImageSize.width, singleImageSize.height));
                    contents.drawImage(imageReportImages.get(imageIndex), (float)imagesX, (float)(imagesY - singleImageSize.height), (float)scaledImageSize.width, (float)scaledImageSize.height);
                    imageReportImages.remove(imageIndex);
                    --imageIndex;
                    ++imagesDrawn;
                }
                catch (Exception anyEx) {
                    Logging.main("Unhandled exception in DrawReportImages(PDDocument, PDPageContentStream, PDPage)!");
                    anyEx.toString();
                    anyEx.printStackTrace();
                }
                continue;
            }
            try {
                scaledImageSize = CreatePDF.getScaledDimension(new Dimension(imageReportImages.get(imageIndex).getWidth(), imageReportImages.get(imageIndex).getHeight()), new Dimension(multiImageSize.width, multiImageSize.height));
                contents.drawImage(imageReportImages.get(imageIndex), (float)imagesX, (float)(imagesY - multiImageSize.height), (float)scaledImageSize.width, (float)scaledImageSize.height);
                imageReportImages.remove(imageIndex);
                --imageIndex;
                ++imagesDrawn;
                if (imagePos % 2 == 0) {
                    imagesX = center - (int)multiImageSize.getWidth();
                    imagesY -= multiImageSize.height + 10;
                } else {
                    imagesX += multiImageSize.width + 10;
                }
                ++imagePos;
                ++imageIndex;
            }
            catch (Exception anyEx) {
                Logging.main("Unhandled exception in DrawReportImages(PDDocument, PDPageContentStream, PDPage)!");
                anyEx.toString();
                anyEx.printStackTrace();
            }
        }
    }

    public static boolean isValidDate(String date) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(validDate);
            df.setLenient(false);
            df.parse(date);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static boolean isValidDateTimeForPDF(String datetime) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(validDateTimeForPDF);
            df.setLenient(false);
            df.parse(datetime);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = boundary.width;
        int bound_height = boundary.height;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        return new Dimension(new_width, new_height);
    }

    public static void setPageBackgroundFill(PDPage page, PDPageContentStream contents) {
        try {
            Logging.main("Setting PDF Page Background fill to " + AppUI.strPDFBackgroundColor);
            contents.setNonStrokingColor(Color.decode(AppUI.strPDFBackgroundColor));
            contents.addRect(0.0f, 0.0f, page.getMediaBox().getWidth(), page.getMediaBox().getHeight());
            contents.fill();
        }
        catch (Exception anyEx) {
            Logging.main("Exception caught in CreatePDF.setPageBackgroundFill()!");
            anyEx.printStackTrace();
        }
    }

    static {
        imageSignature = null;
        imageCompanyLogo = null;
        imageReportImages = null;
        validDate = "MM/dd/yyyy";
        validDateTimeForPDF = "yyyy-mm-dd HH:mm";
        boolFoundSignature = false;
        boolFoundSignatureBMP = false;
        boolFoundSignaturePNG = false;
        boolFoundSignatureJPG = false;
        boolFoundSignatureJPEG = false;
        boolFoundLogo = false;
        boolFoundLogoBMP = false;
        boolFoundLogoPNG = false;
        boolFoundLogoJPG = false;
        boolFoundLogoJPEG = false;
        marginTop = AppUI.intPDFMarginTop;
        marginBottom = AppUI.intPDFMarginBottom;
        marginSide = AppUI.intPDFMarginSide;
        intBannerFontSize = AppUI.intPDFBannerFontSize;
        intFooterFontSize = AppUI.intPDFFooterFontSize;
        intHeadingFontSize = AppUI.intPDFHeadingFontSize;
        intPrimaryFontSize = AppUI.intPDFPrimaryFontSize;
    }
}

