/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.HighlightableJLabel;
import MainMenu.InitDirs;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.filechooser.FileNameExtensionFilter;

class ImageSelectionPanel
extends JFrame {
    JButton btnAdd;
    JButton btnDelete;
    JButton btnDone;
    JPanel pnlButtons;
    JPanel pnlPreviews;
    JScrollPane previewScrollPane;
    JFrame reference;
    JFileChooser jf;
    JLabel imgSelectPreview;
    LinkedList<HighlightableJLabel> imagePreviews;
    File testSpecificImageDir;
    File[] imageFileNamesList;
    String originalImageFullPath;
    String originalImageNoPath;
    Border border;

    public ImageSelectionPanel() {
        this.CreateImageDirectories();
        this.originalImageFullPath = null;
        this.originalImageNoPath = null;
        this.imagePreviews = null;
        this.jf = new JFileChooser();
        this.pnlPreviews = new JPanel(new FlowLayout());
        this.pnlPreviews.setPreferredSize(new Dimension(350, 2160));
        this.previewScrollPane = new JScrollPane(this.pnlPreviews);
        this.previewScrollPane.setPreferredSize(new Dimension(350, 475));
        this.border = BorderFactory.createLineBorder(Color.BLUE, 5);
        this.reference = this;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pnlButtons = new JPanel();
        this.pnlButtons.setLayout(new FlowLayout());
        this.btnAdd = new JButton("Add");
        this.btnDelete = new JButton("Delete");
        this.btnDone = new JButton("Done");
        this.btnAdd.addActionListener(new AddImageButtonClickHandler());
        this.btnDelete.addActionListener(new DeleteImageButtonClickHandler());
        this.btnDone.addActionListener(new DoneButtonClickHandler());
        this.pnlButtons.add(this.btnAdd);
        this.pnlButtons.add(this.btnDelete);
        this.pnlButtons.add(this.btnDone);
        this.getContentPane().add(this.previewScrollPane);
        this.getContentPane().add(this.pnlButtons);
        this.LoadImagePreviews();
        this.setTitle("Report Images");
        this.setResizable(false);
        this.setSize(275, 475);
        this.pack();
    }

    private void CreateImageDirectories() {
        this.testSpecificImageDir = new File(InitDirs.imagesDir + MainMenuUI.strLoadedFileName);
        if (this.testSpecificImageDir.exists()) {
            Logging.main("Images directory for " + MainMenuUI.strLoadedFilePath + " exists.");
        } else {
            Logging.main("Images directory for " + MainMenuUI.strLoadedFilePath + " does not exist. Creating...");
            this.testSpecificImageDir.mkdirs();
        }
    }

    private void LoadImagePreviews() {
        this.imageFileNamesList = this.testSpecificImageDir.listFiles();
        BufferedImage bim = null;
        this.imagePreviews = new LinkedList();
        for (File file : this.imageFileNamesList) {
            HighlightableJLabel tmpPreviewImg = new HighlightableJLabel(file.getAbsolutePath());
            try {
                bim = ImageIO.read(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Image im = bim.getScaledInstance(150, 150, 2);
            tmpPreviewImg.setIcon(new ImageIcon(im));
            tmpPreviewImg.setCursor(Cursor.getPredefinedCursor(12));
            this.imagePreviews.push(tmpPreviewImg);
        }
        for (int i = 0; i < this.imagePreviews.size(); ++i) {
            this.pnlPreviews.add(this.imagePreviews.get(i));
        }
        this.pnlPreviews.revalidate();
    }

    private void createAndShowGUI() {
        this.imgSelectPreview = new JLabel();
        this.imgSelectPreview.setPreferredSize(new Dimension(175, 175));
        this.jf.setAccessory(this.imgSelectPreview);
        this.jf.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Image Files", "jpg", "jpeg", "png", "gif", "bmp");
        this.jf.setFileFilter(filter);
        this.jf.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent pe) {
                SwingWorker<Image, Void> worker = new SwingWorker<Image, Void>(){

                    @Override
                    protected Image doInBackground() {
                        if (pe.getPropertyName().equals("SelectedFileChangedProperty")) {
                            File f = ImageSelectionPanel.this.jf.getSelectedFile();
                            try {
                                FileInputStream fin = new FileInputStream(f);
                                BufferedImage bim = ImageIO.read(fin);
                                return bim.getScaledInstance(178, 170, 2);
                            }
                            catch (Exception e) {
                                ImageSelectionPanel.this.imgSelectPreview.setText(" Not valid image/Unable to read");
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            Image i = (Image)this.get(1L, TimeUnit.NANOSECONDS);
                            if (i == null) {
                                return;
                            }
                            ImageSelectionPanel.this.imgSelectPreview.setIcon(new ImageIcon(i));
                        }
                        catch (Exception e) {
                            ImageSelectionPanel.this.imgSelectPreview.setText(" Error occured.");
                        }
                    }
                };
                worker.execute();
            }
        });
    }

    private void ResizeAndSaveImage(String originalFullPath, String originalNoPath, int w) throws IOException {
        try {
            File outputFile = new File(this.testSpecificImageDir + File.separator + originalNoPath + ".jpg");
            BufferedImage originalImage = ImageIO.read(new File(originalFullPath));
            Dimension scaledImageSize = ImageSelectionPanel.getScaledDimension(new Dimension(originalImage.getWidth(), originalImage.getHeight()), w);
            Image resultingImage = originalImage.getScaledInstance(scaledImageSize.width, scaledImageSize.height, 1);
            BufferedImage outputImage = new BufferedImage(scaledImageSize.width, scaledImageSize.height, 1);
            outputImage.getGraphics().drawImage(resultingImage, 0, 0, null);
            ImageIO.write((RenderedImage)outputImage, "jpg", outputFile);
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: ResizeAndSaveImage()");
            Logging.main(anyEx.toString());
        }
    }

    private static Dimension getScaledDimension(Dimension imgSize, int desiredWidth) {
        int original_width = imgSize.width;
        int original_height = imgSize.height;
        int bound_width = desiredWidth;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width != desiredWidth) {
            new_width = desiredWidth;
            new_height = new_width * original_height / original_width;
        }
        return new Dimension(new_width, new_height);
    }

    class AddImageButtonClickHandler
    implements ActionListener {
        AddImageButtonClickHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageSelectionPanel.this.createAndShowGUI();
            int returnVal = ImageSelectionPanel.this.jf.showOpenDialog(null);
            if (returnVal == 0) {
                ImageSelectionPanel.this.originalImageFullPath = ImageSelectionPanel.this.jf.getSelectedFile().getAbsolutePath();
                ImageSelectionPanel.this.originalImageNoPath = ImageSelectionPanel.this.jf.getSelectedFile().getName();
                try {
                    ImageSelectionPanel.this.ResizeAndSaveImage(ImageSelectionPanel.this.originalImageFullPath, ImageSelectionPanel.this.originalImageNoPath, 640);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ImageSelectionPanel.this.pnlPreviews.removeAll();
                ImageSelectionPanel.this.LoadImagePreviews();
            }
        }
    }

    class DeleteImageButtonClickHandler
    implements ActionListener {
        File fileToDelete;

        DeleteImageButtonClickHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < ImageSelectionPanel.this.imagePreviews.size(); ++i) {
                if (!ImageSelectionPanel.this.imagePreviews.get(i).isSelected()) continue;
                this.fileToDelete = new File(ImageSelectionPanel.this.imagePreviews.get(i).getFilename());
                this.fileToDelete.delete();
                Logging.main("Deleting " + this.fileToDelete.getAbsolutePath());
            }
            ImageSelectionPanel.this.pnlPreviews.removeAll();
            ImageSelectionPanel.this.LoadImagePreviews();
            ImageSelectionPanel.this.pnlPreviews.revalidate();
            ImageSelectionPanel.this.repaint();
        }
    }

    class DoneButtonClickHandler
    implements ActionListener {
        DoneButtonClickHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageSelectionPanel.this.reference.dispatchEvent(new WindowEvent(ImageSelectionPanel.this.reference, 201));
        }
    }
}

