/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.InitDirs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Logging {
    private static final Logger logger = Logger.getLogger("RDT");
    private static FileHandler logHandler;

    public static void main(String strLog) {
        if (!AppUI.initializedLogging) {
            Logging.prepareLogging();
            AppUI.initializedLogging = true;
        }
        Logging.log(strLog);
    }

    public static void log(String strLog) {
        logger.setUseParentHandlers(false);
        logger.info(strLog);
        if (AppUI.txtLogScroll != null) {
            try {
                AppUI.txtLogScroll.append(strLog);
                AppUI.txtLogScroll.append("\n");
                AppUI.txtLogScroll.setCaretPosition(AppUI.txtLogScroll.getText().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println(strLog);
    }

    public static void createLogFile() {
        File logFile = new File(InitDirs.logsDir + File.separator + "RDT.log");
        try {
            PrintWriter pw = null;
            if (!logFile.exists()) {
                pw = new PrintWriter(logFile);
                pw.close();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("ERROR: Unable to create logging file!");
        }
    }

    public static void prepareLogging() {
        try {
            System.out.println("Initiating logging system...");
            Logging.createLogFile();
            logHandler = new FileHandler(InitDirs.logsDir + File.separator + "RDT.log");
            logger.addHandler(logHandler);
            SimpleFormatter formatter = new SimpleFormatter();
            logHandler.setFormatter(formatter);
        }
        catch (IOException | SecurityException ex) {
            System.out.println("ERROR: Unhandled exception in Logging::prepareLogging()...");
            System.out.println(ex);
        }
    }
}

