/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import MainMenu.AppUI;
import MainMenu.CountLimiter;
import MainMenu.InitDirs;
import MainMenu.LoadSavedFile;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.TestDetails;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class RecoverFile {
    public static String strFirmwareVersion;
    public static String strSerialNumber;
    public static String strCF1;
    public static String strCF2;
    public static String strCalibrationDate;
    public static String strCustomerInfo;
    public static String strTestSiteInfo;
    private static boolean serialNumberFound;
    private static boolean cf1Found;
    private static boolean cf2Found;
    private static boolean calDateFound;
    private static boolean custInfoFound;
    private static boolean testSiteInfoFound;
    private static boolean headerPresent;
    private static boolean trailerPresent;
    private static boolean startPresent;
    private static boolean endPresent;
    private static boolean headerFixed;
    private static boolean startFixed;
    private static boolean endFixed;
    private static boolean trailerFixed;
    private static boolean firmwareFixed;
    private static boolean cf1Fixed;
    private static boolean cf2Fixed;
    private static boolean calDateFixed;
    private static boolean custInfoFixed;
    private static boolean testSiteInfoFixed;
    private static String dateText;
    private static String tempStartDate;
    private static String tempEndDate;
    private static Date startDate;
    private static Date endDate;
    private static String fakeH;
    private static String fakeZ;
    private static boolean isAllDataFile;
    private static boolean importSerialDumpFmt;
    private static boolean bracketed;
    private static boolean isTMData;
    private static LinkedList<String> classData;
    private static DecimalFormat cfDf;

    RecoverFile() {
    }

    public static LinkedList<String> main(LinkedList<String> theData) {
        strFirmwareVersion = "Unknown";
        strSerialNumber = "Unknown";
        strCF1 = "Unknown";
        strCF2 = "Unknown";
        strCalibrationDate = "Unknown";
        strCustomerInfo = "Unknown";
        strTestSiteInfo = "Unknown";
        serialNumberFound = false;
        cf1Found = false;
        cf2Found = false;
        calDateFound = false;
        custInfoFound = false;
        testSiteInfoFound = false;
        headerPresent = false;
        trailerPresent = false;
        startPresent = false;
        endPresent = false;
        headerFixed = false;
        startFixed = false;
        endFixed = false;
        trailerFixed = false;
        firmwareFixed = false;
        cf1Fixed = false;
        cf2Fixed = false;
        calDateFixed = false;
        custInfoFixed = false;
        testSiteInfoFixed = false;
        isAllDataFile = false;
        importSerialDumpFmt = false;
        bracketed = false;
        isTMData = false;
        if (classData != null) {
            classData.clear();
            classData = new LinkedList<String>(theData);
        } else {
            classData = new LinkedList<String>(theData);
        }
        LinkedList<String> dummyFile = new LinkedList<String>();
        LinkedList<String> tmDummyFile = new LinkedList<String>();
        dummyFile.addLast("THIS IS AN EMPTY FILE");
        tmDummyFile.addLast("TMDATA");
        int intDCounter = 0;
        try {
            AppUI.recoveringDataFile = true;
            Logging.main("RecoverFile: Attempting recovery of txt/csv file: " + LoadSavedFile.inputFile.getName());
            RecoverFile.SetFixesNeeded();
            if (isTMData) {
                return tmDummyFile;
            }
            if (importSerialDumpFmt) {
                Logging.main("Recon internal serial format detected. Converting data...");
                for (int i = 0; i < classData.size(); ++i) {
                    classData.set(i, classData.get(i).replaceAll(" - ", ","));
                    classData.set(i, classData.get(i).trim());
                    classData.set(i, "=DB," + classData.get(i));
                    String[] strSerialLine_parsed = classData.get(i).split(",");
                    CharSequence[] strSerialLine_corrected = new String[26];
                    if (strSerialLine_parsed[2].equals("S") || strSerialLine_parsed[2].equals("W") || strSerialLine_parsed[2].equals("E") || strSerialLine_parsed[2].equals("I")) {
                        for (int j = 0; j < 26; ++j) {
                            strSerialLine_corrected[j] = strSerialLine_parsed[j];
                        }
                        classData.set(i, String.join((CharSequence)",", strSerialLine_corrected));
                    }
                    if (!strSerialLine_parsed[2].equals("D")) continue;
                    if (classData.get(i).contains("Switch,")) {
                        classData.set(i, classData.get(i).replaceAll("Switch,", "Switch - "));
                    }
                    strSerialLine_parsed = classData.get(i).split(",");
                    strSerialLine_corrected = strSerialLine_parsed;
                    strSerialLine_corrected[1] = Integer.toString(intDCounter);
                    ++intDCounter;
                    classData.set(i, String.join((CharSequence)",", strSerialLine_corrected));
                }
                Logging.main("Recon internal serial format successfully converted.");
            }
            if (isAllDataFile) {
                int proceed = JOptionPane.showConfirmDialog(null, "This is an all-data file.\nContinuing will create individual files\nfor each session recovered. Proceed?", "All-Data Recovery", 0, 3);
                if (proceed == 0) {
                    RecoverFile.CreateFilesFromAllData(classData);
                    return dummyFile;
                }
                return dummyFile;
            }
            RecoverFile.FixMissingRecords();
            RecoverFile.FixSummaryData();
            RecoverFile.ProcessCountLimiter();
            RecoverFile.SetStartAndEndDates();
            RecoverFile.PerformFinalCheck();
            RecoverFile.GetUserInput();
            RecoverFile.AppendSummary();
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.main()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
        if (!AppUI.recoveringDataFile) {
            Logging.main("RecoverFile: returning repaired buffer.");
            return classData;
        }
        Logging.main("RecoverFile: Something went very wrong. Cannot recover file.");
        return new LinkedList<String>();
    }

    private static void SetFixesNeeded() {
        if (classData.size() > 6043) {
            isAllDataFile = true;
        }
        if (!classData.get(0).startsWith("=DB")) {
            if (classData.get(0).startsWith("^ +\\d+ - ")) {
                // empty if block
            }
            importSerialDumpFmt = true;
        }
        if (isAllDataFile) {
            return;
        }
        try {
            for (int i = 0; i < classData.size(); ++i) {
                String[] currentLine_parsed;
                String currentLine = classData.get(i);
                if (currentLine.contains("=DN")) {
                    Logging.main("RecoverFile: TM data found. Repair/import of raw TM data is not currently supported.");
                    isTMData = true;
                    return;
                }
                if (currentLine.isBlank()) {
                    Logging.main("RecoverFile: removing blank line. Size is now: " + Integer.toString(classData.size()));
                    classData.remove(i);
                    --i;
                    continue;
                }
                if (currentLine.contains("Instrument Serial:")) {
                    Logging.main("RecoverFile: Found instrument serial number in file.");
                    serialNumberFound = true;
                }
                if (currentLine.contains("Customer Information:")) {
                    Logging.main("RecoverFile: Found customer info in file.");
                    custInfoFound = true;
                }
                if (currentLine.contains("Test Site Information:")) {
                    Logging.main("RecoverFile: Found test site info in file.");
                    testSiteInfoFound = true;
                }
                if (currentLine.contains("Calibration Date =")) {
                    Logging.main("RecoverFile: Found calibration date in file.");
                    calDateFound = true;
                }
                if (currentLine.contains("Chamber 1 CF:")) {
                    Logging.main("RecoverFile: Found calibration factor 1 in file.");
                    cf1Found = true;
                }
                if (currentLine.contains("Chamber 2 CF:")) {
                    Logging.main("RecoverFile: Found calibration factor 2 in file.");
                    cf2Found = true;
                }
                if (currentLine.contains("[")) {
                    bracketed = true;
                }
                if (!currentLine.contains("=DB") || (currentLine_parsed = currentLine.split(",")).length <= 2) continue;
                if (currentLine_parsed[2].contains("H")) {
                    Logging.main("RecoverFile: Header (H) is present.");
                    headerPresent = true;
                    headerFixed = true;
                }
                if (currentLine_parsed[2].contains("S")) {
                    Logging.main("RecoverFile: Start (S) is present.");
                    startPresent = true;
                    startFixed = true;
                }
                if (currentLine_parsed[2].contains("E")) {
                    Logging.main("RecoverFile: End (E) is present.");
                    endPresent = true;
                    endFixed = true;
                }
                if (!currentLine_parsed[2].contains("Z")) continue;
                Logging.main("RecoverFile: Trailer (Z) is present.");
                trailerPresent = true;
                trailerFixed = true;
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.SetFixesNeeded()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void FixMissingRecords() {
        try {
            CharSequence[] currentLine_parsed;
            String currentLine;
            int i;
            if (!headerPresent) {
                Logging.main("RecoverFile: Data header (H) not found. Fixing...");
                if (trailerPresent) {
                    for (i = classData.size() - 1; i >= 0; --i) {
                        currentLine = classData.get(i);
                        currentLine_parsed = currentLine.split(",");
                        if (currentLine_parsed.length > 2) {
                            if (!currentLine_parsed[2].contains("Z")) continue;
                            currentLine_parsed[2] = "H";
                            currentLine_parsed[1] = "?";
                            currentLine = String.join((CharSequence)",", currentLine_parsed);
                            classData.addFirst(currentLine);
                            break;
                        }
                        classData.remove(i);
                    }
                } else {
                    classData.addFirst(fakeH);
                }
                currentLine = classData.getFirst();
                currentLine_parsed = currentLine.split(",");
                if (currentLine_parsed[2].trim().equals("H")) {
                    Logging.main("RecoverFile: Missing H was fixed.");
                    headerFixed = true;
                }
                if (!headerFixed) {
                    Logging.main("RecoverFile: Something went wrong attempting to add header (H)!");
                }
            }
            if (!trailerPresent) {
                Logging.main("RecoverFile: Data trailer (Z) not found. Fixing...");
                if (headerPresent) {
                    for (i = 0; i < classData.size(); ++i) {
                        currentLine = classData.get(i);
                        currentLine_parsed = currentLine.split(",");
                        if (currentLine_parsed.length > 2) {
                            if (!currentLine_parsed[2].contains("H")) continue;
                            currentLine_parsed[2] = "Z";
                            currentLine_parsed[1] = "?";
                            currentLine = String.join((CharSequence)",", currentLine_parsed);
                            classData.addLast(currentLine);
                            break;
                        }
                        classData.remove(i);
                    }
                } else {
                    classData.add(fakeZ);
                }
                currentLine = classData.getLast();
                currentLine_parsed = currentLine.split(",");
                if (currentLine_parsed[2].trim().equals("Z")) {
                    Logging.main("RecoverFile: Missing Z was fixed.");
                    trailerFixed = true;
                }
                if (!trailerFixed) {
                    Logging.main("RecoverFile: Something went wrong attempting to add trailer (Z)!");
                }
            }
            if (!startPresent) {
                Logging.main("RecoverFile: Start of test (S) not found. Fixing...");
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    currentLine_parsed = currentLine.split(",");
                    if (currentLine_parsed.length <= 2 || !currentLine_parsed[2].contains("I")) continue;
                    currentLine_parsed[2] = "S";
                    currentLine = String.join((CharSequence)",", currentLine_parsed);
                    classData.remove(i);
                    classData.add(i, currentLine);
                    break;
                }
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    currentLine_parsed = currentLine.split(",");
                    if (currentLine_parsed.length <= 2 || !currentLine_parsed[2].trim().equals("S")) continue;
                    Logging.main("RecoverFile: Missing S was fixed.");
                    startFixed = true;
                    break;
                }
                if (!startFixed) {
                    Logging.main("RecoverFile: Something went wrong attempting to to add start (S)!");
                }
            }
            if (!endPresent) {
                Logging.main("RecoverFile: End of test (E) not found. Fixing...");
                for (i = classData.size() - 1; i >= 0; --i) {
                    currentLine = classData.get(i);
                    currentLine_parsed = currentLine.split(",");
                    if (currentLine_parsed.length <= 2 || !currentLine_parsed[2].contains("I")) continue;
                    currentLine_parsed[2] = "E";
                    currentLine = String.join((CharSequence)",", currentLine_parsed);
                    classData.remove(i);
                    classData.add(i, currentLine);
                    break;
                }
                for (i = classData.size() - 1; i >= 0; --i) {
                    currentLine = classData.get(i);
                    currentLine_parsed = currentLine.split(",");
                    if (currentLine_parsed.length <= 2 || !((String)currentLine_parsed[2]).trim().equals("E")) continue;
                    Logging.main("RecoverFile: Missing E was fixed.");
                    endFixed = true;
                    break;
                }
                if (!endFixed) {
                    Logging.main("RecoverFile: Something went wrong attempting to add end (E)!");
                }
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.FixMissingRecords()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void FixSummaryData() {
        boolean gettingCustInfo = false;
        boolean gettingTestSiteInfo = false;
        StringBuilder custInfoStringBuilder = new StringBuilder();
        StringBuilder testSiteInfoStringBuilder = new StringBuilder();
        try {
            String[] currentLine_parsed;
            String currentLine;
            int i;
            if (!serialNumberFound) {
                strSerialNumber = LoadSavedFile.getReconSerialFromFileName(LoadSavedFile.inputFile.getName());
            } else {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (!currentLine.contains("Instrument Serial")) continue;
                    currentLine_parsed = currentLine.split(":");
                    strSerialNumber = currentLine_parsed[1].trim();
                }
            }
            if (custInfoFound) {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (currentLine.contains("Test Site Information:")) {
                        gettingCustInfo = false;
                        break;
                    }
                    if (currentLine.contains("Customer Information:")) {
                        gettingCustInfo = true;
                        continue;
                    }
                    if (!gettingCustInfo) continue;
                    custInfoStringBuilder.append(classData.get(i));
                }
                strCustomerInfo = custInfoStringBuilder.toString();
                custInfoFixed = true;
            }
            if (testSiteInfoFound) {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (currentLine.contains("SUMMARY") || currentLine.contains("Instrument Serial")) {
                        gettingTestSiteInfo = false;
                        break;
                    }
                    if (currentLine.contains("Test Site Information:")) {
                        gettingTestSiteInfo = true;
                        continue;
                    }
                    if (!gettingTestSiteInfo) continue;
                    testSiteInfoStringBuilder.append(classData.get(i));
                }
                strTestSiteInfo = testSiteInfoStringBuilder.toString();
                testSiteInfoFixed = true;
            }
            if (calDateFound) {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (!currentLine.contains("Calibration Date =")) continue;
                    currentLine_parsed = currentLine.split("=");
                    strCalibrationDate = currentLine_parsed[1].trim();
                    calDateFixed = true;
                }
            }
            if (!firmwareFixed) {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine_parsed = classData.get(i).split(",");
                    if (currentLine_parsed.length <= 2) continue;
                    if (currentLine_parsed[2].contains("H") && headerPresent) {
                        strFirmwareVersion = currentLine_parsed[4].trim();
                        firmwareFixed = true;
                        if (!(cf1Fixed && cf2Fixed || currentLine_parsed.length <= 15)) {
                            strCF1 = cfDf.format(Double.parseDouble(currentLine_parsed[15].trim()) / 1000.0);
                            cf1Fixed = true;
                            strCF2 = cfDf.format(Double.parseDouble(currentLine_parsed[16].trim().replaceAll("]", "")) / 1000.0);
                            cf2Fixed = true;
                        }
                    }
                    if (!currentLine_parsed[2].contains("Z") || !trailerPresent) continue;
                    if (!firmwareFixed) {
                        strFirmwareVersion = currentLine_parsed[4].trim();
                        firmwareFixed = true;
                    }
                    if (cf1Fixed && cf2Fixed || currentLine_parsed.length <= 15) continue;
                    strCF1 = cfDf.format(Double.parseDouble(currentLine_parsed[15].trim()) / 1000.0);
                    cf1Fixed = true;
                    strCF2 = cfDf.format(Double.parseDouble(currentLine_parsed[16].trim().replaceAll("]", "")) / 1000.0);
                    cf2Fixed = true;
                }
            }
            if (!cf1Fixed || !cf2Fixed) {
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (!currentLine.contains("Chamber 1 CF:")) continue;
                    currentLine_parsed = currentLine.split(":");
                    strCF1 = currentLine_parsed[1].trim();
                    cf1Fixed = true;
                }
                for (i = 0; i < classData.size(); ++i) {
                    currentLine = classData.get(i);
                    if (!currentLine.contains("Chamber 2 CF:")) continue;
                    currentLine_parsed = currentLine.split(":");
                    strCF2 = currentLine_parsed[1].trim();
                    cf2Fixed = true;
                }
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.FixSummaryData()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void ProcessCountLimiter() {
        try {
            for (int j = 0; j < classData.size(); ++j) {
                if (!classData.get(j).contains("=DB")) continue;
                String[] currentLine_parsed = classData.get(j).split(",");
                if (currentLine_parsed[2].contains("H") && !bracketed) {
                    classData.addFirst("[" + classData.pollFirst() + "]");
                }
                if (currentLine_parsed[2].contains("Z") && !bracketed) {
                    classData.addLast("[" + classData.pollLast() + "]");
                }
                if (currentLine_parsed[2].contains("H") || currentLine_parsed[2].contains("Z")) continue;
                if (!bracketed) {
                    classData.remove(j);
                    classData.add(j, "[" + String.join((CharSequence)",", CountLimiter.main(currentLine_parsed)) + "]");
                    continue;
                }
                classData.remove(j);
                classData.add(j, String.join((CharSequence)",", CountLimiter.main(currentLine_parsed)));
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in ProcessCountLimiter()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void SetStartAndEndDates() {
        try {
            for (int k = 0; k < classData.size(); ++k) {
                String currentLine = classData.get(k);
                if (!currentLine.contains("=DB")) continue;
                String[] currentLine_parsed = currentLine.split(",");
                if (currentLine_parsed[2].contains("S")) {
                    dateText = currentLine_parsed[4].trim() + "-" + currentLine_parsed[5].trim() + "-20" + currentLine_parsed[3].trim() + " " + currentLine_parsed[6].trim() + ":" + currentLine_parsed[7].trim();
                    startDate = AppUI.dateFormatStartEndTime.parse(dateText);
                    tempStartDate = AppUI.dateFormatStartEndTime.format(startDate);
                }
                if (!currentLine_parsed[2].contains("E")) continue;
                dateText = currentLine_parsed[4].trim() + "-" + currentLine_parsed[5].trim() + "-20" + currentLine_parsed[3].trim() + " " + currentLine_parsed[6].trim() + ":" + currentLine_parsed[7].trim();
                endDate = AppUI.dateFormatStartEndTime.parse(dateText);
                tempEndDate = AppUI.dateFormatStartEndTime.format(endDate);
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.SetStartAndEndDates()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    private static void PerformFinalCheck() {
        if (!headerPresent && headerFixed) {
            Logging.main("RecoverFile: H was not present but was fixed.");
        } else if (!headerPresent && !headerFixed) {
            Logging.main("RecoverFile: Was unable to fix H. Manually reconstruct.");
        }
        if (!startPresent && startFixed) {
            Logging.main("RecoverFile: S was not present but was fixed.");
        } else if (!startPresent && !startFixed) {
            Logging.main("RecoverFile: Was unable to fix S. Manually reconstruct.");
        }
        if (!endPresent && endFixed) {
            Logging.main("RecoverFile: E was not present but was fixed.");
        } else if (!endPresent && !endFixed) {
            Logging.main("RecoverFile: Was unable to fix E. Manually reconstruct.");
        }
        if (!trailerPresent && trailerFixed) {
            Logging.main("RecoverFile: Z was not present but was fixed.");
        } else if (!trailerPresent && !trailerFixed) {
            Logging.main("RecoverFile: Was unable to fix Z. Manually reconstruct.");
        }
        if (firmwareFixed) {
            LoadSavedFile.strFirmwareVersion = strFirmwareVersion;
            Logging.main("RecoverFile: Firmware version was pulled from H or Z.");
        } else {
            Logging.main("RecoverFile: Was not able to determine firmware version.");
        }
        if (!cf1Fixed) {
            Logging.main("RecoverFile: Was not able to find CF1. Using default of 6.000.");
            strCF1 = "6.000";
        } else {
            if (Double.parseDouble(strCF1) > 9.0) {
                Logging.main("RecoverFile: CF1 was fixed but bogus value detected. Likely bad value in H or Z record. Setting to 6.000.");
                strCF1 = "6.000";
            }
            Logging.main("RecoverFile: CF1 was successfully recovered.");
        }
        if (!cf2Fixed) {
            Logging.main("RecoverFile: Was not able to find CF2. Using default of 6.000.");
            strCF2 = "6.000";
        } else {
            if (Double.parseDouble(strCF2) > 9.0) {
                Logging.main("RecoverFile: CF2 was fixed but bogus value detected. Likely bad value in H or Z record. Setting to 6.000.");
                strCF2 = "6.000";
            }
            Logging.main("RecoverFile: CF2 was successfully recovered.");
        }
        if (calDateFound && calDateFixed) {
            Logging.main("RecoverFile: Calibration date was found and parsed.");
        } else if (calDateFound && !calDateFixed) {
            Logging.main("RecoverFile: Calibration date was found but not successfully parsed.");
        } else if (!calDateFound) {
            Logging.main("RecoverFile: Calibration date was not found in the file.");
        }
        if (custInfoFound && custInfoFixed) {
            Logging.main("RecoverFile: Customer info was found and parsed.");
        } else if (custInfoFound && !custInfoFixed) {
            Logging.main("RecoverFile: Customer info was found but not successfully parsed.");
        } else if (!custInfoFound) {
            Logging.main("RecoverFile: Customer info was not found in the file.");
        }
        if (testSiteInfoFound && testSiteInfoFixed) {
            Logging.main("RecoverFile: Test site info was found and parsed.");
        } else if (testSiteInfoFound && !testSiteInfoFixed) {
            Logging.main("RecoverFile: Test site info was found but not successfully parsed.");
        } else if (!testSiteInfoFound) {
            Logging.main("RecoverFile: Test site info was not found in the file.");
        }
    }

    private static void GetUserInput() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TestDetails frmDetails = new TestDetails();
                TestDetails.txtRDTVersion.setText(MainMenuUI.appUI.version);
                TestDetails.txtFirmwareVersion.setText(strFirmwareVersion);
                TestDetails.txtInstrumentSerial.setText(strSerialNumber);
                TestDetails.txtCalibrationDate.setText(strCalibrationDate);
                TestDetails.txtCalibrationFactor1.setText(strCF1);
                TestDetails.txtCalibrationFactor2.setText(strCF2);
                frmDetails.setVisible(true);
            }
        });
        do {
        } while (AppUI.recoveringDataFile);
    }

    private static void AppendSummary() {
        String newline = System.getProperty("line.separator");
        try {
            classData.addLast(newline);
            classData.addLast(newline);
            classData.addLast(newline);
            classData.addLast("Customer information:");
            classData.addLast(strCustomerInfo);
            classData.addLast(newline);
            classData.addLast("Test site information:");
            classData.addLast(strTestSiteInfo);
            classData.addLast(newline);
            classData.addLast("Instrument Serial: " + strSerialNumber);
            classData.addLast("Start Date/Time: " + tempStartDate);
            classData.addLast("End Date/Time: " + tempEndDate);
            classData.addLast("Total Test Duration: ");
            classData.addLast("Total Movements: ");
            classData.addLast("Avg. Humidity = ");
            classData.addLast("Avg. Pressure = ");
            classData.addLast("Avg. Temperature = ");
            classData.addLast("Chamber 1 CF: " + strCF1);
            classData.addLast("Chamber 2 CF: " + strCF2);
            classData.addLast("Calibration Date = " + strCalibrationDate);
            classData.addLast("Protocol: ");
            classData.addLast("Tampering: ");
            classData.addLast("Weather: ");
            classData.addLast("Mitigation: ");
            classData.addLast("Comment: ");
            classData.addLast("Location: ");
            classData.addLast(newline);
            classData.addLast(newline);
            classData.addLast("Analyzed By: ");
            classData.addLast("Deployed By: ");
            classData.addLast("Retrieved By: ");
        }
        catch (Exception anyEx) {
            anyEx.printStackTrace();
        }
    }

    public static void CreateFilesFromAllData(LinkedList<String> data) {
        LinkedList<Integer> startAddresses = new LinkedList<Integer>();
        LinkedList<String> filenames = new LinkedList<String>();
        String newline = System.getProperty("line.separator");
        try {
            CharSequence[] currentLine_parsed;
            int i;
            for (i = 0; i < data.size(); ++i) {
                if (!data.get(i).contains("=DB") || (currentLine_parsed = data.get(i).split(",")).length <= 2 || !currentLine_parsed[2].contains("H")) continue;
                startAddresses.add(i);
                Logging.main("RecoverFile: ALL DATA RECOVERY - Session found at " + i);
                currentLine_parsed = i == 6043 ? data.get(0).split(",") : data.get(i + 1).split(",");
                if (currentLine_parsed.length <= 5) continue;
                filenames.add("Recon_" + LoadSavedFile.getReconSerialFromFileName(LoadSavedFile.inputFile.getName()) + "_RECOVERED_" + currentLine_parsed[4] + (String)currentLine_parsed[5] + (String)currentLine_parsed[3] + ".txt");
            }
            for (i = 0; i < filenames.size(); ++i) {
                boolean incompleteSession = false;
                boolean startedFile = false;
                BufferedWriter bw = new BufferedWriter(new FileWriter(InitDirs.dataDir + File.separator + (String)filenames.get(i)));
                currentLine_parsed = data.get((Integer)startAddresses.get(i)).split(",");
                int iterator = (Integer)startAddresses.get(i) + 1;
                while (!currentLine_parsed[2].contains("Z")) {
                    if (iterator == 6044) {
                        iterator = 0;
                    }
                    if (startedFile && currentLine_parsed[2].contains("H")) {
                        Logging.main("RecoverFile: " + (String)filenames.get(i) + " - Found start of another session before end reached. Flagging incomplete.");
                        incompleteSession = true;
                    }
                    if (incompleteSession) {
                        currentLine_parsed = data.get((Integer)startAddresses.get(i)).split(",");
                        currentLine_parsed[2] = "Z";
                        bw.write(String.join((CharSequence)",", currentLine_parsed));
                        bw.write(newline + newline + "INCOMPLETE SESSION");
                        bw.close();
                        break;
                    }
                    bw.write(String.join((CharSequence)",", currentLine_parsed) + newline);
                    currentLine_parsed = data.get(iterator).split(",");
                    ++iterator;
                    startedFile = true;
                }
                if (incompleteSession) continue;
                bw.write(data.get(iterator - 1));
                bw.close();
            }
        }
        catch (Exception anyEx) {
            Logging.main("ERROR: Exception in RecoverFile.CreateFilesFromAllData()!");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            anyEx.printStackTrace(pw);
            Logging.main(sw.toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, "Done");
            }
        });
    }

    private static void WriteDebugFile(String filename) {
        try {
            PrintWriter pw = new PrintWriter(InitDirs.dataDir + File.separator + filename);
            for (int i = 0; i < classData.size(); ++i) {
                pw.write(classData.get(i) + MainMenuUI.newline);
            }
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        fakeH = "=DB,?,H,CRM,?,?,?,?,?,?,?,?,?,?,?";
        fakeZ = "=DB,?,Z,CRM,?,?,?,?,?,?,?,?,?,?,?";
        cfDf = new DecimalFormat("0.000");
    }
}

