/*
 * Decompiled with CFR 0.152.
 */
package MainMenu;

import Config.FlagForm;
import MainMenu.AppUI;
import MainMenu.CreateJSONData;
import MainMenu.InitDirs;
import MainMenu.Logging;
import MainMenu.MainMenuUI;
import MainMenu.ReadComm;
import MainMenu.ReconProtocol;
import MainMenu.TMProtocol;
import MainMenu.WriteComm;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;
import jxl.read.biff.BiffException;
import jxl.write.WriteException;

public class ScanComm {
    public static String ReconCalDate = "Unknown";
    public static String ReconFirmwareVersion;
    public static SerialPort scannedPort;
    public static String userOS;
    private static boolean reconDownloadClearedSession;
    private static AppUI.RDevice deviceType;

    public static void main(String[] args) {
        try {
            ScanComm obj = new ScanComm();
            ScanComm.run(1);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.main(sw.toString());
        }
    }

    public static AppUI.RDevice run(Integer OptArgs) throws InterruptedException, FileNotFoundException, UnsupportedEncodingException, ParseException, IOException, WriteException, BiffException {
        String[] portNames;
        boolean foundAnyDevice = false;
        deviceType = AppUI.RDevice.NONE;
        Logging.main("Beginning to scan communication ports...");
        if (AppUI.strUserComPort.equals("auto")) {
            if (userOS.contains("win")) {
                portNames = SerialPortList.getPortNames();
            } else if (userOS.contains("linux")) {
                portNames = SerialPortList.getPortNames((String)"/dev/", (Pattern)Pattern.compile("tty(ACM[0-9]{1,2})"));
            } else if (userOS.contains("mac")) {
                portNames = SerialPortList.getPortNames((String)"/dev/", (Pattern)Pattern.compile("tty.usbmode*"));
            } else {
                portNames = SerialPortList.getPortNames();
                Logging.main("OS not Windows, Linux, or Mac...");
            }
        } else {
            portNames = new String[]{AppUI.strUserComPort};
        }
        block102: for (int i = 0; i < portNames.length; ++i) {
            Logging.main(portNames[i]);
            scannedPort = new SerialPort(portNames[i]);
            try {
                MainMenuUI.appUI.displayProgressLabel("Searching for Rad Elec devices...");
                scannedPort.openPort();
                scannedPort.setParams(9600, 8, 1, 0);
                Thread.sleep(125L);
                WriteComm.main(scannedPort, ReconProtocol.ReconConfirm);
                Thread.sleep(125L);
                String DeviceResponse = ReadComm.main(scannedPort, 19);
                if (DeviceResponse == null) {
                    Logging.main("Non-communicative device at " + portNames[i]);
                    scannedPort.closePort();
                    continue;
                }
                String[] DeviceResponse_split = DeviceResponse.split(",");
                if (DeviceResponse_split.length > 2) {
                    foundAnyDevice = true;
                    switch (DeviceResponse_split[1]) {
                        case "CRM": {
                            deviceType = AppUI.RDevice.RECON;
                            break;
                        }
                        case "CRM+": {
                            deviceType = AppUI.RDevice.RECON;
                            break;
                        }
                        case "TM": {
                            if (DeviceResponse_split[2].startsWith("2")) {
                                deviceType = AppUI.RDevice.TM;
                            }
                            if (DeviceResponse_split[2].startsWith("3")) {
                                deviceType = AppUI.RDevice.MTM;
                            }
                            if (!DeviceResponse_split[2].startsWith("4")) break;
                            deviceType = AppUI.RDevice.MTM2;
                            break;
                        }
                        case "CWLM": {
                            deviceType = AppUI.RDevice.CWLM;
                            break;
                        }
                        default: {
                            deviceType = AppUI.RDevice.NONE;
                        }
                    }
                }
                switch (deviceType) {
                    case RECON: {
                        MainMenuUI.appUI.displayProgressLabel("Rad Elec Recon CRM found!");
                        Logging.main("Rad Elec Recon CRM found!");
                        switch (OptArgs) {
                            case 1: {
                                MainMenuUI.appUI.displayProgressLabel("Recon CRM found on " + portNames[i] + "!");
                                String[] DeviceResponse_parsed = DeviceResponse.split(",");
                                if (DeviceResponse_parsed.length > 3 && DeviceResponse_parsed[3] != null) {
                                    Logging.main("Recon CRM Serial #" + DeviceResponse_parsed[3]);
                                    MainMenuUI.appUI.displaySerialNumber(DeviceResponse_parsed[3]);
                                    ReconProtocol.instrumentSerial = DeviceResponse_parsed[3].trim();
                                } else {
                                    Logging.main("Unable to determine Recon CRM Serial#. Rogue instrument detected.");
                                }
                                if (DeviceResponse_parsed.length > 2 && DeviceResponse_parsed[2] != null) {
                                    Logging.main("Firmware v" + DeviceResponse_parsed[2]);
                                    ReconFirmwareVersion = DeviceResponse_parsed[2];
                                    MainMenuUI.appUI.displayFirmwareVersion(ReconFirmwareVersion);
                                    ReconProtocol.firmwareVersion = ReconFirmwareVersion;
                                } else {
                                    Logging.main("Unknown Firmware Version! Probably not good...");
                                }
                                try {
                                    ScanComm.CheckReconProtocol(scannedPort);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                ReconCalDate = ScanComm.GetCalibrationDateAndFactors(scannedPort);
                                MainMenuUI.appUI.SetCalDate(ReconCalDate);
                                ReconProtocol.calibrationDate = ReconCalDate;
                                ReconProtocol.SetNumDataRecords();
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                Logging.main("Clearing Current Session via :CD command...");
                                try {
                                    ScanComm.ClearSessionMemory(scannedPort);
                                    ScanComm.CheckReconProtocol(scannedPort);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 4: {
                                try {
                                    ScanComm.ClearReconMemory(scannedPort);
                                    ScanComm.CheckReconProtocol(scannedPort);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 5: {
                                Logging.main("Clearing memory and dumping all data...");
                                try {
                                    ScanComm.DumpAllData(scannedPort);
                                    ScanComm.CheckReconProtocol(scannedPort);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 6: {
                                Logging.main("Checking for records...");
                                MainMenuUI.appUI.displayProgressLabel("Checking for records...");
                                reconDownloadClearedSession = false;
                                if (ScanComm.CheckForNewRecords(scannedPort).booleanValue()) {
                                    try {
                                        Logging.main("Begin downloading session...");
                                        ScanComm.DownloadNewRecord(scannedPort);
                                    }
                                    catch (Exception anyEx) {
                                        StringWriter sw = new StringWriter();
                                        PrintWriter pw = new PrintWriter(sw);
                                        anyEx.printStackTrace(pw);
                                        Logging.main(sw.toString());
                                    }
                                    break;
                                }
                                Logging.main("Pointer table shows no new sessions. Downloading last session anyway.");
                                reconDownloadClearedSession = true;
                                ScanComm.DownloadNewRecord(scannedPort);
                                break;
                            }
                            case 7: {
                                Logging.main("Setting Recon time...");
                                try {
                                    ReconProtocol.SetReconTimeFromPC();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                MainMenuUI.appUI.displayProgressLabel("Recon time set.");
                                break;
                            }
                            case 8: {
                                Logging.main("ScanComm: Connecting to set options bitmask.");
                                try {
                                    ReconProtocol.SetOptionFlag();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                Logging.main("Display options saved to unit.");
                                MainMenuUI.appUI.displayProgressLabel("Display options saved to unit.");
                                FlagForm.displayOptionsWriteSuccess = true;
                                break;
                            }
                            case 9: {
                                Logging.main("Clearing tamper flag.");
                                try {
                                    ReconProtocol.ClearTamperFlag();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                MainMenuUI.appUI.displayProgressLabel("Tamper flag cleared.");
                                break;
                            }
                            case 10: {
                                Logging.main("ScanComm: Connecting to parse options bitmask.");
                                try {
                                    ReconProtocol.ParseOptionFlag();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 11: {
                                Logging.main("ScanComm: Connecting to determine default file name.");
                                try {
                                    ReconProtocol.SetDefaultFilename(ReconProtocol.sessionAddresses.get(ReconProtocol.currentSession));
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 12: {
                                Logging.main("ScanComm: Connecting to read pointer table.");
                                try {
                                    ReconProtocol.GetPointerTable();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                for (int z = 0; z < MainMenuUI.appUI.getDataSessions(); ++z) {
                                    AppUI.sessionStrings.add(ReconProtocol.GetSessionDescription(ReconProtocol.sessionAddresses.get(z)));
                                }
                                break;
                            }
                        }
                        scannedPort.closePort();
                        break block102;
                    }
                    case TM: {
                        MainMenuUI.appUI.displayProgressLabel("Rad Elec Tamper Monitor found!");
                        Logging.main("Rad Elec Tamper Monitor found!");
                        Logging.main("Device Type is: " + (Object)((Object)deviceType));
                        switch (OptArgs) {
                            case 1: {
                                TMProtocol.SetTMID();
                                MainMenuUI.appUI.displaySerialNumber(TMProtocol.instrumentSerial);
                                MainMenuUI.appUI.displayFirmwareVersion(TMProtocol.firmwareVersion);
                                ScanComm.CheckForNewRecords(scannedPort);
                                break;
                            }
                            case 3: {
                                TMProtocol.ClearDownloadFlag();
                                ScanComm.CheckForNewRecords(scannedPort);
                                break;
                            }
                            case 5: {
                                ScanComm.DumpAllData(scannedPort);
                                break;
                            }
                            case 6: {
                                Logging.main("Checking for records...");
                                MainMenuUI.appUI.displayProgressLabel("Checking for records...");
                                if (!ScanComm.CheckForNewRecords(scannedPort).booleanValue()) break;
                                try {
                                    Logging.main("Begin downloading session...");
                                    ScanComm.DownloadNewRecord(scannedPort);
                                    if (!AppUI.autoResetTM) break;
                                    TMProtocol.ClearDownloadFlag();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 7: {
                                try {
                                    TMProtocol.SetTMTimeFromPC();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                MainMenuUI.appUI.displayProgressLabel("TM time set.");
                                break;
                            }
                            case 11: {
                                Logging.main("ScanComm: Connecting to determine default file name.");
                                try {
                                    TMProtocol.SetDefaultFilename(0);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                        }
                        scannedPort.closePort();
                        break block102;
                    }
                    case MTM: {
                        MainMenuUI.appUI.displayProgressLabel("Rad Elec Mini TM found!");
                        Logging.main("Rad Elec Mini TM found!");
                        Logging.main("Device Type is: " + (Object)((Object)deviceType));
                        switch (OptArgs) {
                            case 1: {
                                TMProtocol.SetTMID();
                                MainMenuUI.appUI.displaySerialNumber(TMProtocol.instrumentSerial);
                                MainMenuUI.appUI.displayFirmwareVersion(TMProtocol.firmwareVersion);
                                ScanComm.CheckForNewRecords(scannedPort);
                                break;
                            }
                            case 3: {
                                TMProtocol.ClearDownloadFlag();
                                ScanComm.CheckForNewRecords(scannedPort);
                                break;
                            }
                            case 5: {
                                ScanComm.DumpAllData(scannedPort);
                                break;
                            }
                            case 6: {
                                Logging.main("Checking for records...");
                                MainMenuUI.appUI.displayProgressLabel("Checking for records...");
                                if (!ScanComm.CheckForNewRecords(scannedPort).booleanValue()) break;
                                try {
                                    Logging.main("Begin downloading session...");
                                    ScanComm.DownloadNewRecord(scannedPort);
                                    if (!AppUI.autoResetTM) break;
                                    TMProtocol.ClearDownloadFlag();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 7: {
                                try {
                                    TMProtocol.SetTMTimeFromPC();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                MainMenuUI.appUI.displayProgressLabel("Mini TM time set.");
                                break;
                            }
                            case 11: {
                                Logging.main("ScanComm: Connecting to determine default file name.");
                                try {
                                    TMProtocol.SetDefaultFilename(0);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                        }
                        scannedPort.closePort();
                        break block102;
                    }
                    case MTM2: {
                        MainMenuUI.appUI.displayProgressLabel("Rad Elec Mini TM II found!");
                        Logging.main("Rad Elec Mini TM II found!");
                        Logging.main("Device Type is: " + (Object)((Object)deviceType));
                        switch (OptArgs) {
                            case 1: {
                                TMProtocol.SetTMID();
                                ScanComm.CheckReconProtocol(scannedPort);
                                MainMenuUI.appUI.displaySerialNumber(TMProtocol.instrumentSerial);
                                MainMenuUI.appUI.displayFirmwareVersion(TMProtocol.firmwareVersion);
                                break;
                            }
                            case 3: {
                                TMProtocol.ClearDownloadFlag();
                                ScanComm.CheckReconProtocol(scannedPort);
                                break;
                            }
                            case 5: {
                                ScanComm.DumpAllData(scannedPort);
                                break;
                            }
                            case 6: {
                                Logging.main("Checking for records...");
                                MainMenuUI.appUI.displayProgressLabel("Checking for records...");
                                if (!ScanComm.CheckForNewRecords(scannedPort).booleanValue()) break;
                                try {
                                    Logging.main("Begin downloading session...");
                                    ScanComm.DownloadNewRecord(scannedPort);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 7: {
                                try {
                                    TMProtocol.SetTMTimeFromPC();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                MainMenuUI.appUI.displayProgressLabel("Mini TM-II time set.");
                                break;
                            }
                            case 11: {
                                Logging.main("ScanComm: Connecting to determine default file name.");
                                try {
                                    if (TMProtocol.hasCN) {
                                        TMProtocol.SetDefaultFilename(TMProtocol.sessionAddresses.get(TMProtocol.currentSession));
                                        break;
                                    }
                                    TMProtocol.SetDefaultFilename(0);
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                break;
                            }
                            case 12: {
                                if (!TMProtocol.hasCN) break;
                                Logging.main("ScanComm: Connecting to read pointer table.");
                                try {
                                    TMProtocol.GetPointerTable();
                                }
                                catch (Exception anyEx) {
                                    StringWriter sw = new StringWriter();
                                    PrintWriter pw = new PrintWriter(sw);
                                    anyEx.printStackTrace(pw);
                                    Logging.main(sw.toString());
                                }
                                for (int z = 0; z < MainMenuUI.appUI.getDataSessions(); ++z) {
                                    AppUI.sessionStrings.add(TMProtocol.GetSessionDescription(TMProtocol.sessionAddresses.get(z)));
                                }
                                break;
                            }
                        }
                        scannedPort.closePort();
                        break block102;
                    }
                    case CWLM: {
                        break block102;
                    }
                    default: {
                        Logging.main("Device at " + portNames[i] + " responded but is not a known device.");
                        scannedPort.closePort();
                        break;
                    }
                }
                continue;
            }
            catch (SerialPortException ex) {
                Logging.main("ScanComm encountered a serial port exception when attempting to communicate with " + scannedPort.getPortName() + ".");
            }
        }
        if (!foundAnyDevice) {
            MainMenuUI.appUI.displayProgressLabel("No device found.");
            Logging.main("No Rad Elec devices found.");
            return AppUI.RDevice.NONE;
        }
        return deviceType;
    }

    static Boolean CheckForNewRecords(SerialPort scannedPort) throws InterruptedException {
        try {
            String DeviceResponse = null;
            String DeviceResponse_targeted = null;
            String[] DeviceResponse_parsed = null;
            switch (deviceType) {
                case RECON: {
                    Thread.sleep(125L);
                    WriteComm.main(scannedPort, ReconProtocol.CheckNewRecord);
                    Thread.sleep(125L);
                    DeviceResponse = ReadComm.main(scannedPort, 19);
                    DeviceResponse_targeted = DeviceResponse.substring(0, 4);
                    Logging.main(DeviceResponse);
                    if (DeviceResponse_targeted.equals("=DB,")) {
                        Logging.main("Recon has a new session available for download.");
                        Thread.sleep(125L);
                        return true;
                    }
                    Logging.main("Recon has no new sessions.");
                    MainMenuUI.appUI.displayProgressLabel("Recon has no new sessions.");
                    return false;
                }
                case CWLM: {
                    return false;
                }
                case TM: {
                    Thread.sleep(125L);
                    WriteComm.main(scannedPort, ":RP\n");
                    Thread.sleep(125L);
                    DeviceResponse = ReadComm.main(scannedPort, 19);
                    DeviceResponse_parsed = DeviceResponse.split(",");
                    Logging.main(DeviceResponse);
                    if (DeviceResponse_parsed[3].trim().equals("2")) {
                        Logging.main("TM has a new session available for download.");
                        MainMenuUI.appUI.displayDataSessions(deviceType, "YES");
                        Thread.sleep(125L);
                        return true;
                    }
                    Logging.main("TM has no new test available.");
                    MainMenuUI.appUI.displayDataSessions(deviceType, "NO");
                    MainMenuUI.appUI.displayProgressLabel("TM has no new data.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainMenuUI.appUI.txtNewFileName.setVisible(false);
                            MainMenuUI.appUI.chkUseStreetAddressForFilename.setVisible(false);
                            MainMenuUI.appUI.btnDownloadSession.setVisible(false);
                        }
                    });
                    return false;
                }
                case MTM: {
                    Thread.sleep(125L);
                    WriteComm.main(scannedPort, ":RP\n");
                    Thread.sleep(125L);
                    DeviceResponse = ReadComm.main(scannedPort, 19);
                    DeviceResponse_parsed = DeviceResponse.split(",");
                    Logging.main(DeviceResponse);
                    if (DeviceResponse_parsed[3].trim().equals("2")) {
                        Logging.main("Mini TM has a new session available for download.");
                        MainMenuUI.appUI.displayDataSessions(deviceType, "YES");
                        Thread.sleep(125L);
                        return true;
                    }
                    Logging.main("Mini TM has no new test available.");
                    MainMenuUI.appUI.displayDataSessions(deviceType, "NO");
                    MainMenuUI.appUI.displayProgressLabel("Mini TM has no new data.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainMenuUI.appUI.txtNewFileName.setVisible(false);
                            MainMenuUI.appUI.chkUseStreetAddressForFilename.setVisible(false);
                            MainMenuUI.appUI.btnDownloadSession.setVisible(false);
                        }
                    });
                    return false;
                }
                case MTM2: {
                    Thread.sleep(125L);
                    WriteComm.main(scannedPort, ":RB\n");
                    Thread.sleep(125L);
                    DeviceResponse = ReadComm.main(scannedPort, 19);
                    DeviceResponse_targeted = DeviceResponse.substring(0, 4);
                    Logging.main(DeviceResponse);
                    if (DeviceResponse_targeted.equals("=DN,")) {
                        Logging.main("Mini TM-II has a new session available for download.");
                        Thread.sleep(125L);
                        return true;
                    }
                    Logging.main("Mini TM-II has no new sessions.");
                    MainMenuUI.appUI.displayProgressLabel("Mini TM-II has no new sessions.");
                    return false;
                }
            }
            return false;
        }
        catch (InterruptedException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
            return false;
        }
    }

    static void CheckReconProtocol(SerialPort scannedPort) throws InterruptedException {
        try {
            Logging.main("Issuing :RP command to determine data session count...");
            Thread.sleep(10L);
            WriteComm.main(scannedPort, ReconProtocol.ReadProtocol);
            Thread.sleep(100L);
            String DeviceResponse = ReadComm.main(scannedPort, 19);
            String[] DeviceResponse_parsed = DeviceResponse.split(",");
            if (DeviceResponse_parsed.length > 3 && DeviceResponse_parsed[3] != null) {
                Logging.main("Data sessions in memory: " + DeviceResponse_parsed[3]);
                MainMenuUI.appUI.displayDataSessions(deviceType, DeviceResponse_parsed[3]);
                if (deviceType == AppUI.RDevice.RECON) {
                    MainMenuUI.appUI.displayCalibrationDate("");
                    MainMenuUI.appUI.displayCalibrationDue("");
                }
            } else {
                Logging.main("Unable to read number of data sessions in memory.");
            }
        }
        catch (InterruptedException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void DownloadNewRecord(SerialPort scannedPort) throws InterruptedException, FileNotFoundException, UnsupportedEncodingException, ParseException, IOException {
        switch (MainMenuUI.appUI.deviceType) {
            case RECON: {
                try {
                    if (reconDownloadClearedSession) {
                        ReconProtocol.GetPointerTableRCT();
                        ReconProtocol.SetDefaultFilename(ReconProtocol.sessionAddresses.getLast());
                    }
                    ReconProtocol.DetermineFileName();
                    if (!MainMenuUI.appUI.ShowFileExistsOptionPane(ReconProtocol.filenameJSON)) {
                        Logging.main("Download cancelled.");
                        return;
                    }
                    if (reconDownloadClearedSession) {
                        if (ReconProtocol.DownloadReconSessionToRAMRCT()) {
                            CreateJSONData.main(ReconProtocol.reconSession, ReconProtocol.filenameJSON, false, false);
                            MainMenuUI.appUI.checkAutoLoadFile();
                            return;
                        }
                        Logging.main("Error downloading Recon data. Data not saved.");
                        return;
                    }
                    if (ReconProtocol.DownloadReconSessionToRAM()) {
                        CreateJSONData.main(ReconProtocol.reconSession, ReconProtocol.filenameJSON, false, false);
                        MainMenuUI.appUI.checkAutoLoadFile();
                        return;
                    }
                    Logging.main("Error downloading Recon data. Data not saved.");
                    return;
                }
                catch (InterruptedException ex) {
                    StringWriter swEx = new StringWriter();
                    ex.printStackTrace(new PrintWriter(swEx));
                    String strEx = swEx.toString();
                    Logging.main(strEx);
                }
                return;
            }
            case TM: {
                try {
                    TMProtocol.DetermineFileName();
                    if (!MainMenuUI.appUI.ShowFileExistsOptionPane(TMProtocol.filenameJSON)) {
                        Logging.main("Download cancelled.");
                        return;
                    }
                    if (!TMProtocol.DownloadTMSessionToRAM()) {
                        Logging.main("Error downloading TM data. Data not saved.");
                        return;
                    }
                    CreateJSONData.main(TMProtocol.tmSession, TMProtocol.filenameJSON, false, false);
                    MainMenuUI.appUI.checkAutoLoadFile();
                    return;
                }
                catch (Exception anyEx) {
                    StringWriter swEx = new StringWriter();
                    anyEx.printStackTrace(new PrintWriter(swEx));
                    Logging.main(swEx.toString());
                }
                return;
            }
            case MTM: {
                try {
                    TMProtocol.DetermineFileName();
                    if (!MainMenuUI.appUI.ShowFileExistsOptionPane(TMProtocol.filenameJSON)) {
                        Logging.main("Download cancelled.");
                        return;
                    }
                    if (!TMProtocol.DownloadTMSessionToRAM()) {
                        Logging.main("Error downloading TM data. Data not saved.");
                        return;
                    }
                    CreateJSONData.main(TMProtocol.tmSession, TMProtocol.filenameJSON, false, false);
                    MainMenuUI.appUI.checkAutoLoadFile();
                    return;
                }
                catch (Exception anyEx) {
                    StringWriter swEx = new StringWriter();
                    anyEx.printStackTrace(new PrintWriter(swEx));
                    Logging.main(swEx.toString());
                }
                return;
            }
            case MTM2: {
                try {
                    TMProtocol.DetermineFileName();
                    if (!MainMenuUI.appUI.ShowFileExistsOptionPane(TMProtocol.filenameJSON)) {
                        Logging.main("Download cancelled.");
                        return;
                    }
                    if (!TMProtocol.DownloadTMSessionToRAM()) {
                        Logging.main("Error downloading TM data. Data not saved.");
                        return;
                    }
                    CreateJSONData.main(TMProtocol.tmSession, TMProtocol.filenameJSON, false, false);
                    MainMenuUI.appUI.checkAutoLoadFile();
                    return;
                }
                catch (Exception anyEx) {
                    StringWriter swEx = new StringWriter();
                    anyEx.printStackTrace(new PrintWriter(swEx));
                    Logging.main(swEx.toString());
                }
                return;
            }
        }
    }

    static void DumpAllData(SerialPort scannedPort) throws InterruptedException, FileNotFoundException, UnsupportedEncodingException, ParseException, IOException, WriteException {
        try {
            String dataLine;
            String[] DeviceResponse_parsed;
            String DeviceResponse_targeted;
            String DeviceResponse;
            int i;
            String namePrefix = "Unknown";
            String strInstrumentSerial = "Unknown";
            boolean hasDiagRecords = false;
            int numDataRecords = 0;
            int diagBufferLength = 100;
            int sampleCounter = 0;
            int numberFailedAttemptsPerSample = 1;
            int maximumFailedAttempts = 5;
            if (deviceType == AppUI.RDevice.RECON) {
                hasDiagRecords = ReconProtocol.numDataRecords <= 6043;
            }
            switch (deviceType) {
                case TM: {
                    numDataRecords = 2046;
                    strInstrumentSerial = TMProtocol.instrumentSerial;
                    namePrefix = "TM_";
                    break;
                }
                case MTM: {
                    numDataRecords = 1022;
                    strInstrumentSerial = TMProtocol.instrumentSerial;
                    namePrefix = "MiniTM_";
                    break;
                }
                case MTM2: {
                    numDataRecords = 4096;
                    strInstrumentSerial = TMProtocol.instrumentSerial;
                    namePrefix = "MiniTM-II_";
                    break;
                }
                case RECON: {
                    numDataRecords = hasDiagRecords ? 6044 : 6144;
                    strInstrumentSerial = ReconProtocol.instrumentSerial;
                    namePrefix = "Recon_";
                    break;
                }
            }
            Logging.main("Confirming device S/N #" + strInstrumentSerial + " for total data dump.");
            PrintWriter writer = new PrintWriter(InitDirs.dataDir + File.separator + namePrefix + strInstrumentSerial + "_AllData.txt", "UTF-8");
            for (i = 0; i < numDataRecords; ++i) {
                if (i == 0) {
                    WriteComm.main(scannedPort, ":RN0\n");
                } else {
                    WriteComm.main(scannedPort, ":RN\n");
                }
                DeviceResponse = ReadComm.main(scannedPort, 19);
                DeviceResponse_targeted = DeviceResponse.substring(0, 3);
                if ((DeviceResponse_targeted.equals("=DB") || DeviceResponse_targeted.equals("=DN")) && Integer.parseInt((DeviceResponse_parsed = DeviceResponse.split(","))[1]) != sampleCounter) {
                    Logging.main("DumpAllData(): Response does not match expected record number. Retrying. Attempt# " + numberFailedAttemptsPerSample);
                    while (Integer.parseInt(DeviceResponse_parsed[1]) != sampleCounter || numberFailedAttemptsPerSample <= 5) {
                        WriteComm.main(scannedPort, ReconProtocol.GetSpecifiedRecordCommand(sampleCounter));
                        DeviceResponse = ReadComm.main(scannedPort, 19);
                        DeviceResponse_parsed = DeviceResponse.split(",");
                        if (Integer.parseInt(DeviceResponse_parsed[1]) == sampleCounter) continue;
                        ++numberFailedAttemptsPerSample;
                    }
                    if (Integer.parseInt(DeviceResponse_parsed[1]) != sampleCounter) {
                        Logging.main("DumpAllData(): Was not able to read record # " + sampleCounter + " after five attempts. Possible bad section of EEPROM.");
                    }
                }
                dataLine = DeviceResponse.replaceAll("[\n\r]", "");
                writer.println(dataLine);
                ++sampleCounter;
                MainMenuUI.appUI.displayProgressLabel("Reading Record #" + Integer.toString(i) + "...");
            }
            if (deviceType == AppUI.RDevice.RECON && hasDiagRecords) {
                Logging.main("Finished primary data dump. Dumping diagnostic records buffer...");
                writer.println("-------------------------------------------------------------------------------------------");
                writer.println("DIAGNOSTIC BUFFER");
                writer.println("-------------------------------------------------------------------------------------------");
                sampleCounter = 0;
                numberFailedAttemptsPerSample = 1;
                for (i = 0; i < diagBufferLength; ++i) {
                    if (i == 0) {
                        WriteComm.main(scannedPort, ReconProtocol.ReadFirstDiagnosticRecord);
                    } else {
                        WriteComm.main(scannedPort, ReconProtocol.ReadNextDiagnosticRecord);
                    }
                    DeviceResponse = ReadComm.main(scannedPort, 19);
                    DeviceResponse_targeted = DeviceResponse.substring(0, 3);
                    if (DeviceResponse_targeted.equals("=DB") && Integer.parseInt((DeviceResponse_parsed = DeviceResponse.split(","))[1]) != sampleCounter) {
                        Logging.main("DumpAllData(): Response does not match expected record number. Retrying. Attempt# " + numberFailedAttemptsPerSample);
                        while (Integer.parseInt(DeviceResponse_parsed[1]) != sampleCounter || numberFailedAttemptsPerSample <= 5) {
                            WriteComm.main(scannedPort, ReconProtocol.GetSpecifiedRecordCommand(sampleCounter));
                            DeviceResponse = ReadComm.main(scannedPort, 19);
                            DeviceResponse_parsed = DeviceResponse.split(",");
                            if (Integer.parseInt(DeviceResponse_parsed[1]) == sampleCounter) continue;
                            ++numberFailedAttemptsPerSample;
                        }
                        if (Integer.parseInt(DeviceResponse_parsed[1]) != sampleCounter) {
                            Logging.main("DumpAllData(): Was not able to read record in diagnostic buffer # " + sampleCounter + " after five attempts. Possible bad section of EEPROM.");
                        }
                    }
                    dataLine = DeviceResponse.replaceAll("[\n\r]", "");
                    writer.println(dataLine);
                    ++sampleCounter;
                    MainMenuUI.appUI.displayProgressLabel("Reading Diagnostic Record #" + Integer.toString(i) + "...");
                }
            }
            writer.close();
            MainMenuUI.appUI.displayProgressLabel("Data dump successful.");
            Logging.main("Data dump complete.");
        }
        catch (Exception anyEx) {
            StringWriter swEx = new StringWriter();
            anyEx.printStackTrace(new PrintWriter(swEx));
            Logging.main(swEx.toString());
        }
    }

    static void ClearSessionMemory(SerialPort scannedPort) throws InterruptedException {
        try {
            long RecordHeader = 0L;
            WriteComm.main(scannedPort, ReconProtocol.CheckNewRecord);
            Thread.sleep(50L);
            String DeviceResponse = ReadComm.main(scannedPort, 19);
            String DeviceResponse_targeted = DeviceResponse.substring(0, 3);
            if (DeviceResponse_targeted.equals("=BD")) {
                Logging.main("There were no new records on this CRM; no session to delete.");
                MainMenuUI.appUI.displayProgressLabel("No data sessions found.");
                return;
            }
            Thread.sleep(50L);
            WriteComm.main(scannedPort, ReconProtocol.ClearSessionCommand);
            Logging.main("Clearing Memory via :CD command...");
            Logging.main(ReconProtocol.ClearSessionCommand);
            Thread.sleep(50L);
            WriteComm.main(scannedPort, ReconProtocol.CheckNewRecord);
            DeviceResponse = ReadComm.main(scannedPort, 19);
            DeviceResponse_targeted = DeviceResponse.substring(0, 3);
            if (DeviceResponse_targeted.equals("=BD")) {
                Logging.main("Ambiguous =BD response from :CD command. Assume the session has been cleared?");
                MainMenuUI.appUI.displayProgressLabel("Session probably cleared.");
            } else if (DeviceResponse_targeted.equals("=OK")) {
                Logging.main("Data session cleared.");
                MainMenuUI.appUI.displayProgressLabel("Data session cleared.");
            } else {
                Logging.main("Unexpected response from CRM.");
                MainMenuUI.appUI.displayProgressLabel("Unable to clear session pointer.");
            }
        }
        catch (InterruptedException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    static void ClearReconMemory(SerialPort scannedPort) throws InterruptedException {
        try {
            Thread.sleep(125L);
            Logging.main("Issuing :CM command to clear all pointers...");
            WriteComm.main(scannedPort, ReconProtocol.ClearMemoryCommand);
            Logging.main(ReconProtocol.ClearMemoryCommand);
            Thread.sleep(125L);
            WriteComm.main(scannedPort, ReconProtocol.CheckNewRecord);
            Thread.sleep(125L);
            String DeviceResponse = ReadComm.main(scannedPort, 19);
            String DeviceResponse_targeted = DeviceResponse.substring(0, 3);
            if (DeviceResponse_targeted.equals("=BD")) {
                Logging.main("Ambiguous =BD response from :CM command. Assume all memory pointers have been cleared?");
                Logging.main("Why are we getting =BD here? It should be =OK...");
                MainMenuUI.appUI.displayProgressLabel("All pointers probably cleared.");
            } else if (DeviceResponse_targeted.equals("=OK")) {
                Logging.main("All memory pointers have been cleared!");
                MainMenuUI.appUI.displayProgressLabel("All pointers cleared!");
            } else {
                Logging.main("Unexpected response from CRM.");
                MainMenuUI.appUI.displayProgressLabel("Unable to clear memory.");
            }
        }
        catch (InterruptedException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
    }

    public static String GetCalibrationDateAndFactors(SerialPort scannedPort) throws InterruptedException {
        try {
            Thread.sleep(125L);
            Logging.main("Issuing :RL command to determine calibration date.");
            WriteComm.main(scannedPort, ReconProtocol.ReadCalibrationFactors);
            Thread.sleep(125L);
            String DeviceResponse = ReadComm.main(scannedPort, 19);
            String DeviceResponse_targeted = DeviceResponse.substring(0, 3);
            if (DeviceResponse_targeted.equals("=RL")) {
                String[] DeviceResponse_parsed = DeviceResponse.split(",");
                String CalDate = DeviceResponse_parsed[4] + "/" + DeviceResponse_parsed[5] + "/20" + DeviceResponse_parsed[3];
                ReconProtocol.strConnectedReconCF1 = DeviceResponse_parsed[1];
                ReconProtocol.strConnectedReconCF2 = DeviceResponse_parsed[2];
                Logging.main("Calibration Date = " + CalDate);
                return CalDate;
            }
            Logging.main("Unexpected response when trying to read calibration date!");
        }
        catch (InterruptedException ex) {
            StringWriter swEx = new StringWriter();
            ex.printStackTrace(new PrintWriter(swEx));
            String strEx = swEx.toString();
            Logging.main(strEx);
        }
        Logging.main("Unable to determine calibration date!");
        return "Unknown";
    }

    static {
        userOS = System.getProperty("os.name").toLowerCase();
    }
}

